/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CopySignNode
extends BinaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<CopySignNode> TYPE = NodeClass.create(CopySignNode.class);

    public CopySignNode(ValueNode magnitude, ValueNode sign) {
        super(TYPE, CopySignNode.computeStamp(magnitude.stamp(NodeView.DEFAULT), sign.stamp(NodeView.DEFAULT)), magnitude, sign);
    }

    public static Stamp computeStamp(Stamp stampX, Stamp stampY) {
        FloatStamp floatStampX = (FloatStamp)stampX;
        FloatStamp floatStampY = (FloatStamp)stampY;
        if (floatStampX.isNaN()) {
            return stampX;
        }
        if (floatStampY.isNonNaN()) {
            if (floatStampY.lowerBound() > 0.0) {
                if (floatStampX.lowerBound() > 0.0) {
                    return floatStampX;
                }
                if (floatStampX.upperBound() < 0.0) {
                    return new FloatStamp(floatStampX.getBits(), -floatStampX.upperBound(), -floatStampX.lowerBound(), floatStampX.isNonNaN());
                }
                return new FloatStamp(floatStampX.getBits(), Math.min(-floatStampX.lowerBound(), floatStampX.upperBound()), Math.max(-floatStampX.lowerBound(), floatStampX.upperBound()), floatStampX.isNonNaN());
            }
            if (floatStampY.upperBound() < 0.0) {
                if (floatStampX.upperBound() < 0.0) {
                    return floatStampX;
                }
                if (floatStampX.lowerBound() > 0.0) {
                    return new FloatStamp(floatStampX.getBits(), -floatStampX.upperBound(), -floatStampX.lowerBound(), floatStampX.isNonNaN());
                }
                return new FloatStamp(floatStampX.getBits(), Math.min(floatStampX.lowerBound(), -floatStampX.upperBound()), Math.max(floatStampX.lowerBound(), -floatStampX.upperBound()), floatStampX.isNonNaN());
            }
        }
        return new FloatStamp(floatStampX.getBits(), Math.min(floatStampX.lowerBound(), -floatStampX.upperBound()), Math.max(-floatStampX.lowerBound(), floatStampX.upperBound()), floatStampX.isNonNaN());
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        return CopySignNode.computeStamp(stampX, stampY);
    }

    private static Node canonicalHelper(ValueNode forX, float yValue) {
        if (forX.isJavaConstant()) {
            return ConstantNode.forFloat(Math.copySign(forX.asJavaConstant().asFloat(), yValue));
        }
        ValueNode result = OrNode.create(AndNode.create(ReinterpretNode.create(JavaKind.Int, forX, NodeView.DEFAULT), ConstantNode.forInt(Integer.MAX_VALUE), NodeView.DEFAULT), ConstantNode.forInt(Float.floatToIntBits(yValue) & Integer.MIN_VALUE), NodeView.DEFAULT);
        return ReinterpretNode.create(JavaKind.Float, result, NodeView.DEFAULT);
    }

    private static Node canonicalHelper(ValueNode forX, double yValue) {
        if (forX.isJavaConstant()) {
            return ConstantNode.forDouble(Math.copySign(forX.asJavaConstant().asDouble(), yValue));
        }
        ValueNode result = OrNode.create(AndNode.create(ReinterpretNode.create(JavaKind.Long, forX, NodeView.DEFAULT), ConstantNode.forLong(Long.MAX_VALUE), NodeView.DEFAULT), ConstantNode.forLong(Double.doubleToLongBits(yValue) & Long.MIN_VALUE), NodeView.DEFAULT);
        return ReinterpretNode.create(JavaKind.Double, result, NodeView.DEFAULT);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        FloatStamp floatStampY = (FloatStamp)forY.stamp(NodeView.DEFAULT);
        switch (forX.getStackKind()) {
            case Float: {
                if (forY.isJavaConstant()) {
                    return CopySignNode.canonicalHelper(forX, forY.asJavaConstant().asFloat());
                }
                if (!floatStampY.isNonNaN()) break;
                if (floatStampY.lowerBound() > 0.0) {
                    return CopySignNode.canonicalHelper(forX, 1.0f);
                }
                if (!(floatStampY.upperBound() < 0.0)) break;
                return CopySignNode.canonicalHelper(forX, -1.0f);
            }
            case Double: {
                if (forY.isJavaConstant()) {
                    return CopySignNode.canonicalHelper(forX, forY.asJavaConstant().asDouble());
                }
                if (!floatStampY.isNonNaN()) break;
                if (floatStampY.lowerBound() > 0.0) {
                    return CopySignNode.canonicalHelper(forX, 1.0);
                }
                if (!(floatStampY.upperBound() < 0.0)) break;
                return CopySignNode.canonicalHelper(forX, -1.0);
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitMathCopySign(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

