/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;

final class RegisterVerifier {
    LinearScan allocator;
    ArrayList<AbstractBlockBase<?>> workList;
    BlockMap<Interval[]> savedStates;

    Interval intervalAt(Value operand) {
        return this.allocator.intervalFor(operand);
    }

    int stateSize() {
        return this.allocator.maxRegisterNumber() + 1;
    }

    Interval[] stateForBlock(AbstractBlockBase<?> block) {
        return this.savedStates.get(block);
    }

    void setStateForBlock(AbstractBlockBase<?> block, Interval[] savedState) {
        this.savedStates.put(block, savedState);
    }

    void addToWorkList(AbstractBlockBase<?> block) {
        if (!this.workList.contains(block)) {
            this.workList.add(block);
        }
    }

    RegisterVerifier(LinearScan allocator) {
        this.allocator = allocator;
        this.workList = new ArrayList(16);
        this.savedStates = new BlockMap(allocator.getLIR().getControlFlowGraph());
    }

    void verify(AbstractBlockBase<?> start) {
        DebugContext debug = this.allocator.getDebug();
        try (DebugContext.Scope s = debug.scope("RegisterVerifier");){
            Interval[] inputState = new Interval[this.stateSize()];
            this.setStateForBlock(start, inputState);
            this.addToWorkList(start);
            do {
                AbstractBlockBase<?> block = this.workList.get(0);
                this.workList.remove(0);
                this.processBlock(block);
            } while (!this.workList.isEmpty());
        }
    }

    private void processBlock(AbstractBlockBase<?> block) {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("processBlock B%d", block.getId());){
            Interval[] inputState = RegisterVerifier.copy(this.stateForBlock(block));
            try (Indent indent2 = debug.logAndIndent("Input-State of intervals:");){
                this.printState(inputState);
            }
            this.processOperations(block, inputState);
            indent2 = debug.logAndIndent("Output-State of intervals:");
            try {
                this.printState(inputState);
            }
            finally {
                if (indent2 != null) {
                    indent2.close();
                }
            }
            for (AbstractBlockBase succ : block.getSuccessors()) {
                this.processSuccessor(succ, inputState);
            }
        }
    }

    protected void printState(Interval[] inputState) {
        DebugContext debug = this.allocator.getDebug();
        for (int i = 0; i < this.stateSize(); ++i) {
            Register reg = this.allocator.getRegisters().get(i);
            assert (reg.number == i);
            if (inputState[i] != null) {
                debug.log(" %6s %4d  --  %s", reg, (Object)inputState[i].operandNumber, (Object)inputState[i]);
                continue;
            }
            debug.log(" %6s   __", reg);
        }
    }

    private void processSuccessor(AbstractBlockBase<?> block, Interval[] inputState) {
        DebugContext debug = this.allocator.getDebug();
        Interval[] savedState = this.stateForBlock(block);
        if (savedState != null) {
            boolean savedStateCorrect = true;
            for (int i = 0; i < this.stateSize(); ++i) {
                if (inputState[i] == savedState[i] || savedState[i] == null) continue;
                savedStateCorrect = false;
                savedState[i] = null;
                debug.log("processSuccessor B%d: invalidating slot %d", block.getId(), i);
            }
            if (savedStateCorrect) {
                debug.log("processSuccessor B%d: previous visit already correct", block.getId());
            } else {
                debug.log("processSuccessor B%d: must re-visit because input state changed", block.getId());
                this.addToWorkList(block);
            }
        } else {
            debug.log("processSuccessor B%d: initial visit", block.getId());
            this.setStateForBlock(block, RegisterVerifier.copy(inputState));
            this.addToWorkList(block);
        }
    }

    static Interval[] copy(Interval[] inputState) {
        return (Interval[])inputState.clone();
    }

    static void statePut(DebugContext debug, Interval[] inputState, Value location, Interval interval) {
        if (location != null && ValueUtil.isRegister((Value)location)) {
            Register reg = ValueUtil.asRegister((Value)location);
            int regNum = reg.number;
            if (interval != null) {
                debug.log("%s = %s", (Object)reg, (Object)interval.operand);
            } else if (inputState[regNum] != null) {
                debug.log("%s = null", reg);
            }
            inputState[regNum] = interval;
        }
    }

    static boolean checkState(AbstractBlockBase<?> block, LIRInstruction op, Interval[] inputState, Value operand, Value reg, Interval interval) {
        if (reg != null && ValueUtil.isRegister((Value)reg) && inputState[ValueUtil.asRegister((Value)reg).number] != interval) {
            throw new GraalError("Error in register allocation: operation (%s) in block %s expected register %s (operand %s) to contain the value of interval %s but data-flow says it contains interval %s", op, block, reg, operand, interval, inputState[ValueUtil.asRegister((Value)reg).number]);
        }
        return true;
    }

    void processOperations(final AbstractBlockBase<?> block, final Interval[] inputState) {
        ArrayList<LIRInstruction> ops = this.allocator.getLIR().getLIRforBlock(block);
        DebugContext debug = this.allocator.getDebug();
        InstructionValueConsumer useConsumer = new InstructionValueConsumer(){

            @Override
            public void visitValue(LIRInstruction op, Value operand, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
                if (LinearScan.isVariableOrRegister(operand) && RegisterVerifier.this.allocator.isProcessed(operand) && op.id() != -2) {
                    Interval interval = RegisterVerifier.this.intervalAt(operand);
                    if (op.id() != -1) {
                        interval = interval.getSplitChildAtOpId(op.id(), mode, RegisterVerifier.this.allocator);
                    }
                    assert (RegisterVerifier.checkState(block, op, inputState, (Value)interval.operand, (Value)interval.location(), interval.splitParent()));
                }
            }
        };
        InstructionValueConsumer defConsumer = (op, operand, mode, flags) -> {
            if (LinearScan.isVariableOrRegister(operand) && this.allocator.isProcessed(operand)) {
                Interval interval = this.intervalAt(operand);
                if (op.id() != -1) {
                    interval = interval.getSplitChildAtOpId(op.id(), mode, this.allocator);
                }
                RegisterVerifier.statePut(debug, inputState, (Value)interval.location(), interval.splitParent());
            }
        };
        for (int i = 0; i < ops.size(); ++i) {
            LIRInstruction op2 = ops.get(i);
            if (debug.isLogEnabled()) {
                debug.log("%s", (Object)op2.toStringWithIdPrefix());
            }
            op2.visitEachInput(useConsumer);
            if (op2.destroysCallerSavedRegisters()) {
                for (Register r : this.allocator.getRegisterAllocationConfig().getRegisterConfig().getCallerSaveRegisters()) {
                    RegisterVerifier.statePut(debug, inputState, (Value)r.asValue(), null);
                }
            }
            op2.visitEachAlive(useConsumer);
            op2.visitEachTemp(defConsumer);
            op2.visitEachOutput(defConsumer);
        }
    }
}

