/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import org.graalvm.compiler.core.common.util.TypeReader;

public abstract class AbstractTypeReader
implements TypeReader {
    @Override
    public long getSV() {
        return AbstractTypeReader.decodeSign(this.read());
    }

    @Override
    public long getUV() {
        return this.read();
    }

    public static long decodeSign(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    private long read() {
        int b0 = this.getU1();
        if ((long)b0 < 192L) {
            return b0;
        }
        return this.readPacked(b0);
    }

    private long readPacked(int b0) {
        assert ((long)b0 >= 192L);
        long sum = b0;
        long shift = 6L;
        int i = 2;
        while (true) {
            long b = this.getU1();
            sum += b << (int)shift;
            if (b < 192L || (long)i == 11L) {
                return sum;
            }
            shift += 6L;
            ++i;
        }
    }
}

