/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.CodeEmissionOrder;
import org.graalvm.compiler.debug.GraalError;

public final class BasicBlockOrderUtils {
    private static final int INITIAL_WORKLIST_CAPACITY = 10;
    private static final int UNLIKELY_SUCCESSOR_STOP_FACTOR = 2;

    protected static <T extends AbstractBlockBase<T>> PriorityQueue<T> initializeWorklist(T startBlock, BitSet visitedBlocks) {
        PriorityQueue result = new PriorityQueue(10, new BlockOrderComparator());
        result.add(startBlock);
        visitedBlocks.set(startBlock.getId());
        return result;
    }

    protected static boolean checkOrder(BlockList<? extends AbstractBlockBase<?>> order, int expectedBlockCount) {
        GraalError.guarantee(order.size() == expectedBlockCount, "Number of blocks in ordering (%d) does not match expected block count (%d)", (Object)order.size(), (Object)expectedBlockCount);
        return true;
    }

    protected static <T extends AbstractBlockBase<T>> boolean checkStartBlock(BlockList<T> order, T startBlock) {
        GraalError.guarantee(order.first() == startBlock, "First block of ordering (%s) does not match expected start block %s", order.first(), startBlock);
        return true;
    }

    protected static <T extends AbstractBlockBase<T>> T findAndMarkMostLikelySuccessor(T block, BlockList<T> order, BitSet visitedBlocks) {
        return BasicBlockOrderUtils.findAndMarkMostLikelySuccessor(block, order, visitedBlocks, CodeEmissionOrder.ComputationTime.BEFORE_CONTROL_FLOW_OPTIMIZATIONS, null);
    }

    protected static <T extends AbstractBlockBase<T>> T findAndMarkMostLikelySuccessor(T block, BlockList<T> order, BitSet visitedBlocks, CodeEmissionOrder.ComputationTime computationTime, PriorityQueue<T> worklist) {
        AbstractBlockBase result = null;
        double maxSuccFrequency = -1.0;
        double maxScheduledSuccProbability = -1.0;
        boolean isTriangle = false;
        if (block.getSuccessorCount() == 2 && computationTime == CodeEmissionOrder.ComputationTime.AFTER_CONTROL_FLOW_OPTIMIZATIONS) {
            double thisFrequency = block.getRelativeFrequency();
            AbstractBlockBase left = block.getSuccessors()[0];
            AbstractBlockBase right = block.getSuccessors()[1];
            if (Math.abs(left.getRelativeFrequency() - thisFrequency) < 1.0E-4 && right.getPredecessorCount() == 1) {
                isTriangle = true;
            } else if (Math.abs(right.getRelativeFrequency() - thisFrequency) < 1.0E-4 && left.getPredecessorCount() == 1) {
                isTriangle = true;
            }
        }
        for (int i = 0; i < block.getSuccessorCount(); ++i) {
            AbstractBlockBase successor = block.getSuccessors()[i];
            double succProbability = block.getSuccessorProbabilities()[i];
            double succFrequency = successor.getRelativeFrequency();
            assert (succFrequency >= 0.0) : "Relative frequencies must be positive";
            if (computationTime == CodeEmissionOrder.ComputationTime.AFTER_CONTROL_FLOW_OPTIMIZATIONS) {
                succFrequency *= succProbability;
                if (isTriangle) {
                    succFrequency = succProbability;
                }
            }
            boolean scheduled = order.isScheduled(successor);
            if (successor.getLoopDepth() < block.getLoopDepth() || !(succFrequency >= maxSuccFrequency)) continue;
            if (!scheduled) {
                result = successor;
                maxSuccFrequency = succFrequency;
                continue;
            }
            maxScheduledSuccProbability = Math.max(maxScheduledSuccProbability, succProbability);
        }
        if (result != null && computationTime == CodeEmissionOrder.ComputationTime.AFTER_CONTROL_FLOW_OPTIMIZATIONS && maxScheduledSuccProbability >= 0.5) {
            AbstractBlockBase worklistHead = null;
            if (worklist != null) {
                for (AbstractBlockBase w : worklist) {
                    if (order.isScheduled(w)) continue;
                    worklistHead = w;
                    break;
                }
            }
            if (worklistHead != null && worklistHead.getRelativeFrequency() >= 2.0 * result.getRelativeFrequency()) {
                result = null;
            }
        }
        if (result != null) {
            visitedBlocks.set(result.getId());
        }
        return (T)result;
    }

    protected static <T extends AbstractBlockBase<T>> void enqueueSuccessors(T block, PriorityQueue<T> worklist, BitSet visitedBlocks) {
        for (AbstractBlockBase successor : block.getSuccessors()) {
            if (visitedBlocks.get(successor.getId())) continue;
            visitedBlocks.set(successor.getId());
            worklist.add(successor);
        }
    }

    protected static class BlockList<T extends AbstractBlockBase<T>> {
        private final ArrayList<T> order;
        private final BitSet scheduledBlocks;

        public BlockList(int capacity) {
            this.order = new ArrayList(capacity);
            this.scheduledBlocks = new BitSet(capacity);
        }

        public void add(T block) {
            GraalError.guarantee(!this.scheduledBlocks.get(((AbstractBlockBase)block).getId()), "Cannot insert block twice: ", block);
            this.order.add(block);
            this.scheduledBlocks.set(((AbstractBlockBase)block).getId());
        }

        public int size() {
            return this.order.size();
        }

        public T first() {
            return (T)((AbstractBlockBase)this.order.get(0));
        }

        public boolean isScheduled(T block) {
            return this.scheduledBlocks.get(((AbstractBlockBase)block).getId());
        }

        public AbstractBlockBase<?>[] toArray() {
            return this.order.toArray(new AbstractBlockBase[0]);
        }
    }

    public static class BlockOrderComparator<T extends AbstractBlockBase<T>>
    implements Comparator<T> {
        private static final double EPSILON = 1.0E-6;

        @Override
        public int compare(T a, T b) {
            int diff;
            if (((AbstractBlockBase)a).getRelativeFrequency() > 1.0E-6 && ((AbstractBlockBase)b).getRelativeFrequency() > 1.0E-6 && (diff = ((AbstractBlockBase)b).getLoopDepth() - ((AbstractBlockBase)a).getLoopDepth()) != 0) {
                return diff;
            }
            if (((AbstractBlockBase)a).getRelativeFrequency() > ((AbstractBlockBase)b).getRelativeFrequency()) {
                return -1;
            }
            return 1;
        }
    }
}

