/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import jdk.vm.ci.meta.ResolvedJavaField;

public class EnumConstantInfo
extends SizableInfo {
    private final ResolvedJavaField annotatedField;
    private final PropertyInfo<Object> valueInfo;
    private final boolean includeInLookup;
    private final Enum<?> enumValue;

    public EnumConstantInfo(String name, ResolvedJavaField annotatedField, boolean includeInLookup, Enum<?> enumValue) {
        super(name, SizableInfo.ElementKind.INTEGER);
        this.annotatedField = annotatedField;
        this.includeInLookup = includeInLookup;
        this.enumValue = enumValue;
        this.valueInfo = this.adoptChild(new PropertyInfo("value"));
    }

    public PropertyInfo<Object> getValueInfo() {
        return this.valueInfo;
    }

    public ResolvedJavaField getAnnotatedElement() {
        return this.annotatedField;
    }

    public boolean getIncludeInLookup() {
        return this.includeInLookup;
    }

    public Enum<?> getEnumValue() {
        return this.enumValue;
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitEnumConstantInfo(this);
    }
}

