/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.darwin.DarwinStat;
import com.oracle.svm.core.posix.headers.linux.LinuxStat;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

public final class PosixStat {
    public static boolean isOpen(int fd) {
        int result;
        if (Platform.includedIn(Platform.LINUX.class)) {
            LinuxStat.stat64 stat2 = (LinuxStat.stat64)StackValue.get(LinuxStat.stat64.class);
            result = LinuxStat.fstat64(fd, stat2);
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            DarwinStat.stat stat3 = (DarwinStat.stat)StackValue.get(DarwinStat.stat.class);
            result = DarwinStat.fstat(fd, stat3);
        } else {
            throw VMError.shouldNotReachHere("Unsupported platform");
        }
        return result == 0 || LibC.errno() != Errno.EBADF();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static SignedWord getSize(int fd) {
        DarwinStat.stat stat2;
        long size = -1L;
        if (Platform.includedIn(Platform.LINUX.class)) {
            LinuxStat.stat64 stat3 = (LinuxStat.stat64)StackValue.get(LinuxStat.stat64.class);
            if (LinuxStat.NoTransitions.fstat64(fd, stat3) == 0) {
                size = stat3.st_size();
            }
        } else if (Platform.includedIn(Platform.DARWIN.class) && DarwinStat.NoTransitions.fstat(fd, stat2 = (DarwinStat.stat)StackValue.get(DarwinStat.stat.class)) == 0) {
            size = stat2.st_size();
        }
        return WordFactory.signed((long)size);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private PosixStat() {
    }
}

