/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni;

import com.oracle.svm.core.jni.functions.JNIFunctionTables;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import org.graalvm.nativeimage.c.struct.SizeOf;

public class JNIThreadLocalEnvironment {
    static final FastThreadLocalBytes<JNIEnvironment> jniFunctions = (FastThreadLocalBytes)FastThreadLocalFactory.createBytes(() -> SizeOf.get(JNIEnvironment.class), "JNIThreadLocalEnvironment.jniFunctions").setMaxOffset(0);

    public static JNIEnvironment getAddress() {
        JNIEnvironment env = jniFunctions.getAddress();
        if (env.getFunctions().isNull()) {
            env.setFunctions(JNIFunctionTables.singleton().getGlobalFunctionTable());
        }
        return env;
    }
}

