/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.PredefinedClassesSupport;
import com.oracle.svm.core.util.ImageHeapMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class ClassForNameSupport {
    private final EconomicMap<String, Class<?>> knownClasses = ImageHeapMap.create();

    static ClassForNameSupport singleton() {
        return (ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        if (PredefinedClassesSupport.isPredefined(clazz)) {
            return;
        }
        ClassForNameSupport.singleton().knownClasses.put((Object)clazz.getName(), clazz);
    }

    public static Class<?> forNameOrNull(String className, ClassLoader classLoader) {
        if (className == null) {
            return null;
        }
        Class<?> result = (Class<?>)ClassForNameSupport.singleton().knownClasses.get((Object)className);
        if (result == null) {
            result = PredefinedClassesSupport.getLoadedForNameOrNull(className, classLoader);
        }
        return result;
    }
}

