/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.aarch64;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Map;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.word.LocationIdentity;

final class AArch64ArithmeticSnippets
extends ArithmeticSnippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor FMOD = SnippetRuntime.findForeignCall(AArch64ArithmeticSnippets.class, "fmod", true, new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{FMOD};
    private static final double ONE = 1.0;
    private static final double[] ZERO = new double[]{0.0, -0.0};
    private final SnippetTemplate.SnippetInfo drem;
    private final SnippetTemplate.SnippetInfo frem = this.snippet(AArch64ArithmeticSnippets.class, "fremSnippet", new LocationIdentity[0]);

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int highWord(double d) {
        return (int)(Double.doubleToRawLongBits(d) >> 32);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int lowWord(double d) {
        return (int)(Double.doubleToRawLongBits(d) & 0xFFFFFFFFFFFFFFFFL);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static double doubleFromHighLowWords(int high, int low) {
        long h = high;
        long l = (long)low & 0xFFFFFFFFL;
        return Double.longBitsToDouble(h << 32 | l);
    }

    @Uninterruptible(reason="Must not do a safepoint check.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    private static double fmod(double xx, double yy) {
        int lz;
        int hz;
        int n;
        int iy;
        int i;
        int ix;
        double x = xx;
        double y = yy;
        int hx = AArch64ArithmeticSnippets.highWord(x);
        int lx = AArch64ArithmeticSnippets.lowWord(x);
        int hy = AArch64ArithmeticSnippets.highWord(y);
        int ly = AArch64ArithmeticSnippets.lowWord(y);
        int sx = hx & Integer.MIN_VALUE;
        if (((hy &= Integer.MAX_VALUE) | ly) == 0 || (hx ^= sx) >= 0x7FF00000 || (hy | (ly | -ly) >> 31) > 0x7FF00000) {
            return x * y / (x * y);
        }
        if (hx <= hy) {
            if (hx < hy || UninterruptibleUtils.Integer.compareUnsigned(lx, ly) < 0) {
                return x;
            }
            if (lx == ly) {
                return ZERO[sx >>> 31];
            }
        }
        if (hx < 0x100000) {
            if (hx == 0) {
                ix = -1043;
                for (i = lx; i > 0; i <<= 1) {
                    --ix;
                }
            } else {
                ix = -1022;
                for (i = hx << 11; i > 0; i <<= 1) {
                    --ix;
                }
            }
        } else {
            ix = (hx >> 20) - 1023;
        }
        if (hy < 0x100000) {
            if (hy == 0) {
                iy = -1043;
                for (i = ly; i > 0; i <<= 1) {
                    --iy;
                }
            } else {
                iy = -1022;
                for (i = hy << 11; i > 0; i <<= 1) {
                    --iy;
                }
            }
        } else {
            iy = (hy >> 20) - 1023;
        }
        if (ix >= -1022) {
            hx = 0x100000 | 0xFFFFF & hx;
        } else {
            n = -1022 - ix;
            if (n <= 31) {
                hx = hx << n | lx >>> 32 - n;
                lx <<= n;
            } else {
                hx = lx << n - 32;
                lx = 0;
            }
        }
        if (iy >= -1022) {
            hy = 0x100000 | 0xFFFFF & hy;
        } else {
            n = -1022 - iy;
            if (n <= 31) {
                hy = hy << n | ly >>> 32 - n;
                ly <<= n;
            } else {
                hy = ly << n - 32;
                ly = 0;
            }
        }
        n = ix - iy;
        while (n-- != 0) {
            hz = hx - hy;
            lz = lx - ly;
            if (UninterruptibleUtils.Integer.compareUnsigned(lx, ly) < 0) {
                --hz;
            }
            if (hz < 0) {
                hx = hx + hx + (lx >>> 31);
                lx += lx;
                continue;
            }
            if ((hz | lz) == 0) {
                return ZERO[sx >>> 31];
            }
            hx = hz + hz + (lz >>> 31);
            lx = lz + lz;
        }
        hz = hx - hy;
        lz = lx - ly;
        if (UninterruptibleUtils.Integer.compareUnsigned(lx, ly) < 0) {
            --hz;
        }
        if (hz >= 0) {
            hx = hz;
            lx = lz;
        }
        if ((hx | lx) == 0) {
            return ZERO[sx >>> 31];
        }
        while (hx < 0x100000) {
            hx = hx + hx + (lx >>> 31);
            lx += lx;
            --iy;
        }
        if (iy >= -1022) {
            hx = hx - 0x100000 | iy + 1023 << 20;
            x = AArch64ArithmeticSnippets.doubleFromHighLowWords(hx | sx, lx);
        } else {
            n = -1022 - iy;
            if (n <= 20) {
                lx = lx >>> n | hx << 32 - n;
                hx >>= n;
            } else if (n <= 31) {
                lx = hx << 32 - n | lx >>> n;
                hx = sx;
            } else {
                lx = hx >> n - 32;
                hx = sx;
            }
            x = AArch64ArithmeticSnippets.doubleFromHighLowWords(hx | sx, lx);
            x *= 1.0;
        }
        return x;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native double callFmod(@Node.ConstantNodeParameter ForeignCallDescriptor var0, double var1, double var3);

    @Snippet
    protected static float fremSnippet(float x, float y) {
        return (float)AArch64ArithmeticSnippets.callFmod(FMOD, x, y);
    }

    @Snippet
    protected static double dremSnippet(double x, double y) {
        return AArch64ArithmeticSnippets.callFmod(FMOD, x, y);
    }

    public static void registerLowerings(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new AArch64ArithmeticSnippets(options, providers, lowerings);
    }

    private AArch64ArithmeticSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers, lowerings, false);
        this.drem = this.snippet(AArch64ArithmeticSnippets.class, "dremSnippet", new LocationIdentity[0]);
        lowerings.put(RemNode.class, new AArch64RemLowering());
    }

    protected class AArch64RemLowering
    implements NodeLoweringProvider<RemNode> {
        protected AArch64RemLowering() {
        }

        @Override
        public void lower(RemNode node, LoweringTool tool) {
            JavaKind kind = node.stamp(NodeView.DEFAULT).getStackKind();
            assert (kind == JavaKind.Float || kind == JavaKind.Double);
            SnippetTemplate.SnippetInfo snippet = kind == JavaKind.Float ? AArch64ArithmeticSnippets.this.frem : AArch64ArithmeticSnippets.this.drem;
            StructuredGraph graph = node.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("x", (Object)node.getX());
            args.add("y", (Object)node.getY());
            AArch64ArithmeticSnippets.this.template((ValueNode)node, args).instantiate(AArch64ArithmeticSnippets.this.providers.getMetaAccess(), (FloatingNode)node, SnippetTemplate.DEFAULT_REPLACER, tool, args);
        }
    }
}

