/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import java.util.Comparator;
import java.util.Objects;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ConditionalElement<T> {
    private final ConfigurationCondition condition;
    private final T element;

    public ConditionalElement(ConfigurationCondition condition, T element) {
        this.condition = condition;
        this.element = element;
    }

    public ConfigurationCondition getCondition() {
        return this.condition;
    }

    public T getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalElement that = (ConditionalElement)o;
        return Objects.equals(this.condition, that.condition) && Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.element);
    }

    public static <T extends Comparable<T>> Comparator<ConditionalElement<T>> comparator() {
        return (o1, o2) -> Comparator.comparing(ConditionalElement::getElement).thenComparing(ConditionalElement::getCondition).compare((ConditionalElement)o1, (ConditionalElement)o2);
    }

    public static <T> Comparator<ConditionalElement<T>> comparator(Comparator<T> elementComparator) {
        return (o1, o2) -> Comparator.comparing(ConditionalElement::getElement, elementComparator).thenComparing(ConditionalElement::getCondition).compare((ConditionalElement)o1, (ConditionalElement)o2);
    }
}

