/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.UnhandledException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.util.datastructures.ExceptionWrapper;
import org.janusgraph.util.system.ExecuteExceptionallyFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteUtil {
    private static final Logger log = LoggerFactory.getLogger(ExecuteUtil.class);

    public static void executeWithCatching(ExecuteExceptionallyFunction function, ExceptionWrapper exceptionWrapper) {
        try {
            function.execute();
        }
        catch (Throwable throwable) {
            if (exceptionWrapper.getThrowable() == null) {
                exceptionWrapper.setThrowable(throwable);
            }
            exceptionWrapper.getThrowable().addSuppressed(throwable);
        }
    }

    public static void throwIfException(ExceptionWrapper exceptionWrapper) throws BackendException {
        if (exceptionWrapper.getThrowable() != null) {
            Throwable throwable = exceptionWrapper.getThrowable();
            if (throwable instanceof BackendException) {
                throw (BackendException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new UnhandledException(throwable);
        }
    }

    public static void gracefulExecutorServiceShutdown(ExecutorService executorService, long maxWaitTime) {
        if (executorService == null || executorService.isTerminated()) {
            return;
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(maxWaitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException throwable) {
            log.warn("Termination await of the ExecutorService {} was interrupted.", (Object)executorService);
        }
        if (!executorService.isTerminated()) {
            log.warn("ExecutorService {} was not terminated in {} ms. ExecutorService will be terminated with interrupting it's managed threads.", (Object)executorService, (Object)maxWaitTime);
            executorService.shutdownNow();
        }
    }
}

