/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphProperty;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphPropertiesStep<E>
extends PropertiesStep<E>
implements HasStepFolder<Element, E>,
Profiling,
MultiQueriable<Element, E> {
    private boolean useMultiQuery = false;
    private Set<Vertex> verticesToPrefetch = new HashSet<Vertex>();
    private Map<JanusGraphVertex, Iterable<? extends JanusGraphProperty>> multiQueryResults = null;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final ArrayList<HasContainer> hasContainers;
    private int limit;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public JanusGraphPropertiesStep(PropertiesStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnType(), originalStep.getPropertyKeys());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphPropertiesStep)this).addLabel(arg_0));
        if (originalStep instanceof JanusGraphPropertiesStep) {
            JanusGraphPropertiesStep originalJanusGraphPropertiesStep = (JanusGraphPropertiesStep)originalStep;
            this.useMultiQuery = originalJanusGraphPropertiesStep.useMultiQuery;
            this.hasContainers = originalJanusGraphPropertiesStep.hasContainers;
            this.limit = originalJanusGraphPropertiesStep.limit;
        } else {
            this.hasContainers = new ArrayList();
            this.limit = Integer.MAX_VALUE;
        }
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
    }

    @Override
    public void registerFutureVertexForPrefetching(Vertex futureVertex) {
        this.verticesToPrefetch.add(futureVertex);
    }

    private <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        String[] keys = this.getPropertyKeys();
        query.keys(keys);
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    private Iterator<E> convertIterator(Iterable<? extends JanusGraphProperty> iterable) {
        if (this.getReturnType().forProperties()) {
            return iterable.iterator();
        }
        assert (this.getReturnType().forValues());
        return Iterators.transform(iterable.iterator(), Property::value);
    }

    private void prefetchNextBatch(Traverser.Admin<Element> traverser) {
        block4: {
            JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(this.getTraversal()).multiQuery(new JanusGraphVertex[0]);
            if (this.verticesToPrefetch.isEmpty()) {
                multiQuery.addVertex(JanusGraphTraversalUtil.getJanusGraphVertex(traverser));
            } else {
                multiQuery.addAllVertices(this.verticesToPrefetch);
                this.verticesToPrefetch.clear();
            }
            this.makeQuery(multiQuery);
            try {
                this.multiQueryResults = multiQuery.properties();
            }
            catch (JanusGraphException janusGraphException) {
                if (!janusGraphException.isCausedBy(InterruptedException.class)) break block4;
                throw new TraversalInterruptedException();
            }
        }
    }

    protected Iterator<E> flatMap(Traverser.Admin<Element> traverser) {
        Iterator iterator;
        if (this.useMultiQuery && traverser.get() instanceof Vertex) {
            if (this.multiQueryResults == null || !this.multiQueryResults.containsKey(traverser.get())) {
                this.prefetchNextBatch(traverser);
            }
            return this.convertIterator(this.multiQueryResults.get(traverser.get()));
        }
        if (traverser.get() instanceof JanusGraphVertex || traverser.get() instanceof WrappedVertex) {
            JanusGraphVertexQuery<? extends JanusGraphVertexQuery> query = this.makeQuery(JanusGraphTraversalUtil.getJanusGraphVertex(traverser).query());
            return this.convertIterator(query.properties());
        }
        if (this.getReturnType().forValues()) {
            assert (this.orders.isEmpty() && this.hasContainers.isEmpty());
            iterator = ((Element)traverser.get()).values(this.getPropertyKeys());
        } else {
            assert (this.orders.isEmpty());
            Iterator propertiesIt = ((Element)traverser.get()).properties(this.getPropertyKeys());
            if (this.hasContainers.isEmpty()) {
                iterator = propertiesIt;
            } else {
                LinkedList properties = new LinkedList();
                propertiesIt.forEachRemaining(e -> {
                    if (HasContainer.testAll((Property)e, this.hasContainers)) {
                        properties.add(e);
                    }
                });
                iterator = properties.iterator();
            }
        }
        if (this.limit != Integer.MAX_VALUE) {
            iterator = Iterators.limit((Iterator)iterator, (int)this.limit);
        }
        return iterator;
    }

    @Override
    public void ensureAdditionalHasContainersCapacity(int additionalSize) {
        this.hasContainers.ensureCapacity(this.hasContainers.size() + additionalSize);
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        this.hasContainers.add(hasContainer);
    }

    @Override
    public List<HasContainer> addLocalHasContainersConvertingAndPContainers(TraversalParent parent, List<HasContainer> localHasContainers) {
        throw new UnsupportedOperationException("addLocalAll is not supported for properties step.");
    }

    @Override
    public List<HasContainer> addLocalHasContainersSplittingAndPContainers(TraversalParent parent, Iterable<HasContainer> has) {
        throw new UnsupportedOperationException("addLocalAll is not supported for properties step.");
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(TraversalParent parent, List<HasContainer> hasContainers, String key, Order order) {
        throw new UnsupportedOperationException("LocalOrderBy is not supported for properties step.");
    }

    @Override
    public void setLimit(int low, int high) {
        Preconditions.checkArgument((low == 0 ? 1 : 0) != 0, (Object)"Offset is not supported for properties step.");
        this.limit = high;
    }

    @Override
    public void setLocalLimit(TraversalParent parent, List<HasContainer> hasContainers, int low, int high) {
        throw new UnsupportedOperationException("LocalLimit is not supported for properties step.");
    }

    @Override
    public int getLowLimit() {
        throw new UnsupportedOperationException("getLowLimit is not supported for properties step.");
    }

    @Override
    public int getLocalLowLimit(TraversalParent parent, List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalLowLimit is not supported for properties step.");
    }

    @Override
    public int getHighLimit() {
        return this.limit;
    }

    @Override
    public int getLocalHighLimit(TraversalParent parent, List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalHighLimit is not supported for properties step.");
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

