/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.olap.computer.PartitionVertexAggregate;
import org.janusgraph.graphdb.olap.computer.VertexState;

public class FulgoraVertexMemory<M> {
    private static final MessageScope.Global GLOBAL_SCOPE = MessageScope.Global.instance();
    private final NonBlockingHashMapLong<VertexState<M>> vertexStates;
    private final IDManager idManager;
    private final Set<VertexComputeKey> computeKeys;
    private final Map<String, Integer> elementKeyMap;
    private final MessageCombiner<M> combiner;
    private Map<MessageScope, Integer> previousScopes;
    private Map<MessageScope, Integer> currentScopes;
    private boolean inExecute;
    private final NonBlockingHashMapLong<PartitionVertexAggregate<M>> partitionVertices;

    public FulgoraVertexMemory(int numVertices, IDManager idManager, VertexProgram<M> vertexProgram) {
        Preconditions.checkArgument((numVertices >= 0 && vertexProgram != null && idManager != null ? 1 : 0) != 0);
        this.vertexStates = new NonBlockingHashMapLong(numVertices);
        this.partitionVertices = new NonBlockingHashMapLong(64);
        this.idManager = idManager;
        this.combiner = vertexProgram.getMessageCombiner().orElse(null);
        this.computeKeys = vertexProgram.getVertexComputeKeys();
        this.elementKeyMap = FulgoraVertexMemory.getIdMap(vertexProgram.getVertexComputeKeys().stream().map(VertexComputeKey::getKey).collect(Collectors.toCollection(HashSet::new)));
        this.previousScopes = Collections.emptyMap();
    }

    private VertexState<M> get(long vertexId, boolean create) {
        assert (vertexId == this.getCanonicalId(vertexId));
        VertexState state = (VertexState)this.vertexStates.get(vertexId);
        if (state == null) {
            if (!create) {
                return VertexState.EMPTY_STATE;
            }
            this.vertexStates.putIfAbsent(vertexId, new VertexState(this.elementKeyMap));
            state = (VertexState)this.vertexStates.get(vertexId);
        }
        return state;
    }

    public long getCanonicalId(long vertexId) {
        if (!this.idManager.isPartitionedVertex(vertexId)) {
            return vertexId;
        }
        return this.idManager.getCanonicalVertexId(vertexId);
    }

    public Set<MessageScope> getPreviousScopes() {
        return this.previousScopes.keySet();
    }

    public <V> void setProperty(long vertexId, String key, V value) {
        this.get(vertexId, true).setProperty(key, value, this.elementKeyMap);
    }

    public <V> V getProperty(long vertexId, String key) {
        return this.get(vertexId, false).getProperty(key, this.elementKeyMap);
    }

    void sendMessage(long vertexId, M message, MessageScope scope) {
        VertexState<M> state = this.get(vertexId, true);
        if (scope instanceof MessageScope.Global) {
            state.addMessage(message, (MessageScope)GLOBAL_SCOPE, this.currentScopes, this.combiner);
        } else {
            state.setMessage(message, scope, this.currentScopes);
        }
    }

    Stream<M> getMessage(long vertexId, MessageScope scope) {
        return this.get(vertexId, false).getMessage(FulgoraVertexMemory.normalizeScope(scope), this.previousScopes);
    }

    void completeIteration() {
        for (VertexState state : this.vertexStates.values()) {
            state.completeIteration();
        }
        this.partitionVertices.clear();
        this.previousScopes = this.currentScopes;
        this.inExecute = false;
    }

    void nextIteration(Set<MessageScope> scopes) {
        this.currentScopes = FulgoraVertexMemory.getIdMap(FulgoraVertexMemory.normalizeScopes(scopes));
        this.partitionVertices.clear();
        this.inExecute = true;
    }

    public Map<Long, Map<String, Object>> getMutableVertexProperties() {
        return Maps.transformValues(this.vertexStates, vs -> {
            HashMap map = new HashMap(this.elementKeyMap.size());
            for (String key : this.elementKeyMap.keySet()) {
                Object v = vs.getProperty(key, this.elementKeyMap);
                if (v == null) continue;
                map.put(key, v);
            }
            return map;
        });
    }

    public Set<String> getMemoryKeys() {
        return this.computeKeys.stream().filter(key -> this.inExecute || !key.isTransient()).map(VertexComputeKey::getKey).collect(Collectors.toSet());
    }

    private static MessageScope normalizeScope(MessageScope scope) {
        if (scope instanceof MessageScope.Global) {
            return GLOBAL_SCOPE;
        }
        return scope;
    }

    private static Iterable<MessageScope> normalizeScopes(Iterable<MessageScope> scopes) {
        return Iterables.transform(scopes, FulgoraVertexMemory::normalizeScope);
    }

    private PartitionVertexAggregate<M> getPartitioned(long vertexId) {
        assert (this.idManager.isPartitionedVertex(vertexId));
        PartitionVertexAggregate state = (PartitionVertexAggregate)this.partitionVertices.get(vertexId = this.getCanonicalId(vertexId));
        if (state == null) {
            this.partitionVertices.putIfAbsent(vertexId, new PartitionVertexAggregate(this.previousScopes));
            state = (PartitionVertexAggregate)this.partitionVertices.get(vertexId);
        }
        return state;
    }

    public void setLoadedProperties(long vertexId, EntryList entries) {
        this.getPartitioned(vertexId).setLoadedProperties(entries);
    }

    public void aggregateMessage(long vertexId, M message, MessageScope scope) {
        this.getPartitioned(vertexId).addMessage(message, FulgoraVertexMemory.normalizeScope(scope), this.previousScopes, this.combiner);
    }

    Stream<M> getAggregateMessage(long vertexId, MessageScope scope) {
        return this.getPartitioned(vertexId).getMessage(FulgoraVertexMemory.normalizeScope(scope), this.previousScopes);
    }

    public Map<Long, EntryList> retrievePartitionAggregates() {
        for (PartitionVertexAggregate agg : this.partitionVertices.values()) {
            agg.completeIteration();
        }
        return Maps.transformValues(this.partitionVertices, PartitionVertexAggregate::getLoadedProperties);
    }

    public static <K> Map<K, Integer> getIdMap(Iterable<K> elements) {
        HashMap<K, Integer> b = new HashMap<K, Integer>();
        int size = 0;
        for (K key : elements) {
            b.put(key, size++);
        }
        return Collections.unmodifiableMap(b);
    }
}

