/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.Map;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.MergedConfiguration;
import org.janusgraph.diskstorage.configuration.MixedConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.configuration.backend.builder.KCVSConfigurationBuilder;
import org.janusgraph.diskstorage.configuration.builder.ModifiableConfigurationBuilder;
import org.janusgraph.diskstorage.configuration.builder.ReadConfigurationBuilder;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.ttl.TTLKCVSManager;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.log.kcvs.KCVSLogManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.idmanagement.UniqueInstanceIdRetriever;

public class GraphDatabaseConfigurationBuilder {
    public GraphDatabaseConfiguration build(ReadConfiguration localConfig) {
        Preconditions.checkNotNull((Object)localConfig);
        BasicConfiguration localBasicConfiguration = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, localConfig, BasicConfiguration.Restriction.NONE);
        ModifiableConfiguration overwrite = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, new CommonsConfiguration(), BasicConfiguration.Restriction.NONE);
        KeyColumnValueStoreManager storeManager = Backend.getStorageManager(localBasicConfiguration);
        StoreFeatures storeFeatures = storeManager.getFeatures();
        ReadConfiguration globalConfig = new ReadConfigurationBuilder().buildGlobalConfiguration(localConfig, localBasicConfiguration, overwrite, storeManager, new ModifiableConfigurationBuilder(), new KCVSConfigurationBuilder());
        ModifiableConfiguration localConfiguration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, new CommonsConfiguration(), BasicConfiguration.Restriction.LOCAL);
        localConfiguration.setAll(this.getLocalSubset(localBasicConfiguration.getAll()));
        MixedConfiguration combinedConfig = new MixedConfiguration(GraphDatabaseConfiguration.ROOT_NS, globalConfig, localConfig);
        String uniqueGraphId = UniqueInstanceIdRetriever.getInstance().getOrGenerateUniqueInstanceId(combinedConfig);
        overwrite.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, uniqueGraphId, new String[0]);
        this.checkAndOverwriteTransactionLogConfiguration(combinedConfig, overwrite, storeFeatures);
        this.checkAndOverwriteSystemManagementLogConfiguration(combinedConfig, overwrite);
        MergedConfiguration configuration = new MergedConfiguration(overwrite, combinedConfig);
        return new GraphDatabaseConfiguration(localConfig, localConfiguration, uniqueGraphId, configuration);
    }

    private Map<ConfigElement.PathIdentifier, Object> getLocalSubset(Map<ConfigElement.PathIdentifier, Object> m) {
        return Maps.filterEntries(m, entry -> {
            assert (((ConfigElement.PathIdentifier)entry.getKey()).element.isOption());
            return ((ConfigOption)((ConfigElement.PathIdentifier)entry.getKey()).element).isLocal();
        });
    }

    private void checkAndOverwriteTransactionLogConfiguration(Configuration combinedConfig, ModifiableConfiguration overwrite, StoreFeatures storeFeatures) {
        Preconditions.checkArgument((boolean)combinedConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, "tx").equals(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue()), (Object)"Must use default log backend for transaction log");
        Preconditions.checkArgument((!combinedConfig.has(GraphDatabaseConfiguration.LOG_SEND_DELAY, "tx") || combinedConfig.get(GraphDatabaseConfiguration.LOG_SEND_DELAY, "tx").isZero() ? 1 : 0) != 0, (Object)"Send delay must be 0 for transaction log.");
        overwrite.set(GraphDatabaseConfiguration.LOG_SEND_DELAY, Duration.ZERO, "tx");
        if (!combinedConfig.has(GraphDatabaseConfiguration.LOG_STORE_TTL, "tx") && TTLKCVSManager.supportsAnyTTL(storeFeatures)) {
            overwrite.set(GraphDatabaseConfiguration.LOG_STORE_TTL, GraphDatabaseConfiguration.TRANSACTION_LOG_DEFAULT_TTL, "tx");
        }
    }

    private void checkAndOverwriteSystemManagementLogConfiguration(Configuration combinedConfig, ModifiableConfiguration overwrite) {
        Preconditions.checkArgument((boolean)combinedConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, "janusgraph").equals(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue()), (Object)"Must use default log backend for system log");
        Preconditions.checkArgument((!combinedConfig.has(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph") || combinedConfig.get(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph").isZero() ? 1 : 0) != 0, (Object)"Send delay must be 0 for system log.");
        overwrite.set(GraphDatabaseConfiguration.LOG_SEND_DELAY, Duration.ZERO, "janusgraph");
        Preconditions.checkArgument((!combinedConfig.has(KCVSLog.LOG_KEY_CONSISTENT, "janusgraph") || combinedConfig.get(KCVSLog.LOG_KEY_CONSISTENT, "janusgraph") != false ? 1 : 0) != 0, (Object)"Management log must be configured to be key-consistent");
        overwrite.set(KCVSLog.LOG_KEY_CONSISTENT, true, "janusgraph");
        Preconditions.checkArgument((!combinedConfig.has(KCVSLogManager.LOG_FIXED_PARTITION, "janusgraph") || combinedConfig.get(KCVSLogManager.LOG_FIXED_PARTITION, "janusgraph") != false ? 1 : 0) != 0, (Object)"Fixed partitions must be enabled for management log");
        overwrite.set(KCVSLogManager.LOG_FIXED_PARTITION, true, "janusgraph");
    }
}

