/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.janusgraph.diskstorage.configuration.ExecutorServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceBuilder.class);
    public static final int THREAD_POOL_SIZE_SCALE_FACTOR = 2;
    public static final String FIXED_THREAD_POOL_CLASS = "fixed";
    public static final String CACHED_THREAD_POOL_CLASS = "cached";

    private ExecutorServiceBuilder() {
    }

    public static ExecutorService build(ExecutorServiceConfiguration executorServiceConfiguration) {
        switch (executorServiceConfiguration.getConfigurationClass()) {
            case "fixed": {
                return ExecutorServiceBuilder.buildFixedExecutorService(ExecutorServiceBuilder.toPoolSize(executorServiceConfiguration.getCorePoolSize()), executorServiceConfiguration.getThreadFactory());
            }
            case "cached": {
                return ExecutorServiceBuilder.buildCachedExecutorService(ExecutorServiceBuilder.toPoolSize(executorServiceConfiguration.getCorePoolSize()), executorServiceConfiguration.getKeepAliveTime(), executorServiceConfiguration.getThreadFactory());
            }
        }
        return ExecutorServiceBuilder.buildExecutorServiceFromClassName(executorServiceConfiguration);
    }

    private static ExecutorService buildFixedExecutorService(int poolSize, ThreadFactory threadFactory) {
        ExecutorService executorService = threadFactory == null ? Executors.newFixedThreadPool(poolSize) : Executors.newFixedThreadPool(poolSize, threadFactory);
        log.info("Initiated fixed thread pool of size {}", (Object)poolSize);
        return executorService;
    }

    private static ExecutorService buildCachedExecutorService(int corePoolSize, Long keepAliveTime, ThreadFactory threadFactory) {
        if (keepAliveTime == null) {
            throw new IllegalArgumentException("To use cached executor service keepAliveTime must be provided.");
        }
        ThreadPoolExecutor threadPoolExecutor = threadFactory == null ? new ThreadPoolExecutor(corePoolSize, Integer.MAX_VALUE, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>()) : new ThreadPoolExecutor(corePoolSize, Integer.MAX_VALUE, (long)keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        threadPoolExecutor.prestartAllCoreThreads();
        log.info("Initiated cached thread pool with {} pre-started core size threads and keep alive time of {} ms", (Object)corePoolSize, (Object)keepAliveTime);
        return threadPoolExecutor;
    }

    private static ExecutorService buildExecutorServiceFromClassName(ExecutorServiceConfiguration executorServiceConfiguration) {
        ExecutorService executorService;
        Class<?> executorServiceClass;
        String configurationClass = executorServiceConfiguration.getConfigurationClass();
        try {
            executorServiceClass = Class.forName(configurationClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No ExecutorService class found with class name: " + configurationClass);
        }
        if (!ExecutorService.class.isAssignableFrom(executorServiceClass)) {
            throw new IllegalArgumentException(configurationClass + "isn't a subclass of " + ExecutorService.class.getName());
        }
        Constructor<?> parameterlessConstructor = null;
        Constructor<?> executorServiceConfigurationConstructor = null;
        for (Constructor<?> constructor : executorServiceClass.getDeclaredConstructors()) {
            if (constructor.getParameterCount() == 1) {
                if (!ExecutorServiceConfiguration.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                executorServiceConfigurationConstructor = constructor;
                break;
            }
            if (constructor.getParameterCount() != 0) continue;
            parameterlessConstructor = constructor;
        }
        try {
            if (executorServiceConfigurationConstructor != null) {
                executorService = (ExecutorService)executorServiceConfigurationConstructor.newInstance(executorServiceConfiguration);
            } else {
                if (parameterlessConstructor == null) {
                    throw new IllegalArgumentException(configurationClass + " has neither public constructor which accepts " + ExecutorServiceConfiguration.class.getName() + " nor parameterless public constructor.");
                }
                executorService = (ExecutorService)parameterlessConstructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Couldn't create a new instance of " + configurationClass + ". Please, check that the constructor which accepts " + ExecutorServiceConfiguration.class.getName() + " is public or there is a public parameterless constructor. If the necessary public constructor exists, please, check that invocation of this constructor doesn't throw an exception.", e);
        }
        log.info("Initiated custom executor service {}", (Object)configurationClass);
        return executorService;
    }

    private static int toPoolSize(Integer poolSize) {
        return poolSize != null ? poolSize : Runtime.getRuntime().availableProcessors() * 2;
    }
}

