/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AtomicUtils;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaField;

public class PointsToAnalysisField
extends AnalysisField {
    private final AtomicReference<StoreFieldTypeFlow.StoreInstanceFieldTypeFlow> contextInsensitiveStore = new AtomicReference();

    PointsToAnalysisField(AnalysisUniverse universe, ResolvedJavaField wrapped) {
        super(universe, wrapped);
    }

    public StoreFieldTypeFlow initAndGetContextInsensitiveStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        return AtomicUtils.produceAndSetValue(this.contextInsensitiveStore, () -> this.createContextInsensitiveStore(bb, originalLocation), t -> PointsToAnalysisField.initContextInsensitiveStore(bb, t));
    }

    private StoreFieldTypeFlow.StoreInstanceFieldTypeFlow createContextInsensitiveStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        AllInstantiatedTypeFlow objectFlow = this.declaringClass.getTypeFlow(bb, false);
        StoreFieldTypeFlow.StoreInstanceFieldTypeFlow store = new StoreFieldTypeFlow.StoreInstanceFieldTypeFlow(originalLocation, this, objectFlow);
        store.markAsContextInsensitive();
        return store;
    }

    private static void initContextInsensitiveStore(PointsToAnalysis bb, StoreFieldTypeFlow.StoreInstanceFieldTypeFlow store) {
        store.receiver().addObserver(bb, store);
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.contextInsensitiveStore.set(null);
    }
}

