/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.code.BytecodePosition;

final class BytecodeSensitiveSpecialInvokeTypeFlow
extends AbstractSpecialInvokeTypeFlow {
    private final ConcurrentMap<MethodFlowsGraph, Object> calleesFlows = new ConcurrentHashMap<MethodFlowsGraph, Object>(4, 0.75f, 1);
    private AnalysisContext callerContext;

    BytecodeSensitiveSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
    }

    private BytecodeSensitiveSpecialInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveSpecialInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = ((MethodFlowsGraphClone)methodFlows).context();
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BytecodeSensitiveSpecialInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        this.initCallee();
        TypeState invokeState = this.filterReceiverState(bb, this.getReceiver().getState());
        for (AnalysisObject receiverObject : invokeState.objects(bb)) {
            BytecodeAnalysisContext calleeContext = BytecodeSensitiveAnalysisPolicy.contextPolicy(bb).calleeContext(bb, receiverObject, (BytecodeAnalysisContext)this.callerContext, this.callee);
            MethodFlowsGraph calleeFlows = ((CallSiteSensitiveMethodTypeFlow)this.callee).addContext(bb, calleeContext, this);
            if (this.calleesFlows.putIfAbsent(calleeFlows, Boolean.TRUE) == null) {
                this.linkCallee(bb, false, calleeFlows);
            }
            this.updateReceiver(bb, calleeFlows, receiverObject);
        }
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        return new ArrayList<MethodFlowsGraph>(this.calleesFlows.keySet());
    }
}

