/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;

public abstract class DirectInvokeTypeFlow
extends InvokeTypeFlow {
    public MethodTypeFlow callee;

    protected DirectInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
    }

    protected DirectInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, DirectInvokeTypeFlow original) {
        super(bb, methodFlows, original);
    }

    @Override
    public final boolean isDirectInvoke() {
        return true;
    }

    @Override
    public Collection<AnalysisMethod> getCallees() {
        if (this.callee != null && this.callee.getMethod().isImplementationInvoked()) {
            return Collections.singletonList(this.callee.getMethod());
        }
        return Collections.emptyList();
    }
}

