/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.QuotedCSV;
import org.sparkproject.jetty.http.pathmap.PathMappings;
import org.sparkproject.jetty.server.Authentication;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.RequestLog;
import org.sparkproject.jetty.server.RequestLogWriter;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.UserIdentity;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.util.DateCache;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.component.ContainerLifeCycle;
import org.sparkproject.jetty.util.log.Log;
import org.sparkproject.jetty.util.log.Logger;

@ManagedObject(value="Custom format request log")
public class CustomRequestLog
extends ContainerLifeCycle
implements RequestLog {
    protected static final Logger LOG = Log.getLogger(CustomRequestLog.class);
    public static final String DEFAULT_DATE_FORMAT = "dd/MMM/yyyy:HH:mm:ss ZZZ";
    public static final String NCSA_FORMAT = "%{client}a - %u %t \"%r\" %s %O";
    public static final String EXTENDED_NCSA_FORMAT = "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
    private static ThreadLocal<StringBuilder> _buffers = ThreadLocal.withInitial(() -> new StringBuilder(256));
    private String[] _ignorePaths;
    private transient PathMappings<String> _ignorePathMap;
    private RequestLog.Writer _requestLogWriter;
    private final MethodHandle _logHandle;
    private final String _formatString;

    public CustomRequestLog(RequestLog.Writer writer, String formatString) {
        this._formatString = formatString;
        this._requestLogWriter = writer;
        this.addBean(this._requestLogWriter);
        try {
            this._logHandle = this.getLogHandle(formatString);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public CustomRequestLog(String file) {
        this(file, EXTENDED_NCSA_FORMAT);
    }

    public CustomRequestLog(String file, String format) {
        this(new RequestLogWriter(file), format);
    }

    @ManagedAttribute(value="The RequestLogWriter")
    public RequestLog.Writer getWriter() {
        return this._requestLogWriter;
    }

    @Override
    public void log(Request request, Response response) {
        try {
            if (this._ignorePathMap != null && this._ignorePathMap.getMatch(request.getRequestURI()) != null) {
                return;
            }
            StringBuilder sb = _buffers.get();
            sb.setLength(0);
            this._logHandle.invoke(sb, request, response);
            String log = sb.toString();
            this._requestLogWriter.write(log);
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
    }

    protected static String getAuthentication(Request request, boolean checkDeferred) {
        Authentication authentication = request.getAuthentication();
        String name = null;
        boolean deferred = false;
        if (checkDeferred && authentication instanceof Authentication.Deferred) {
            authentication = ((Authentication.Deferred)authentication).authenticate((ServletRequest)request);
            deferred = true;
        }
        if (authentication instanceof Authentication.User) {
            name = ((Authentication.User)authentication).getUserIdentity().getUserPrincipal().getName();
        }
        return name == null ? null : (deferred ? "?" + name : name);
    }

    public void setIgnorePaths(String[] ignorePaths) {
        this._ignorePaths = ignorePaths;
    }

    public String[] getIgnorePaths() {
        return this._ignorePaths;
    }

    @ManagedAttribute(value="format string")
    public String getFormatString() {
        return this._formatString;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (this._ignorePaths != null && this._ignorePaths.length > 0) {
            this._ignorePathMap = new PathMappings();
            for (int i = 0; i < this._ignorePaths.length; ++i) {
                this._ignorePathMap.put(this._ignorePaths[i], this._ignorePaths[i]);
            }
        } else {
            this._ignorePathMap = null;
        }
        super.doStart();
    }

    private static void append(StringBuilder buf, String s) {
        if (s == null || s.length() == 0) {
            buf.append('-');
        } else {
            buf.append(s);
        }
    }

    private static void append(String s, StringBuilder buf) {
        CustomRequestLog.append(buf, s);
    }

    private MethodHandle getLogHandle(String formatString) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle append = MethodHandles.lookup().findStatic(CustomRequestLog.class, "append", MethodType.methodType(Void.TYPE, String.class, StringBuilder.class));
        MethodHandle logHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, "logNothing", MethodType.methodType(Void.TYPE, StringBuilder.class, Request.class, Response.class));
        List<Token> tokens = CustomRequestLog.getTokens(formatString);
        Collections.reverse(tokens);
        for (Token t : tokens) {
            if (t.isLiteralString()) {
                logHandle = this.updateLogHandle(logHandle, append, t.literal);
                continue;
            }
            logHandle = this.updateLogHandle(logHandle, append, t.code, t.arg, t.modifiers, t.negated);
        }
        return logHandle;
    }

    private static List<Token> getTokens(String formatString) {
        Pattern PATTERN = Pattern.compile("^(?:%(?<MOD>!?[0-9,]+)?(?:\\{(?<ARG>[^}]+)})?(?<CODE>(?:(?:ti)|(?:to)|[a-zA-Z%]))|(?<LITERAL>[^%]+))(?<REMAINING>.*)", 40);
        ArrayList<Token> tokens = new ArrayList<Token>();
        String remaining = formatString;
        while (remaining.length() > 0) {
            Matcher m = PATTERN.matcher(remaining);
            if (m.matches()) {
                if (m.group("CODE") != null) {
                    String code = m.group("CODE");
                    String arg = m.group("ARG");
                    String modifierString = m.group("MOD");
                    Boolean negated = false;
                    if (modifierString != null && modifierString.startsWith("!")) {
                        modifierString = modifierString.substring(1);
                        negated = true;
                    }
                    List<String> modifiers = new QuotedCSV(modifierString).getValues();
                    tokens.add(new Token(code, arg, modifiers, negated));
                } else if (m.group("LITERAL") != null) {
                    String literal = m.group("LITERAL");
                    tokens.add(new Token(literal));
                } else {
                    throw new IllegalStateException("formatString parsing error");
                }
                remaining = m.group("REMAINING");
                continue;
            }
            throw new IllegalArgumentException("Invalid format string");
        }
        return tokens;
    }

    private MethodHandle updateLogHandle(MethodHandle logHandle, MethodHandle append, String literal) {
        return MethodHandles.foldArguments(logHandle, MethodHandles.dropArguments(MethodHandles.dropArguments(append.bindTo(literal), 1, new Class[]{Request.class}), 2, new Class[]{Response.class}));
    }

    private static boolean modify(List<String> modifiers, Boolean negated, StringBuilder b, Request request, Response response) {
        String responseCode = Integer.toString(response.getStatus());
        if (negated.booleanValue()) {
            return !modifiers.contains(responseCode);
        }
        return modifiers.contains(responseCode);
    }

    private MethodHandle updateLogHandle(MethodHandle logHandle, MethodHandle append, String code, String arg, List<String> modifiers, boolean negated) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle specificHandle;
        MethodType logType = MethodType.methodType(Void.TYPE, StringBuilder.class, Request.class, Response.class);
        MethodType logTypeArg = MethodType.methodType(Void.TYPE, String.class, StringBuilder.class, Request.class, Response.class);
        switch (code) {
            case "%": {
                specificHandle = MethodHandles.dropArguments(MethodHandles.dropArguments(append.bindTo("%"), 1, new Class[]{Request.class}), 2, new Class[]{Response.class});
                break;
            }
            case "a": {
                String method;
                if (arg == null || arg.isEmpty()) {
                    arg = "server";
                }
                switch (arg) {
                    case "server": {
                        method = "logServerHost";
                        break;
                    }
                    case "client": {
                        method = "logClientHost";
                        break;
                    }
                    case "local": {
                        method = "logLocalHost";
                        break;
                    }
                    case "remote": {
                        method = "logRemoteHost";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid arg for %a");
                    }
                }
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "p": {
                String method;
                if (arg == null || arg.isEmpty()) {
                    arg = "server";
                }
                switch (arg) {
                    case "server": {
                        method = "logServerPort";
                        break;
                    }
                    case "client": {
                        method = "logClientPort";
                        break;
                    }
                    case "local": {
                        method = "logLocalPort";
                        break;
                    }
                    case "remote": {
                        method = "logRemotePort";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid arg for %p");
                    }
                }
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "I": {
                String method;
                if (arg == null || arg.isEmpty()) {
                    method = "logBytesReceived";
                } else if (arg.equalsIgnoreCase("clf")) {
                    method = "logBytesReceivedCLF";
                } else {
                    throw new IllegalArgumentException("Invalid argument for %I");
                }
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "O": {
                String method;
                if (arg == null || arg.isEmpty()) {
                    method = "logBytesSent";
                } else if (arg.equalsIgnoreCase("clf")) {
                    method = "logBytesSentCLF";
                } else {
                    throw new IllegalArgumentException("Invalid argument for %O");
                }
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "S": {
                String method;
                if (arg == null || arg.isEmpty()) {
                    method = "logBytesTransferred";
                } else if (arg.equalsIgnoreCase("clf")) {
                    method = "logBytesTransferredCLF";
                } else {
                    throw new IllegalArgumentException("Invalid argument for %S");
                }
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "C": {
                String method;
                if (arg == null || arg.isEmpty()) {
                    method = "logRequestCookies";
                    specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                    break;
                }
                method = "logRequestCookie";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "D": {
                String method = "logLatencyMicroseconds";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "e": {
                if (arg == null || arg.isEmpty()) {
                    throw new IllegalArgumentException("No arg for %e");
                }
                String method = "logEnvironmentVar";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "f": {
                String method = "logFilename";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "H": {
                String method = "logRequestProtocol";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "i": {
                if (arg == null || arg.isEmpty()) {
                    throw new IllegalArgumentException("No arg for %i");
                }
                String method = "logRequestHeader";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "k": {
                String method = "logKeepAliveRequests";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "m": {
                String method = "logRequestMethod";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "o": {
                if (arg == null || arg.isEmpty()) {
                    throw new IllegalArgumentException("No arg for %o");
                }
                String method = "logResponseHeader";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "q": {
                String method = "logQueryString";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "r": {
                String method = "logRequestFirstLine";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "R": {
                String method = "logRequestHandler";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "s": {
                String method = "logResponseStatus";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "t": {
                String format = DEFAULT_DATE_FORMAT;
                TimeZone timeZone = TimeZone.getTimeZone("GMT");
                Locale locale = Locale.getDefault();
                if (arg != null && !arg.isEmpty()) {
                    String[] args = arg.split("\\|");
                    switch (args.length) {
                        case 1: {
                            format = args[0];
                            break;
                        }
                        case 2: {
                            format = args[0];
                            timeZone = TimeZone.getTimeZone(args[1]);
                            break;
                        }
                        case 3: {
                            format = args[0];
                            timeZone = TimeZone.getTimeZone(args[1]);
                            locale = Locale.forLanguageTag(args[2]);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Too many \"|\" characters in %t");
                        }
                    }
                }
                DateCache logDateCache = new DateCache(format, locale, timeZone);
                String method = "logRequestTime";
                MethodType logTypeDateCache = MethodType.methodType(Void.TYPE, DateCache.class, StringBuilder.class, Request.class, Response.class);
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeDateCache);
                specificHandle = specificHandle.bindTo(logDateCache);
                break;
            }
            case "T": {
                String method;
                if (arg == null) {
                    arg = "s";
                }
                switch (arg) {
                    case "s": {
                        method = "logLatencySeconds";
                        break;
                    }
                    case "us": {
                        method = "logLatencyMicroseconds";
                        break;
                    }
                    case "ms": {
                        method = "logLatencyMilliseconds";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid arg for %T");
                    }
                }
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "u": {
                String method = arg == null || arg.isEmpty() ? "logRequestAuthenticationWithDeferred" : "logRequestAuthentication";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "U": {
                String method = "logUrlRequestPath";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "X": {
                String method = "logConnectionStatus";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logType);
                break;
            }
            case "ti": {
                if (arg == null || arg.isEmpty()) {
                    throw new IllegalArgumentException("No arg for %ti");
                }
                String method = "logRequestTrailer";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            case "to": {
                if (arg == null || arg.isEmpty()) {
                    throw new IllegalArgumentException("No arg for %to");
                }
                String method = "logResponseTrailer";
                specificHandle = MethodHandles.lookup().findStatic(CustomRequestLog.class, method, logTypeArg);
                specificHandle = specificHandle.bindTo(arg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported code %" + code);
            }
        }
        if (modifiers != null && !modifiers.isEmpty()) {
            MethodHandle modifierTest = MethodHandles.lookup().findStatic(CustomRequestLog.class, "modify", MethodType.methodType(Boolean.TYPE, List.class, Boolean.class, StringBuilder.class, Request.class, Response.class));
            MethodHandle dash = this.updateLogHandle(logHandle, append, "-");
            MethodHandle log = MethodHandles.foldArguments(logHandle, specificHandle);
            modifierTest = modifierTest.bindTo(modifiers).bindTo(negated);
            return MethodHandles.guardWithTest(modifierTest, log, dash);
        }
        return MethodHandles.foldArguments(logHandle, specificHandle);
    }

    private static void logNothing(StringBuilder b, Request request, Response response) {
    }

    private static void logServerHost(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getServerName());
    }

    private static void logClientHost(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getRemoteHost());
    }

    private static void logLocalHost(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getHttpChannel().getEndPoint().getLocalAddress().getAddress().getHostAddress());
    }

    private static void logRemoteHost(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getHttpChannel().getEndPoint().getRemoteAddress().getAddress().getHostAddress());
    }

    private static void logServerPort(StringBuilder b, Request request, Response response) {
        b.append(request.getServerPort());
    }

    private static void logClientPort(StringBuilder b, Request request, Response response) {
        b.append(request.getRemotePort());
    }

    private static void logLocalPort(StringBuilder b, Request request, Response response) {
        b.append(request.getHttpChannel().getEndPoint().getLocalAddress().getPort());
    }

    private static void logRemotePort(StringBuilder b, Request request, Response response) {
        b.append(request.getHttpChannel().getEndPoint().getRemoteAddress().getPort());
    }

    private static void logResponseSize(StringBuilder b, Request request, Response response) {
        long written = response.getHttpChannel().getBytesWritten();
        b.append(written);
    }

    private static void logResponseSizeCLF(StringBuilder b, Request request, Response response) {
        long written = response.getHttpChannel().getBytesWritten();
        if (written == 0L) {
            b.append('-');
        } else {
            b.append(written);
        }
    }

    private static void logBytesSent(StringBuilder b, Request request, Response response) {
        b.append(response.getHttpChannel().getBytesWritten());
    }

    private static void logBytesSentCLF(StringBuilder b, Request request, Response response) {
        long sent = response.getHttpChannel().getBytesWritten();
        if (sent == 0L) {
            b.append('-');
        } else {
            b.append(sent);
        }
    }

    private static void logBytesReceived(StringBuilder b, Request request, Response response) {
        b.append(request.getHttpInput().getContentConsumed());
    }

    private static void logBytesReceivedCLF(StringBuilder b, Request request, Response response) {
        long received = request.getHttpInput().getContentConsumed();
        if (received == 0L) {
            b.append('-');
        } else {
            b.append(received);
        }
    }

    private static void logBytesTransferred(StringBuilder b, Request request, Response response) {
        b.append(request.getHttpInput().getContentConsumed() + response.getHttpOutput().getWritten());
    }

    private static void logBytesTransferredCLF(StringBuilder b, Request request, Response response) {
        long transferred = request.getHttpInput().getContentConsumed() + response.getHttpOutput().getWritten();
        if (transferred == 0L) {
            b.append('-');
        } else {
            b.append(transferred);
        }
    }

    private static void logRequestCookie(String arg, StringBuilder b, Request request, Response response) {
        for (Cookie c : request.getCookies()) {
            if (!arg.equals(c.getName())) continue;
            b.append(c.getValue());
            return;
        }
        b.append('-');
    }

    private static void logRequestCookies(StringBuilder b, Request request, Response response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            b.append("-");
        } else {
            for (int i = 0; i < cookies.length; ++i) {
                if (i != 0) {
                    b.append(';');
                }
                b.append(cookies[i].getName());
                b.append('=');
                b.append(cookies[i].getValue());
            }
        }
    }

    private static void logEnvironmentVar(String arg, StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, System.getenv(arg));
    }

    private static void logFilename(StringBuilder b, Request request, Response response) {
        UserIdentity.Scope scope = request.getUserIdentityScope();
        if (scope == null || scope.getContextHandler() == null) {
            b.append('-');
        } else {
            ContextHandler context = scope.getContextHandler();
            int lengthToStrip = scope.getContextPath().length() > 1 ? scope.getContextPath().length() : 0;
            String filename = context.getServletContext().getRealPath(request.getPathInfo().substring(lengthToStrip));
            CustomRequestLog.append(b, filename);
        }
    }

    private static void logRequestProtocol(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getProtocol());
    }

    private static void logRequestHeader(String arg, StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getHeader(arg));
    }

    private static void logKeepAliveRequests(StringBuilder b, Request request, Response response) {
        long requests = request.getHttpChannel().getConnection().getMessagesIn();
        if (requests >= 0L) {
            b.append(requests);
        } else {
            b.append('-');
        }
    }

    private static void logRequestMethod(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getMethod());
    }

    private static void logResponseHeader(String arg, StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, response.getHeader(arg));
    }

    private static void logQueryString(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, "?" + request.getQueryString());
    }

    private static void logRequestFirstLine(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getMethod());
        b.append(" ");
        CustomRequestLog.append(b, request.getOriginalURI());
        b.append(" ");
        CustomRequestLog.append(b, request.getProtocol());
    }

    private static void logRequestHandler(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getServletName());
    }

    private static void logResponseStatus(StringBuilder b, Request request, Response response) {
        b.append(response.getCommittedMetaData().getStatus());
    }

    private static void logRequestTime(DateCache dateCache, StringBuilder b, Request request, Response response) {
        b.append('[');
        CustomRequestLog.append(b, dateCache.format(request.getTimeStamp()));
        b.append(']');
    }

    private static void logLatencyMicroseconds(StringBuilder b, Request request, Response response) {
        long currentTime = System.currentTimeMillis();
        long requestTime = request.getTimeStamp();
        long latency_ms = currentTime - requestTime;
        long latency_us = TimeUnit.MILLISECONDS.toMicros(latency_ms);
        b.append(latency_us);
    }

    private static void logLatencyMilliseconds(StringBuilder b, Request request, Response response) {
        long latency = System.currentTimeMillis() - request.getTimeStamp();
        b.append(latency);
    }

    private static void logLatencySeconds(StringBuilder b, Request request, Response response) {
        long latency = System.currentTimeMillis() - request.getTimeStamp();
        b.append(TimeUnit.MILLISECONDS.toSeconds(latency));
    }

    private static void logRequestAuthentication(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, CustomRequestLog.getAuthentication(request, false));
    }

    private static void logRequestAuthenticationWithDeferred(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, CustomRequestLog.getAuthentication(request, true));
    }

    private static void logUrlRequestPath(StringBuilder b, Request request, Response response) {
        CustomRequestLog.append(b, request.getRequestURI());
    }

    private static void logConnectionStatus(StringBuilder b, Request request, Response response) {
        b.append((char)(request.getHttpChannel().isResponseCompleted() ? (request.getHttpChannel().isPersistent() ? 43 : 45) : 88));
    }

    private static void logRequestTrailer(String arg, StringBuilder b, Request request, Response response) {
        HttpFields trailers = request.getTrailers();
        if (trailers != null) {
            CustomRequestLog.append(b, trailers.get(arg));
        } else {
            b.append('-');
        }
    }

    private static void logResponseTrailer(String arg, StringBuilder b, Request request, Response response) {
        Supplier<HttpFields> supplier = response.getTrailers();
        if (supplier != null) {
            HttpFields trailers = supplier.get();
            if (trailers != null) {
                CustomRequestLog.append(b, trailers.get(arg));
            } else {
                b.append('-');
            }
        } else {
            b.append("-");
        }
    }

    private static class Token {
        public final String code;
        public final String arg;
        public final List<String> modifiers;
        public final boolean negated;
        public final String literal;

        public Token(String code, String arg, List<String> modifiers, boolean negated) {
            this.code = code;
            this.arg = arg;
            this.modifiers = modifiers;
            this.negated = negated;
            this.literal = null;
        }

        public Token(String literal) {
            this.code = null;
            this.arg = null;
            this.modifiers = null;
            this.negated = false;
            this.literal = literal;
        }

        public boolean isLiteralString() {
            return this.literal != null;
        }

        public boolean isPercentCode() {
            return this.code != null;
        }
    }
}

