/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.slf4j.Logger;
import org.sparkproject.guava.collect.ConcurrentHashMultiset;
import org.sparkproject.guava.collect.ImmutableMultiset;
import org.sparkproject.guava.collect.Multiset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\r\u001b\u0001i\u0011\u0003\"B\u0018\u0001\t\u0003\tT\u0001\u0002\u001b\u0001\tUBa\u0001\u000f\u0001!\u0002\u0013I\u0004BB+\u0001A\u0003%a\u000b\u0003\u0004d\u0001\u0001\u0006I\u0001\u001a\u0005\u0006e\u0002!\ta\u001d\u0005\u0006s\u0002!IA\u001f\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u001f\u0001\u0011\u0013!C\u0001\u0003#Aq!!\n\u0001\t\u0003\t9\u0003C\u0005\u0002.\u0001\t\n\u0011\"\u0001\u0002\u0012!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002\u0002CA\u001b\u0001\u0011\u0005!$a\u000e\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003\"CA&\u0001E\u0005I\u0011AA'\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!a\u0017\u0001\t\u0003\ti\u0006\u0003\u0005\u0002z\u0001!\tAGA>\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fC\u0001\"!#\u0001\t\u0003Q\u00121\u0012\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!a)\u0001\t\u0003\t)K\u0001\tCY>\u001c7.\u00138g_6\u000bg.Y4fe*\u00111\u0004H\u0001\bgR|'/Y4f\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\u000f\u0002\u0011%tG/\u001a:oC2L!AL\u0016\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u00013!\t\u0019\u0004!D\u0001\u001b\u00055!\u0016m]6BiR,W\u000e\u001d;JIB\u0011AEN\u0005\u0003o\u0015\u0012A\u0001T8oO\u0006)\u0011N\u001c4pgB!!hP!E\u001b\u0005Y$B\u0001\u001f>\u0003\u001diW\u000f^1cY\u0016T!AP\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Aw\t9\u0001*Y:i\u001b\u0006\u0004\bCA\u001aC\u0013\t\u0019%DA\u0004CY>\u001c7.\u00133\u0011\u0005M*\u0015B\u0001$\u001b\u0005%\u0011En\\2l\u0013:4w\u000e\u000b\u0003\u0004\u0011J\u001b\u0006CA%Q\u001b\u0005Q%BA&M\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001b:\u000b!\"\u00198o_R\fG/[8o\u0015\u0005y\u0015!\u00026bm\u0006D\u0018BA)K\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-I\u0001U\u0003\u0011!\b.[:\u0002!]\u0014\u0018\u000e^3M_\u000e\\7OQ=UCN\\'cA,Z?\u001a!\u0001\f\u0002\u0001W\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011QtH\u0017/\u0011\u0005m\u0013Q\"\u0001\u0001\u0011\u0007ij\u0016)\u0003\u0002_w\t\u00191+\u001a;\u0011\ti\u0002',Q\u0005\u0003Cn\u0012\u0001\"T;mi&l\u0015\r\u001d\u0015\u0005\t!\u00136+A\bsK\u0006$Gj\\2lg\nKH+Y:l!\u0011QtHW3\u0011\u0007\u0019|\u0017)D\u0001h\u0015\tA\u0017.A\u0004d_2dWm\u0019;\u000b\u0005)\\\u0017AB2p[6|gN\u0003\u0002m[\u00061qm\\8hY\u0016T\u0011A\\\u0001\u0004G>l\u0017B\u00019h\u0005Y\u0019uN\\2veJ,g\u000e\u001e%bg\"lU\u000f\u001c;jg\u0016$\b\u0006B\u0003I%N\u000bAB]3hSN$XM\u001d+bg.$\"\u0001^<\u0011\u0005\u0011*\u0018B\u0001<&\u0005\u0011)f.\u001b;\t\u000ba4\u0001\u0019\u0001.\u0002\u001bQ\f7o[!ui\u0016l\u0007\u000f^%e\u0003Q\u0019WO\u001d:f]R$\u0016m]6BiR,W\u000e\u001d;JIV\t!,\u0001\bm_\u000e\\gi\u001c:SK\u0006$\u0017N\\4\u0015\u000bu\f\t!!\u0002\u0011\u0007\u0011rH)\u0003\u0002\u0000K\t1q\n\u001d;j_:Da!a\u0001\t\u0001\u0004\t\u0015a\u00022m_\u000e\\\u0017\n\u001a\u0005\n\u0003\u000fA\u0001\u0013!a\u0001\u0003\u0013\t\u0001B\u00197pG.Lgn\u001a\t\u0004I\u0005-\u0011bAA\u0007K\t9!i\\8mK\u0006t\u0017\u0001\u00077pG.4uN\u001d*fC\u0012Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0003\u0016\u0005\u0003\u0013\t)b\u000b\u0002\u0002\u0018A!\u0011\u0011DA\u0011\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011!C;oG\",7m[3e\u0015\tiU%\u0003\u0003\u0002$\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qAn\\2l\r>\u0014xK]5uS:<G#B?\u0002*\u0005-\u0002BBA\u0002\u0015\u0001\u0007\u0011\tC\u0005\u0002\b)\u0001\n\u00111\u0001\u0002\n\u0005ABn\\2l\r>\u0014xK]5uS:<G\u0005Z3gCVdG\u000f\n\u001a\u0002;\u0005\u001c8/\u001a:u\u00052|7m[%t\u0019>\u001c7.\u001a3G_J<&/\u001b;j]\u001e$2\u0001RA\u001a\u0011\u0019\t\u0019\u0001\u0004a\u0001\u0003\u0006\u0019q-\u001a;\u0015\u0007u\fI\u0004\u0003\u0004\u0002\u00045\u0001\r!Q\u0001\u000eI><hn\u001a:bI\u0016dunY6\u0015\u0007Q\fy\u0004\u0003\u0004\u0002\u00049\u0001\r!Q\u0001\u0007k:dwnY6\u0015\u000bQ\f)%a\u0012\t\r\u0005\rq\u00021\u0001B\u0011!Ax\u0002%AA\u0002\u0005%\u0003c\u0001\u0013\u007f5\u0006\u0001RO\u001c7pG.$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001fRC!!\u0013\u0002\u0016\u00051Bn\\2l\u001d\u0016<(\t\\8dW\u001a{'o\u0016:ji&tw\r\u0006\u0004\u0002\n\u0005U\u0013q\u000b\u0005\u0007\u0003\u0007\t\u0002\u0019A!\t\r\u0005e\u0013\u00031\u0001E\u00031qWm\u001e\"m_\u000e\\\u0017J\u001c4p\u0003Y\u0011X\r\\3bg\u0016\fE\u000e\u001c'pG.\u001chi\u001c:UCN\\G\u0003BA0\u0003o\u0002R!!\u0019\u0002r\u0005sA!a\u0019\u0002n9!\u0011QMA6\u001b\t\t9GC\u0002\u0002jA\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0007\u0005=T%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\u0004'\u0016\f(bAA8K!)\u0001P\u0005a\u00015\u0006\u0001r-\u001a;UCN\\Gj\\2l\u0007>,h\u000e\u001e\u000b\u0005\u0003{\n\u0019\tE\u0002%\u0003\u007fJ1!!!&\u0005\rIe\u000e\u001e\u0005\u0006qN\u0001\rAW\u0001\u0005g&TX-\u0006\u0002\u0002~\u0005)r-\u001a;Ok6\u0014WM](g\u001b\u0006\u0004XI\u001c;sS\u0016\u001cX#A\u001b\u0002\u000f\u0015tGO]5fgV\u0011\u0011\u0011\u0013\t\u0007\u0003C\n\u0019*a&\n\t\u0005U\u0015Q\u000f\u0002\t\u0013R,'/\u0019;peB)A%!'B\t&\u0019\u00111T\u0013\u0003\rQ+\b\u000f\\33\u0003-\u0011X-\\8wK\ncwnY6\u0015\u0007Q\f\t\u000b\u0003\u0004\u0002\u0004]\u0001\r!Q\u0001\u0006G2,\u0017M\u001d\u000b\u0002i\u0002")
public class BlockInfoManager
implements Logging {
    @GuardedBy(value="this")
    private final HashMap<BlockId, BlockInfo> infos;
    @GuardedBy(value="this")
    private final HashMap<Object, Set<BlockId>> writeLocksByTask;
    @GuardedBy(value="this")
    private final HashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public synchronized void registerTask(long taskAttemptId) {
        Predef$.MODULE$.require(!this.readLocksByTask.contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Task attempt ").append(taskAttemptId).append(" is already registered").toString());
        this.readLocksByTask.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    public synchronized Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Task ").append(this.currentTaskAttemptId()).append(" trying to acquire read lock for ").append(blockId).toString());
        do {
            Option option;
            if (None$.MODULE$.equals(option = this.infos.get((Object)blockId))) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                BlockInfo info = (BlockInfo)some.value();
                if (info.writerTask() == BlockInfo$.MODULE$.NO_WRITER()) {
                    info.readerCount_$eq(info.readerCount() + 1);
                    ((ConcurrentHashMultiset)this.readLocksByTask.apply((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()))).add((Object)blockId);
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(this.currentTaskAttemptId()).append(" acquired read lock for ").append(blockId).toString());
                    return new Some((Object)info);
                }
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (!blocking) continue;
            this.wait();
        } while (blocking);
        return None$.MODULE$;
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public synchronized Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Task ").append(this.currentTaskAttemptId()).append(" trying to acquire write lock for ").append(blockId).toString());
        do {
            Option option;
            if (None$.MODULE$.equals(option = this.infos.get((Object)blockId))) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                BlockInfo info = (BlockInfo)some.value();
                if (info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0) {
                    info.writerTask_$eq(this.currentTaskAttemptId());
                    ((MultiMap)this.writeLocksByTask).addBinding((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Object)blockId);
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Task ").append(this.currentTaskAttemptId()).append(" acquired write lock for ").append(blockId).toString());
                    return new Some((Object)info);
                }
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (!blocking) continue;
            this.wait();
        } while (blocking);
        return None$.MODULE$;
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public synchronized BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        BlockInfo info;
        Option option = this.infos.get((Object)blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            info = (BlockInfo)some.value();
            if (info.writerTask() != this.currentTaskAttemptId()) {
                throw new SparkException(new StringBuilder(39).append("Task ").append(this.currentTaskAttemptId()).append(" has not locked block ").append(blockId).append(" for writing").toString());
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new SparkException(new StringBuilder(21).append("Block ").append(blockId).append(" does not exist").toString());
            }
            throw new MatchError((Object)option);
        }
        BlockInfo blockInfo = info;
        return blockInfo;
    }

    public synchronized Option<BlockInfo> get(BlockId blockId) {
        return this.infos.get((Object)blockId);
    }

    public synchronized void downgradeLock(BlockId blockId) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Task ").append(this.currentTaskAttemptId()).append(" downgrading write lock for ").append(blockId).toString());
        BlockInfo info = (BlockInfo)this.get(blockId).get();
        Predef$.MODULE$.require(info.writerTask() == this.currentTaskAttemptId(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Task ").append(this.currentTaskAttemptId()).append(" tried to downgrade a write lock that it does not hold on").append(" block ").append(blockId).toString());
        this.unlock(blockId, this.unlock$default$2());
        Option<BlockInfo> lockOutcome = this.lockForReading(blockId, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public synchronized void unlock(BlockId blockId, Option<Object> taskAttemptId) {
        MultiMap multiMap;
        long taskId = BoxesRunTime.unboxToLong((Object)taskAttemptId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Task ").append(taskId).append(" releasing lock for ").append(blockId).toString());
        BlockInfo info = (BlockInfo)this.get(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(16).append("Block ").append(blockId).append(" not found").toString());
        });
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            multiMap = ((MultiMap)this.writeLocksByTask).removeBinding((Object)BoxesRunTime.boxToLong((long)taskId), (Object)blockId);
        } else {
            Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Block ").append(blockId).append(" is not locked for reading").toString());
            info.readerCount_$eq(info.readerCount() - 1);
            ConcurrentHashMultiset countsForTask = (ConcurrentHashMultiset)this.readLocksByTask.apply((Object)BoxesRunTime.boxToLong((long)taskId));
            int newPinCountForTask = countsForTask.remove((Object)blockId, 1) - 1;
            Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Task ").append(taskId).append(" release lock on block ").append(blockId).append(" more times than it acquired it").toString());
            multiMap = BoxedUnit.UNIT;
        }
        this.notifyAll();
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public synchronized boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo) {
        boolean bl;
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Task ").append(this.currentTaskAttemptId()).append(" trying to put ").append(blockId).toString());
        Option<BlockInfo> option = this.lockForReading(blockId, this.lockForReading$default$2());
        if (option instanceof Some) {
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            this.infos.update((Object)blockId, (Object)newBlockInfo);
            this.lockForWriting(blockId, this.lockForWriting$default$2());
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        void var3_2;
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Multiset readLocks = (Multiset)this.readLocksByTask.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableMultiset.of());
        Iterable writeLocks = (Iterable)this.writeLocksByTask.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        writeLocks.foreach((Function1 & Serializable & scala.Serializable)blockId -> {
            $this.infos.get(blockId).foreach((Function1 & Serializable & scala.Serializable)info -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$4(taskAttemptId, info);
                return BoxedUnit.UNIT;
            });
            return blocksWithReleasedLocks.$plus$eq(blockId);
        });
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(readLocks.entrySet().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            BlockInfoManager.$anonfun$releaseAllLocksForTask$5(this, blocksWithReleasedLocks, entry);
            return BoxedUnit.UNIT;
        });
        this.notifyAll();
        return var3_2;
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)this.readLocksByTask.get((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)this.writeLocksByTask.get((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public synchronized int size() {
        return this.infos.size();
    }

    public synchronized long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.readLocksByTask.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.writeLocksByTask.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public synchronized Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.infos.toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).toIterator();
    }

    public synchronized void removeBlock(BlockId blockId) {
        BlockInfo blockInfo;
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(this.currentTaskAttemptId()).append(" trying to remove block ").append(blockId).toString());
        Option option = this.infos.get((Object)blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            blockInfo = (BlockInfo)some.value();
            if (blockInfo.writerTask() != this.currentTaskAttemptId()) {
                throw new IllegalStateException(new StringBuilder(52).append("Task ").append(this.currentTaskAttemptId()).append(" called remove() on block ").append(blockId).append(" without a write lock").toString());
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(44).append("Task ").append(this.currentTaskAttemptId()).append(" called remove() on non-existent block ").append(blockId).toString());
            }
            throw new MatchError((Object)option);
        }
        this.infos.remove((Object)blockId);
        blockInfo.readerCount_$eq(0);
        blockInfo.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        HashMap hashMap = (HashMap)((MultiMap)this.writeLocksByTask).removeBinding((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Object)blockId);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.infos.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)blockInfo -> {
            BlockInfoManager.$anonfun$clear$1(blockInfo);
            return BoxedUnit.UNIT;
        });
        this.infos.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
        this.notifyAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$4(long taskAttemptId$2, BlockInfo info) {
        Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$2);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(int lockCount$1, BlockInfo info) {
        info.readerCount_$eq(info.readerCount() - lockCount$1);
        Predef$.MODULE$.assert(info.readerCount() >= 0);
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$5(BlockInfoManager $this, ArrayBuffer blocksWithReleasedLocks$1, Multiset.Entry entry) {
        BlockId blockId = (BlockId)entry.getElement();
        int lockCount = entry.getCount();
        blocksWithReleasedLocks$1.$plus$eq((Object)blockId);
        $this.get(blockId).foreach((Function1 & Serializable & scala.Serializable)info -> {
            BlockInfoManager.$anonfun$releaseAllLocksForTask$6(lockCount, info);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$4) {
        return ((ConcurrentHashMultiset)x$4._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$5) {
        return ((TraversableOnce)x$5._2()).size();
    }

    public static final /* synthetic */ void $anonfun$clear$1(BlockInfo blockInfo) {
        blockInfo.readerCount_$eq(0);
        blockInfo.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
    }

    public BlockInfoManager() {
        Logging.$init$(this);
        this.infos = new HashMap();
        this.writeLocksByTask = new MultiMap<Object, BlockId>(null){

            public Set<BlockId> makeSet() {
                return MultiMap.makeSet$((MultiMap)this);
            }

            public MultiMap addBinding(Object key, Object value) {
                return MultiMap.addBinding$((MultiMap)this, (Object)key, (Object)value);
            }

            public MultiMap removeBinding(Object key, Object value) {
                return MultiMap.removeBinding$((MultiMap)this, (Object)key, (Object)value);
            }

            public boolean entryExists(Object key, Function1 p) {
                return MultiMap.entryExists$((MultiMap)this, (Object)key, (Function1)p);
            }
            {
                MultiMap.$init$((MultiMap)this);
            }
        };
        this.readLocksByTask = new HashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

