/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!\u0002\f\u0018\u0001]y\u0002\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000b!\u0003A\u0011A%\t\u000f5\u0003!\u0019!C\u0005\u001d\"1\u0011\r\u0001Q\u0001\n=CqA\u0019\u0001C\u0002\u0013%1\r\u0003\u0004n\u0001\u0001\u0006I\u0001\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019a\b\u0001)A\u0005a\"I\u0011\u0011\u0002\u0001C\u0002\u0013%\u00111\u0002\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u000e!I\u0011q\u0004\u0001C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002$!I\u0011q\u0005\u0001C\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002,!Q\u0011q\u0006\u0001\t\u0006\u0004%I!!\r\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003g\u0002A\u0011AA;\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!!%\u0001\t\u0003\n\u0019JA\u000bHK:,'/[2BmJ|7+\u001a:jC2L'0\u001a:\u000b\u0005aI\u0012AC:fe&\fG.\u001b>fe*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0005\u0002\u0001AA\u0019\u0011\u0005\u000b\u0016\u000e\u0003\tR!a\t\u0013\u0002\t-\u0014\u0018p\u001c\u0006\u0003K\u0019\n\u0001#Z:pi\u0016\u0014\u0018nY:pMR<\u0018M]3\u000b\u0003\u001d\n1aY8n\u0013\tI#E\u0001\u0006TKJL\u0017\r\\5{KJ\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000f\u001d,g.\u001a:jG*\u0011qfG\u0001\u0005CZ\u0014x.\u0003\u00022Y\tiq)\u001a8fe&\u001c'+Z2pe\u0012\fqa]2iK6\f7o\u0001\u0001\u0011\tUr\u0014)\u0012\b\u0003mq\u0002\"a\u000e\u001e\u000e\u0003aR!!O\u001a\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0004\u001b\u0006\u0004(BA\u001f;!\t\u00115)D\u0001;\u0013\t!%H\u0001\u0003M_:<\u0007CA\u001bG\u0013\t9\u0005I\u0001\u0004TiJLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)c\u0005CA&\u0001\u001b\u00059\u0002\"\u0002\u001a\u0003\u0001\u0004!\u0014!D2p[B\u0014Xm]:DC\u000eDW-F\u0001P!\u0011\u0001VkV.\u000e\u0003ES!AU*\u0002\u000f5,H/\u00192mK*\u0011AKO\u0001\u000bG>dG.Z2uS>t\u0017B\u0001,R\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001W-\u000e\u00039J!A\u0017\u0018\u0003\rM\u001b\u0007.Z7b!\r\u0011ELX\u0005\u0003;j\u0012Q!\u0011:sCf\u0004\"AQ0\n\u0005\u0001T$\u0001\u0002\"zi\u0016\fabY8naJ,7o]\"bG\",\u0007%A\beK\u000e|W\u000e\u001d:fgN\u001c\u0015m\u00195f+\u0005!\u0007\u0003\u0002)VK^\u0003\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u00079LwNC\u0001k\u0003\u0011Q\u0017M^1\n\u00051<'A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006\u0001B-Z2p[B\u0014Xm]:DC\u000eDW\rI\u0001\foJLG/\u001a:DC\u000eDW-F\u0001q!\u0011\u0001VkV91\u0005IT\bcA:wq6\tAO\u0003\u0002v]\u0005\u0011\u0011n\\\u0005\u0003oR\u00141\u0002R1uk6<&/\u001b;feB\u0011\u0011P\u001f\u0007\u0001\t%Y\b\"!A\u0001\u0002\u000b\u0005QPA\u0002`IE\nAb\u001e:ji\u0016\u00148)Y2iK\u0002\n2A`A\u0002!\t\u0011u0C\u0002\u0002\u0002i\u0012qAT8uQ&tw\rE\u0002C\u0003\u000bI1!a\u0002;\u0005\r\te._\u0001\fe\u0016\fG-\u001a:DC\u000eDW-\u0006\u0002\u0002\u000eA)\u0001+V,\u0002\u0010A\"\u0011\u0011CA\r!\u0015\u0019\u00181CA\f\u0013\r\t)\u0002\u001e\u0002\f\t\u0006$X/\u001c*fC\u0012,'\u000fE\u0002z\u00033!!\"a\u0007\u000b\u0003\u0003\u0005\tQ!\u0001~\u0005\ryFEM\u0001\re\u0016\fG-\u001a:DC\u000eDW\rI\u0001\u0011M&tw-\u001a:qe&tGoQ1dQ\u0016,\"!a\t\u0011\tA+v+Q\u0001\u0012M&tw-\u001a:qe&tGoQ1dQ\u0016\u0004\u0013aC:dQ\u0016l\u0017mQ1dQ\u0016,\"!a\u000b\u0011\tA+\u0016iV\u0001\rg\u000eDW-\\1DC\u000eDW\rI\u0001\u0006G>$WmY\u000b\u0003\u0003g\u0001B!!\u000e\u0002:5\u0011\u0011q\u0007\u0006\u0003kfIA!a\u000f\u00028\t\u00012i\\7qe\u0016\u001c8/[8o\u0007>$WmY\u0001\tG>l\u0007O]3tgR\u00191,!\u0011\t\r\u0005\r\u0003\u00031\u0001X\u0003\u0019\u00198\r[3nC\u0006QA-Z2p[B\u0014Xm]:\u0015\u0007]\u000bI\u0005\u0003\u0004\u0002LE\u0001\r!Z\u0001\fg\u000eDW-\\1CsR,7/\u0001\btKJL\u0017\r\\5{K\u0012\u000bG/^7\u0016\t\u0005E\u0013q\f\u000b\u0007\u0003'\nI&!\u001a\u0011\u0007\t\u000b)&C\u0002\u0002Xi\u0012A!\u00168ji\"9\u00111\f\nA\u0002\u0005u\u0013!\u00023biVl\u0007cA=\u0002`\u00119\u0011\u0011\r\nC\u0002\u0005\r$!\u0001*\u0012\u0005yT\u0003bBA4%\u0001\u0007\u0011\u0011N\u0001\u0007_V$\b/\u001e;\u0011\t\u0005-\u0014qN\u0007\u0003\u0003[R!!\u001e\u0012\n\t\u0005E\u0014Q\u000e\u0002\u0007\u001fV$\b/\u001e;\u0002!\u0011,7/\u001a:jC2L'0\u001a#biVlGc\u0001\u0016\u0002x!9\u0011\u0011P\nA\u0002\u0005m\u0014!B5oaV$\b\u0003BA6\u0003{JA!a \u0002n\t)\u0011J\u001c9vi\u0006)qO]5uKRA\u00111KAC\u0003\u001b\u000by\t\u0003\u0004$)\u0001\u0007\u0011q\u0011\t\u0004C\u0005%\u0015bAAFE\t!1J]=p\u0011\u001d\t9\u0007\u0006a\u0001\u0003SBa!a\u0017\u0015\u0001\u0004Q\u0013\u0001\u0002:fC\u0012$rAKAK\u0003/\u000bI\n\u0003\u0004$+\u0001\u0007\u0011q\u0011\u0005\b\u0003s*\u0002\u0019AA>\u0011\u001d\tY*\u0006a\u0001\u0003;\u000b!\u0002Z1uk6\u001cE.Y:t!\u0011)\u0014q\u0014\u0016\n\u0007\u0005\u0005\u0006IA\u0003DY\u0006\u001c8\u000f")
public class GenericAvroSerializer
extends Serializer<GenericRecord> {
    private CompressionCodec codec;
    private final Map<Object, String> schemas;
    private final HashMap<Schema, byte[]> compressCache;
    private final HashMap<ByteBuffer, Schema> decompressCache;
    private final HashMap<Schema, DatumWriter<?>> writerCache;
    private final HashMap<Schema, DatumReader<?>> readerCache;
    private final HashMap<Schema, Object> fingerprintCache;
    private final HashMap<Object, Schema> schemaCache;
    private volatile boolean bitmap$0;

    private HashMap<Schema, byte[]> compressCache() {
        return this.compressCache;
    }

    private HashMap<ByteBuffer, Schema> decompressCache() {
        return this.decompressCache;
    }

    private HashMap<Schema, DatumWriter<?>> writerCache() {
        return this.writerCache;
    }

    private HashMap<Schema, DatumReader<?>> readerCache() {
        return this.readerCache;
    }

    private HashMap<Schema, Object> fingerprintCache() {
        return this.fingerprintCache;
    }

    private HashMap<Object, Schema> schemaCache() {
        return this.schemaCache;
    }

    private CompressionCodec codec$lzycompute() {
        GenericAvroSerializer genericAvroSerializer = this;
        synchronized (genericAvroSerializer) {
            if (!this.bitmap$0) {
                this.codec = CompressionCodec$.MODULE$.createCodec(SparkEnv$.MODULE$.get().conf());
                this.bitmap$0 = true;
            }
        }
        return this.codec;
    }

    private CompressionCodec codec() {
        return !this.bitmap$0 ? this.codec$lzycompute() : this.codec;
    }

    public byte[] compress(Schema schema) {
        return (byte[])this.compressCache().getOrElseUpdate((Object)schema, (Function0 & Serializable & scala.Serializable)() -> {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream out = this.codec().compressedOutputStream(bos);
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.write(schema.toString().getBytes(StandardCharsets.UTF_8)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
            return bos.toByteArray();
        });
    }

    public Schema decompress(ByteBuffer schemaBytes) {
        return (Schema)this.decompressCache().getOrElseUpdate((Object)schemaBytes, (Function0 & Serializable & scala.Serializable)() -> {
            ByteArrayInputStream bis = new ByteArrayInputStream(schemaBytes.array(), schemaBytes.arrayOffset() + schemaBytes.position(), schemaBytes.remaining());
            InputStream in = this.codec().compressedInputStream(bis);
            byte[] bytes = (byte[])Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> IOUtils.toByteArray((InputStream)in), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> in.close());
            return new Schema.Parser().parse(new String(bytes, StandardCharsets.UTF_8));
        });
    }

    public <R extends GenericRecord> void serializeDatum(R datum, Output output) {
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)output, null);
        Schema schema = datum.getSchema();
        long fingerprint = BoxesRunTime.unboxToLong((Object)this.fingerprintCache().getOrElseUpdate((Object)schema, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> SchemaNormalization.parsingFingerprint64((Schema)schema)));
        Option option = this.schemas.get((Object)BoxesRunTime.boxToLong((long)fingerprint));
        if (option instanceof Some) {
            output.writeBoolean(true);
            output.writeLong(fingerprint);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            output.writeBoolean(false);
            byte[] compressedSchema = this.compress(schema);
            output.writeInt(compressedSchema.length);
            output.writeBytes(compressedSchema);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        ((DatumWriter)this.writerCache().getOrElseUpdate((Object)schema, (Function0 & Serializable & scala.Serializable)() -> GenericData.get().createDatumWriter(schema))).write(datum, (Encoder)encoder);
        encoder.flush();
    }

    public GenericRecord deserializeDatum(Input input) {
        Schema schema;
        if (input.readBoolean()) {
            long fingerprint = input.readLong();
            schema = (Schema)this.schemaCache().getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)fingerprint), (Function0 & Serializable & scala.Serializable)() -> {
                Option option = $this.schemas.get((Object)BoxesRunTime.boxToLong((long)fingerprint));
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new SparkException(new StringBuilder(203).append("Error reading attempting to read avro data -- encountered an unknown ").append("fingerprint: ").append(fingerprint).append(", not sure what schema to use.  This could happen ").append("if you registered additional schemas after starting your spark context.").toString());
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String s = (String)some.value();
                Schema schema = new Schema.Parser().parse(s);
                return schema;
            });
        } else {
            int length = input.readInt();
            schema = this.decompress(ByteBuffer.wrap(input.readBytes(length)));
        }
        Schema schema2 = schema;
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)input, null);
        return (GenericRecord)((DatumReader)this.readerCache().getOrElseUpdate((Object)schema2, (Function0 & Serializable & scala.Serializable)() -> GenericData.get().createDatumReader(schema2))).read(null, (Decoder)decoder);
    }

    public void write(Kryo kryo, Output output, GenericRecord datum) {
        this.serializeDatum(datum, output);
    }

    public GenericRecord read(Kryo kryo, Input input, Class<GenericRecord> datumClass) {
        return this.deserializeDatum(input);
    }

    public GenericAvroSerializer(Map<Object, String> schemas) {
        this.schemas = schemas;
        this.compressCache = new HashMap();
        this.decompressCache = new HashMap();
        this.writerCache = new HashMap();
        this.readerCache = new HashMap();
        this.fingerprintCache = new HashMap();
        this.schemaCache = new HashMap();
    }
}

