/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.worker;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.spark.SecurityManager;
import org.apache.spark.SecurityManager$;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.ApplicationDescription;
import org.apache.spark.deploy.Command;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.ExecutorState$;
import org.apache.spark.deploy.StandaloneResourceUtils$;
import org.apache.spark.deploy.worker.CommandUtils$;
import org.apache.spark.deploy.worker.ExecutorRunner$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.FileAppender$;
import org.slf4j.Logger;
import org.sparkproject.guava.io.Files;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEd!\u0002\"D\u0001\u0015k\u0005\u0002\u0003.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011!\u0004!\u0011!Q\u0001\nuC\u0001\"\u001b\u0001\u0003\u0006\u0004%\tA\u001b\u0005\t]\u0002\u0011\t\u0011)A\u0005W\"Aq\u000e\u0001BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003r\u0011!1\bA!b\u0001\n\u0003Q\u0007\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011a\u0004!Q1A\u0005\u0002)D\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\t\t\u0002\u0011)\u0019!C\u0001u\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\n\u0003\u000b\u0001!Q1A\u0005\u0002qC\u0011\"a\u0002\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0013\u0005%\u0001A!b\u0001\n\u0003a\u0006\"CA\u0006\u0001\t\u0005\t\u0015!\u0003^\u0011%\ti\u0001\u0001BC\u0002\u0013\u0005A\fC\u0005\u0002\u0010\u0001\u0011\t\u0011)A\u0005;\"I\u0011\u0011\u0003\u0001\u0003\u0006\u0004%\tA\u001b\u0005\n\u0003'\u0001!\u0011!Q\u0001\n-D\u0011\"!\u0006\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0013\u0005]\u0001A!A!\u0002\u0013i\u0006BCA\r\u0001\t\u0015\r\u0011\"\u0001\u0002\u001c!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!!\b\t\u0015\u0005=\u0002A!b\u0001\n\u0003\tY\u0002\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0005\u0003;A\u0011\"a\r\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0013\u0005U\u0002A!A!\u0002\u0013i\u0006BCA\u001c\u0001\t\u0005\t\u0015!\u0003\u0002:!Q\u0011\u0011\t\u0001\u0003\u0006\u0004%\t!a\u0011\t\u0015\u0005]\u0003A!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002Z\u0001\u0011\t\u0019!C\u0001\u00037B!\"!\u001c\u0001\u0005\u0003\u0007I\u0011AA8\u0011)\tY\b\u0001B\u0001B\u0003&\u0011Q\f\u0005\u000b\u0003\u000b\u0003!Q1A\u0005\u0002\u0005\u001d\u0005BCAN\u0001\t\u0005\t\u0015!\u0003\u0002\n\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005\"CAe\u0001\t\u0007I\u0011BAf\u0011!\t9\u000e\u0001Q\u0001\n\u00055\u0007\"CAm\u0001\u0001\u0007I\u0011BAn\u0011%\t\u0019\u000f\u0001a\u0001\n\u0013\t)\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0015BAo\u0011%\tY\u000f\u0001a\u0001\n\u0013\ti\u000fC\u0005\u0002v\u0002\u0001\r\u0011\"\u0003\u0002x\"A\u00111 \u0001!B\u0013\ty\u000fC\u0005\u0002~\u0002\u0001\r\u0011\"\u0003\u0002\u0000\"I!\u0011\u0003\u0001A\u0002\u0013%!1\u0003\u0005\t\u0005/\u0001\u0001\u0015)\u0003\u0003\u0002!I!\u0011\u0004\u0001A\u0002\u0013%\u0011q \u0005\n\u00057\u0001\u0001\u0019!C\u0005\u0005;A\u0001B!\t\u0001A\u0003&!\u0011\u0001\u0005\t\u0005G\u0001!\u0019!C\u0005U\"9!Q\u0005\u0001!\u0002\u0013Y\u0007\"\u0003B\u0014\u0001\u0001\u0007I\u0011\u0002B\u0015\u0011%\u0011Y\u0003\u0001a\u0001\n\u0013\u0011i\u0003C\u0004\u00032\u0001\u0001\u000b\u0015\u0002(\t\u0011\tM\u0002\u0001\"\u0001D\u0005kAqAa\u000e\u0001\t\u0013\u0011I\u0004\u0003\u0005\u0003F\u0001!\ta\u0011B\u001b\u0011!\u00119\u0005\u0001C\u0001\u0007\n%\u0003b\u0002B(\u0001\u0011%!QG\u0004\u000b\u0005#\u001a\u0015\u0011!E\u0001\u000b\nMc!\u0003\"D\u0003\u0003E\t!\u0012B+\u0011\u001d\tij\u0010C\u0001\u0005/B\u0011B!\u0017@#\u0003%\tAa\u0017\u0003\u001d\u0015CXmY;u_J\u0014VO\u001c8fe*\u0011A)R\u0001\u0007o>\u00148.\u001a:\u000b\u0005\u0019;\u0015A\u00023fa2|\u0017P\u0003\u0002I\u0013\u0006)1\u000f]1sW*\u0011!jS\u0001\u0007CB\f7\r[3\u000b\u00031\u000b1a\u001c:h'\r\u0001a\n\u0016\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0002#\u0006)1oY1mC&\u00111\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UCV\"\u0001,\u000b\u0005];\u0015\u0001C5oi\u0016\u0014h.\u00197\n\u0005e3&a\u0002'pO\u001eLgnZ\u0001\u0006CB\u0004\u0018\nZ\u0002\u0001+\u0005i\u0006C\u00010f\u001d\ty6\r\u0005\u0002a!6\t\u0011M\u0003\u0002c7\u00061AH]8pizJ!\u0001\u001a)\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003IB\u000ba!\u00199q\u0013\u0012\u0004\u0013AB3yK\u000eLE-F\u0001l!\tyE.\u0003\u0002n!\n\u0019\u0011J\u001c;\u0002\u000f\u0015DXmY%eA\u00059\u0011\r\u001d9EKN\u001cW#A9\u0011\u0005I\u001cX\"A#\n\u0005Q,%AF!qa2L7-\u0019;j_:$Um]2sSB$\u0018n\u001c8\u0002\u0011\u0005\u0004\b\u000fR3tG\u0002\nQaY8sKN\faaY8sKN\u0004\u0013AB7f[>\u0014\u00180A\u0004nK6|'/\u001f\u0011\u0016\u0003m\u0004\"\u0001`@\u000e\u0003uT!A`$\u0002\u0007I\u00048-C\u0002\u0002\u0002u\u0014aB\u00159d\u000b:$\u0007o\\5oiJ+g-A\u0004x_J\\WM\u001d\u0011\u0002\u0011]|'o[3s\u0013\u0012\f\u0011b^8sW\u0016\u0014\u0018\n\u001a\u0011\u0002\u0017],'-V5TG\",W.Z\u0001\ro\u0016\u0014W+[*dQ\u0016lW\rI\u0001\u0005Q>\u001cH/A\u0003i_N$\b%A\u0005xK\n,\u0016\u000eU8si\u0006Qq/\u001a2VSB{'\u000f\u001e\u0011\u0002\u001bA,(\r\\5d\u0003\u0012$'/Z:t\u00039\u0001XO\u00197jG\u0006#GM]3tg\u0002\n\u0011b\u001d9be.Du.\\3\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0003S>T!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\tC\u0001\u0003GS2,\u0017AC:qCJ\\\u0007j\\7fA\u0005YQ\r_3dkR|'\u000fR5s\u00031)\u00070Z2vi>\u0014H)\u001b:!\u0003%9xN]6feV\u0013H.\u0001\u0006x_J\\WM]+sY\u0002\nAaY8oMB!\u00111HA\u001f\u001b\u00059\u0015bAA \u000f\nI1\u000b]1sW\u000e{gNZ\u0001\rCB\u0004Hj\\2bY\u0012K'o]\u000b\u0003\u0003\u000b\u0002R!a\u0012\u0002RusA!!\u0013\u0002N9\u0019\u0001-a\u0013\n\u0003EK1!a\u0014Q\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0015\u0002V\t\u00191+Z9\u000b\u0007\u0005=\u0003+A\u0007baBdunY1m\t&\u00148\u000fI\u0001\u0006gR\fG/Z\u000b\u0003\u0003;\u0002B!a\u0018\u0002f9\u0019!/!\u0019\n\u0007\u0005\rT)A\u0007Fq\u0016\u001cW\u000f^8s'R\fG/Z\u0005\u0005\u0003O\nIGA\u0003WC2,X-C\u0002\u0002lA\u00131\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006I1\u000f^1uK~#S-\u001d\u000b\u0005\u0003c\n9\bE\u0002P\u0003gJ1!!\u001eQ\u0005\u0011)f.\u001b;\t\u0013\u0005e\u0014%!AA\u0002\u0005u\u0013a\u0001=%c\u000511\u000f^1uK\u0002B3AIA@!\ry\u0015\u0011Q\u0005\u0004\u0003\u0007\u0003&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0013I,7o\\;sG\u0016\u001cXCAAE!\u0019q\u00161R/\u0002\u0010&\u0019\u0011QR4\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)jR\u0001\te\u0016\u001cx.\u001e:dK&!\u0011\u0011TAJ\u0005M\u0011Vm]8ve\u000e,\u0017J\u001c4pe6\fG/[8o\u0003)\u0011Xm]8ve\u000e,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015M\u0005\u0005\u0016QUAT\u0003S\u000bY+!,\u00020\u0006E\u00161WA[\u0003o\u000bI,a/\u0002>\u0006}\u0016\u0011YAb\u0003\u000b\f9\rE\u0002\u0002$\u0002i\u0011a\u0011\u0005\u00065\u0016\u0002\r!\u0018\u0005\u0006S\u0016\u0002\ra\u001b\u0005\u0006_\u0016\u0002\r!\u001d\u0005\u0006m\u0016\u0002\ra\u001b\u0005\u0006q\u0016\u0002\ra\u001b\u0005\u0006\t\u0016\u0002\ra\u001f\u0005\u0007\u0003\u000b)\u0003\u0019A/\t\r\u0005%Q\u00051\u0001^\u0011\u0019\ti!\na\u0001;\"1\u0011\u0011C\u0013A\u0002-Da!!\u0006&\u0001\u0004i\u0006bBA\rK\u0001\u0007\u0011Q\u0004\u0005\b\u0003_)\u0003\u0019AA\u000f\u0011\u0019\t\u0019$\na\u0001;\"9\u0011qG\u0013A\u0002\u0005e\u0002bBA!K\u0001\u0007\u0011Q\t\u0005\b\u00033*\u0003\u0019AA/\u0011%\t))\nI\u0001\u0002\u0004\tI)\u0001\u0004gk2d\u0017\nZ\u000b\u0003\u0003\u001b\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f)#\u0001\u0003mC:<\u0017b\u00014\u0002R\u00069a-\u001e7m\u0013\u0012\u0004\u0013\u0001D<pe.,'\u000f\u00165sK\u0006$WCAAo!\u0011\ty-a8\n\t\u0005\u0005\u0018\u0011\u001b\u0002\u0007)\"\u0014X-\u00193\u0002!]|'o[3s)\"\u0014X-\u00193`I\u0015\fH\u0003BA9\u0003OD\u0011\"!\u001f*\u0003\u0003\u0005\r!!8\u0002\u001b]|'o[3s)\"\u0014X-\u00193!\u0003\u001d\u0001(o\\2fgN,\"!a<\u0011\t\u0005=\u0017\u0011_\u0005\u0005\u0003g\f\tNA\u0004Qe>\u001cWm]:\u0002\u0017A\u0014xnY3tg~#S-\u001d\u000b\u0005\u0003c\nI\u0010C\u0005\u0002z1\n\t\u00111\u0001\u0002p\u0006A\u0001O]8dKN\u001c\b%\u0001\bti\u0012|W\u000f^!qa\u0016tG-\u001a:\u0016\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u001bi!A!\u0002\u000b\t\t\u001d!\u0011B\u0001\bY><w-\u001b8h\u0015\r\u0011YaR\u0001\u0005kRLG.\u0003\u0003\u0003\u0010\t\u0015!\u0001\u0004$jY\u0016\f\u0005\u000f]3oI\u0016\u0014\u0018AE:uI>,H/\u00119qK:$WM]0%KF$B!!\u001d\u0003\u0016!I\u0011\u0011P\u0018\u0002\u0002\u0003\u0007!\u0011A\u0001\u0010gR$w.\u001e;BaB,g\u000eZ3sA\u0005q1\u000f\u001e3feJ\f\u0005\u000f]3oI\u0016\u0014\u0018AE:uI\u0016\u0014(/\u00119qK:$WM]0%KF$B!!\u001d\u0003 !I\u0011\u0011\u0010\u001a\u0002\u0002\u0003\u0007!\u0011A\u0001\u0010gR$WM\u001d:BaB,g\u000eZ3sA\u0005iR\tW#D+R{%k\u0018+F%6Ke*\u0011+F?RKU*R(V)~k5+\u0001\u0010F1\u0016\u001bU\u000bV(S?R+%+T%O\u0003R+u\fV%N\u000b>+FkX'TA\u0005a1\u000f[;uI><h\u000eS8pWV\ta*\u0001\ttQV$Hm\\<o\u0011>|7n\u0018\u0013fcR!\u0011\u0011\u000fB\u0018\u0011!\tIhNA\u0001\u0002\u0004q\u0015!D:ikR$wn\u001e8I_>\\\u0007%A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002r\u0005Y1.\u001b7m!J|7-Z:t)\u0011\t\tHa\u000f\t\u000f\tu\"\b1\u0001\u0003@\u00059Q.Z:tC\u001e,\u0007\u0003B(\u0003BuK1Aa\u0011Q\u0005\u0019y\u0005\u000f^5p]\u0006!1.\u001b7m\u0003M\u0019XOY:uSR,H/\u001a,be&\f'\r\\3t)\ri&1\n\u0005\u0007\u0005\u001bb\u0004\u0019A/\u0002\u0011\u0005\u0014x-^7f]R\f1CZ3uG\"\fe\u000e\u001a*v]\u0016CXmY;u_J\fa\"\u0012=fGV$xN\u001d*v]:,'\u000fE\u0002\u0002$~\u001a\"a\u0010(\u0015\u0005\tM\u0013\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007O\u000b\u0003\u0005;RC!!#\u0003`-\u0012!\u0011\r\t\u0005\u0005G\u0012i'\u0004\u0002\u0003f)!!q\rB5\u0003%)hn\u00195fG.,GMC\u0002\u0003lA\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yG!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ExecutorRunner
implements Logging {
    private final String appId;
    private final int execId;
    private final ApplicationDescription appDesc;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef worker;
    private final String workerId;
    private final String webUiScheme;
    private final String host;
    private final int webUiPort;
    private final String publicAddress;
    private final File sparkHome;
    private final File executorDir;
    private final String workerUrl;
    private final SparkConf conf;
    private final Seq<String> appLocalDirs;
    private volatile Enumeration.Value state;
    private final scala.collection.immutable.Map<String, ResourceInformation> resources;
    private final String org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    private Thread workerThread;
    private Process process;
    private FileAppender stdoutAppender;
    private FileAppender stderrAppender;
    private final int EXECUTOR_TERMINATE_TIMEOUT_MS;
    private Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static scala.collection.immutable.Map<String, ResourceInformation> $lessinit$greater$default$18() {
        return ExecutorRunner$.MODULE$.$lessinit$greater$default$18();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public int execId() {
        return this.execId;
    }

    public ApplicationDescription appDesc() {
        return this.appDesc;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef worker() {
        return this.worker;
    }

    public String workerId() {
        return this.workerId;
    }

    public String webUiScheme() {
        return this.webUiScheme;
    }

    public String host() {
        return this.host;
    }

    public int webUiPort() {
        return this.webUiPort;
    }

    public String publicAddress() {
        return this.publicAddress;
    }

    public File sparkHome() {
        return this.sparkHome;
    }

    public File executorDir() {
        return this.executorDir;
    }

    public String workerUrl() {
        return this.workerUrl;
    }

    public Seq<String> appLocalDirs() {
        return this.appLocalDirs;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public scala.collection.immutable.Map<String, ResourceInformation> resources() {
        return this.resources;
    }

    public String org$apache$spark$deploy$worker$ExecutorRunner$$fullId() {
        return this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId;
    }

    private Thread workerThread() {
        return this.workerThread;
    }

    private void workerThread_$eq(Thread x$1) {
        this.workerThread = x$1;
    }

    private Process process() {
        return this.process;
    }

    private void process_$eq(Process x$1) {
        this.process = x$1;
    }

    private FileAppender stdoutAppender() {
        return this.stdoutAppender;
    }

    private void stdoutAppender_$eq(FileAppender x$1) {
        this.stdoutAppender = x$1;
    }

    private FileAppender stderrAppender() {
        return this.stderrAppender;
    }

    private void stderrAppender_$eq(FileAppender x$1) {
        this.stderrAppender = x$1;
    }

    private int EXECUTOR_TERMINATE_TIMEOUT_MS() {
        return this.EXECUTOR_TERMINATE_TIMEOUT_MS;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    private void shutdownHook_$eq(Object x$1) {
        this.shutdownHook = x$1;
    }

    public void start() {
        this.workerThread_$eq(new Thread(this){
            private final /* synthetic */ ExecutorRunner $outer;

            public void run() {
                this.$outer.org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(19).append("ExecutorRunner for ").append($outer.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).toString());
            }
        });
        this.workerThread().start();
        this.shutdownHook_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Enumeration.Value value = this.state();
            Enumeration.Value value2 = ExecutorState$.MODULE$.LAUNCHING();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.state_$eq(ExecutorState$.MODULE$.FAILED());
            }
            this.killProcess((Option<String>)new Some((Object)"Worker shutting down"));
        }));
    }

    private void killProcess(Option<String> message) {
        Option<Object> exitCode = None$.MODULE$;
        if (this.process() != null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing process!");
            if (this.stdoutAppender() != null) {
                this.stdoutAppender().stop();
            }
            if (this.stderrAppender() != null) {
                this.stderrAppender().stop();
            }
            if ((exitCode = Utils$.MODULE$.terminateProcess(this.process(), this.EXECUTOR_TERMINATE_TIMEOUT_MS())).isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Failed to terminate process: ").append(this.process()).append(". This process will likely be orphaned.").toString());
            }
        }
        try {
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), message, exitCode));
        }
        catch (IllegalStateException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
        }
    }

    public void kill() {
        block2: {
            if (this.workerThread() == null) break block2;
            this.workerThread().interrupt();
            this.workerThread_$eq(null);
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            try {
                ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook());
            }
            catch (IllegalStateException e) {
            }
        }
    }

    public String substituteVariables(String argument) {
        String string = argument;
        String string2 = "{{WORKER_URL}}".equals(string) ? this.workerUrl() : ("{{EXECUTOR_ID}}".equals(string) ? ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString() : ("{{HOSTNAME}}".equals(string) ? this.host() : ("{{CORES}}".equals(string) ? ((Object)BoxesRunTime.boxToInteger((int)this.cores())).toString() : ("{{APP_ID}}".equals(string) ? this.appId() : string))));
        return string2;
    }

    public void org$apache$spark$deploy$worker$ExecutorRunner$$fetchAndRunExecutor() {
        try {
            Option<File> resourceFileOpt = StandaloneResourceUtils$.MODULE$.prepareResourcesFile(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), this.resources(), this.executorDir());
            Seq arguments = (Seq)this.appDesc().command().arguments().$plus$plus((GenTraversableOnce)resourceFileOpt.map((Function1 & Serializable & scala.Serializable)f -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--resourcesFile", f.getAbsolutePath()}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
            Seq subsOpts = (Seq)this.appDesc().command().javaOpts().map((Function1 & Serializable & scala.Serializable)x$1 -> Utils$.MODULE$.substituteAppNExecIds((String)x$1, this.appId(), ((Object)BoxesRunTime.boxToInteger((int)this.execId())).toString()), Seq$.MODULE$.canBuildFrom());
            Seq x$12 = arguments;
            Seq x$2 = subsOpts;
            String x$3 = this.appDesc().command().copy$default$1();
            Map<String, String> x$4 = this.appDesc().command().copy$default$3();
            Seq<String> x$5 = this.appDesc().command().copy$default$4();
            Seq<String> x$6 = this.appDesc().command().copy$default$5();
            Command subsCommand = this.appDesc().command().copy(x$3, (Seq<String>)x$12, x$4, x$5, x$6, (Seq<String>)x$2);
            ProcessBuilder builder = CommandUtils$.MODULE$.buildProcessBuilder(subsCommand, new SecurityManager(this.conf, SecurityManager$.MODULE$.$lessinit$greater$default$2(), SecurityManager$.MODULE$.$lessinit$greater$default$3()), this.memory(), this.sparkHome().getAbsolutePath(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)argument -> this.substituteVariables((String)argument), CommandUtils$.MODULE$.buildProcessBuilder$default$6(), CommandUtils$.MODULE$.buildProcessBuilder$default$7());
            List<String> command = builder.command();
            String redactedCommand = Utils$.MODULE$.redactCommandLineArgs(this.conf, (Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(command).asScala())).mkString("\"", "\" \"", "\"");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Launch command: ").append(redactedCommand).toString());
            builder.directory(this.executorDir());
            builder.environment().put("SPARK_EXECUTOR_DIRS", this.appLocalDirs().mkString(File.pathSeparator));
            builder.environment().put("SPARK_LAUNCH_WITH_SCALA", "0");
            String baseUrl = BoxesRunTime.unboxToBoolean((Object)this.conf.get(UI$.MODULE$.UI_REVERSE_PROXY())) ? new StringBuilder(44).append("/proxy/").append(this.workerId()).append("/logPage/?appId=").append(this.appId()).append("&executorId=").append(this.execId()).append("&logType=").toString() : new StringBuilder(38).append(this.webUiScheme()).append(this.publicAddress()).append(":").append(this.webUiPort()).append("/logPage/?appId=").append(this.appId()).append("&executorId=").append(this.execId()).append("&logType=").toString();
            builder.environment().put("SPARK_LOG_URL_STDERR", new StringBuilder(6).append(baseUrl).append("stderr").toString());
            builder.environment().put("SPARK_LOG_URL_STDOUT", new StringBuilder(6).append(baseUrl).append("stdout").toString());
            this.process_$eq(builder.start());
            String header = new StringOps(Predef$.MODULE$.augmentString("Spark Executor Command: %s\n%s\n\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{redactedCommand, new StringOps(Predef$.MODULE$.augmentString("=")).$times(40)}));
            File stdout = new File(this.executorDir(), "stdout");
            this.stdoutAppender_$eq(FileAppender$.MODULE$.apply(this.process().getInputStream(), stdout, this.conf));
            File stderr = new File(this.executorDir(), "stderr");
            Files.write((CharSequence)header, (File)stderr, (Charset)StandardCharsets.UTF_8);
            this.stderrAppender_$eq(FileAppender$.MODULE$.apply(this.process().getErrorStream(), stderr, this.conf));
            this.state_$eq(ExecutorState$.MODULE$.RUNNING());
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$));
            int exitCode = this.process().waitFor();
            this.state_$eq(ExecutorState$.MODULE$.EXITED());
            String message = new StringBuilder(25).append("Command exited with code ").append(exitCode).toString();
            this.worker().send(new DeployMessages.ExecutorStateChanged(this.appId(), this.execId(), this.state(), (Option<String>)new Some((Object)message), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)exitCode))));
        }
        catch (InterruptedException interrupted) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Runner thread for executor ").append(this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId()).append(" interrupted").toString());
            this.state_$eq(ExecutorState$.MODULE$.KILLED());
            this.killProcess((Option<String>)None$.MODULE$);
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error running executor", e);
            this.state_$eq(ExecutorState$.MODULE$.FAILED());
            this.killProcess((Option<String>)new Some((Object)e.toString()));
        }
    }

    public ExecutorRunner(String appId, int execId, ApplicationDescription appDesc, int cores, int memory, RpcEndpointRef worker, String workerId, String webUiScheme, String host, int webUiPort, String publicAddress, File sparkHome, File executorDir, String workerUrl, SparkConf conf, Seq<String> appLocalDirs, Enumeration.Value state, scala.collection.immutable.Map<String, ResourceInformation> resources) {
        this.appId = appId;
        this.execId = execId;
        this.appDesc = appDesc;
        this.cores = cores;
        this.memory = memory;
        this.worker = worker;
        this.workerId = workerId;
        this.webUiScheme = webUiScheme;
        this.host = host;
        this.webUiPort = webUiPort;
        this.publicAddress = publicAddress;
        this.sparkHome = sparkHome;
        this.executorDir = executorDir;
        this.workerUrl = workerUrl;
        this.conf = conf;
        this.appLocalDirs = appLocalDirs;
        this.state = state;
        this.resources = resources;
        Logging.$init$(this);
        this.org$apache$spark$deploy$worker$ExecutorRunner$$fullId = new StringBuilder(1).append(appId).append("/").append(execId).toString();
        this.workerThread = null;
        this.process = null;
        this.stdoutAppender = null;
        this.stderrAppender = null;
        this.EXECUTOR_TERMINATE_TIMEOUT_MS = 10000;
        this.shutdownHook = null;
    }
}

