/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.ApplicationStoreInfo;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.History$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u0016,\tYB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u001d9\u0007A1A\u0005\n!Da!\u001b\u0001!\u0002\u0013I\u0005b\u00026\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007W\u0002\u0001\u000b\u0011B%\t\u000f1\u0004!\u0019!C\u0005[\"1\u0011\u000f\u0001Q\u0001\n9DqA\u001d\u0001C\u0002\u0013%1\u000f\u0003\u0004~\u0001\u0001\u0006I\u0001\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003t\u0011\u0019y\b\u0001)A\u0005i\"I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111\u0001\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002\u0006!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\n\u0003s\u0002\u0011\u0013!C\u0001\u0003wBq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u001c\u0002!\t!!(\t\u0013\u0005\u001d\u0006!%A\u0005\u0002\u0005m\u0004bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u001d\t)\f\u0001C\u0001\u0003gCq!a.\u0001\t\u0013\tI\fC\u0004\u0002>\u0002!I!a0\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002H\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\n\u0003?\u0004\u0011\u0013!C\u0005\u0003wB\u0001\"!9\u0001\t\u0003Y\u00131\u001d\u0004\b\u0003\u0017\u0002\u0001aKA'\u0011%\tyE\tBC\u0002\u0013\u0005\u0001\u000eC\u0005\u0002R\t\u0012\t\u0011)A\u0005\u0013\"I\u00111\u000b\u0012\u0003\u0006\u0004%I!\u001c\u0005\n\u0003+\u0012#\u0011!Q\u0001\n9Daa\u0018\u0012\u0005\u0002\u0005]\u0003bBA/E\u0011\u0005\u0011q\f\u0005\b\u0003S\u0012C\u0011AA\u001e\u0005aA\u0015n\u001d;pef\u001cVM\u001d<fe\u0012K7o['b]\u0006<WM\u001d\u0006\u0003Y5\nq\u0001[5ti>\u0014\u0018P\u0003\u0002/_\u00051A-\u001a9m_fT!\u0001M\u0019\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0002\u0001'\r\u0001q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\nU\"A \u000b\u0005\u0001{\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\t{$a\u0002'pO\u001eLgnZ\u0001\u0005G>tg\r\u0005\u0002F\r6\tq&\u0003\u0002H_\tI1\u000b]1sW\u000e{gNZ\u0001\u0005a\u0006$\b\u000e\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006\u0011\u0011n\u001c\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0003GS2,\u0017a\u00027jgRLgn\u001a\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bqa\u001b<ti>\u0014XM\u0003\u0002X_\u0005!Q\u000f^5m\u0013\tIFKA\u0004L-N#xN]3\u0002\u000b\rdwnY6\u0011\u0005qkV\"\u0001,\n\u0005y3&!B\"m_\u000e\\\u0017A\u0002\u001fj]&$h\bF\u0003bG\u0012,g\r\u0005\u0002c\u00015\t1\u0006C\u0003D\u000b\u0001\u0007A\tC\u0003I\u000b\u0001\u0007\u0011\nC\u0003R\u000b\u0001\u0007!\u000bC\u0003[\u000b\u0001\u00071,A\u0006baB\u001cFo\u001c:f\t&\u0014X#A%\u0002\u0019\u0005\u0004\bo\u0015;pe\u0016$\u0015N\u001d\u0011\u0002\u0017Ql\u0007o\u0015;pe\u0016$\u0015N]\u0001\ri6\u00048\u000b^8sK\u0012K'\u000fI\u0001\t[\u0006DXk]1hKV\ta\u000e\u0005\u00029_&\u0011\u0001/\u000f\u0002\u0005\u0019>tw-A\u0005nCb,6/Y4fA\u0005a1-\u001e:sK:$Xk]1hKV\tA\u000f\u0005\u0002vw6\taO\u0003\u0002xq\u00061\u0011\r^8nS\u000eT!!\u001f>\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002X\u001b&\u0011AP\u001e\u0002\u000b\u0003R|W.[2M_:<\u0017!D2veJ,g\u000e^+tC\u001e,\u0007%\u0001\bd_6l\u0017\u000e\u001e;fIV\u001b\u0018mZ3\u0002\u001f\r|W.\\5ui\u0016$Wk]1hK\u0002\na!Y2uSZ,WCAA\u0003!\u001d\t9!!\u0005\u0002\u00169l!!!\u0003\u000b\t\u0005-\u0011QB\u0001\b[V$\u0018M\u00197f\u0015\r\ty!O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\n\u0003\u0013\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u00049\u0003/\tY\"!\r\n\u0007\u0005e\u0011H\u0001\u0004UkBdWM\r\t\u0005\u0003;\tYC\u0004\u0003\u0002 \u0005\u001d\u0002cAA\u0011s5\u0011\u00111\u0005\u0006\u0004\u0003K)\u0014A\u0002\u001fs_>$h(C\u0002\u0002*e\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u0011aa\u0015;sS:<'bAA\u0015sA)\u0001(a\r\u0002\u001c%\u0019\u0011QG\u001d\u0003\r=\u0003H/[8o\u0003\u001d\t7\r^5wK\u0002\n!\"\u001b8ji&\fG.\u001b>f)\t\ti\u0004E\u00029\u0003\u007fI1!!\u0011:\u0005\u0011)f.\u001b;\u0002\u000b1,\u0017m]3\u0015\r\u0005\u001d\u00131NA8!\r\tIEI\u0007\u0002\u0001\t)A*Z1tKN\u0011!eN\u0001\bi6\u0004\b+\u0019;i\u0003!!X\u000e\u001d)bi\"\u0004\u0013A\u00027fCN,G-A\u0004mK\u0006\u001cX\r\u001a\u0011\u0015\r\u0005\u001d\u0013\u0011LA.\u0011\u0019\tye\na\u0001\u0013\"1\u00111K\u0014A\u00029\faaY8n[&$H#B%\u0002b\u0005\u0015\u0004bBA2Q\u0001\u0007\u00111D\u0001\u0006CB\u0004\u0018\n\u001a\u0005\b\u0003OB\u0003\u0019AA\u0019\u0003%\tG\u000f^3naRLE-\u0001\u0005s_2d'-Y2l\u0011\u0019\tig\u0005a\u0001]\u0006aQM^3oi2{wmU5{K\"I\u0011\u0011O\n\u0011\u0002\u0003\u0007\u00111O\u0001\rSN\u001cu.\u001c9sKN\u001cX\r\u001a\t\u0004q\u0005U\u0014bAA<s\t9!i\\8mK\u0006t\u0017a\u00047fCN,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u$\u0006BA:\u0003\u007fZ#!!!\u0011\t\u0005\r\u0015QR\u0007\u0003\u0003\u000bSA!a\"\u0002\n\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017K\u0014AC1o]>$\u0018\r^5p]&!\u0011qRAC\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\n_B,gn\u0015;pe\u0016$b!!&\u0002\u0018\u0006e\u0005\u0003\u0002\u001d\u00024%Cq!a\u0019\u0016\u0001\u0004\tY\u0002C\u0004\u0002hU\u0001\r!!\r\u0002\u000fI,G.Z1tKRA\u0011QHAP\u0003C\u000b\u0019\u000bC\u0004\u0002dY\u0001\r!a\u0007\t\u000f\u0005\u001dd\u00031\u0001\u00022!I\u0011Q\u0015\f\u0011\u0002\u0003\u0007\u00111O\u0001\u0007I\u0016dW\r^3\u0002#I,G.Z1tK\u0012\"WMZ1vYR$3'A\bbaB\u0014x\u000e_5nCR,7+\u001b>f)\u0015q\u0017QVAX\u0011\u0019\ti\u0007\u0007a\u0001]\"9\u0011\u0011\u000f\rA\u0002\u0005M\u0014\u0001\u00024sK\u0016$\u0012A\\\u0001\nG>lW.\u001b;uK\u0012\f1\u0002Z3mKR,7\u000b^8sKR!\u0011QHA^\u0011\u0015A5\u00041\u0001J\u0003!i\u0017m[3S_>lG\u0003BA\u001f\u0003\u0003Da!a1\u001d\u0001\u0004q\u0017\u0001B:ju\u0016\fA\"\u00199q'R|'/\u001a)bi\"$R!SAe\u0003\u0017Dq!a\u0019\u001e\u0001\u0004\tY\u0002C\u0004\u0002hu\u0001\r!!\r\u0002!U\u0004H-\u0019;f\u0003\u000e\u001cWm]:US6,GCBA\u001f\u0003#\f\u0019\u000eC\u0004\u0002dy\u0001\r!a\u0007\t\u000f\u0005\u001dd\u00041\u0001\u00022\u0005YQ\u000f\u001d3bi\u0016,6/Y4f)\u0019\ti$!7\u0002^\"1\u00111\\\u0010A\u00029\fQ\u0001Z3mi\u0006D\u0011\"!. !\u0003\u0005\r!a\u001d\u0002+U\u0004H-\u0019;f+N\fw-\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u000511/\u001b>f\u001f\u001a$2A\\As\u0011\u0015A\u0015\u00051\u0001J\u0001")
public class HistoryServerDiskManager
implements Logging {
    private final KVStore listing;
    private final Clock clock;
    private final File appStoreDir;
    private final File tmpStoreDir;
    private final long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    private final AtomicLong currentUsage;
    private final AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    private final HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private File appStoreDir() {
        return this.appStoreDir;
    }

    private File tmpStoreDir() {
        return this.tmpStoreDir;
    }

    public long org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage;
    }

    private AtomicLong currentUsage() {
        return this.currentUsage;
    }

    public AtomicLong org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage;
    }

    public HashMap<Tuple2<String, Option<String>>, Object> org$apache$spark$deploy$history$HistoryServerDiskManager$$active() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active;
    }

    public void initialize() {
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(this.sizeOf(this.appStoreDir()), true);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.tmpStoreDir().listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$1(x$1)));
        Seq orphans = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)this.listing.view(ApplicationStoreInfo.class)).asScala()).filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)HistoryServerDiskManager.$anonfun$initialize$2(info)))).toSeq();
        orphans.foreach((Function1 & Serializable & scala.Serializable)info -> {
            this.listing.delete(info.getClass(), (Object)info.path());
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Initialized disk manager: ").append("current usage = ").append(Utils$.MODULE$.bytesToString(this.currentUsage().get())).append(", ").append("max usage = ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).toString());
    }

    public Lease lease(long eventLogSize, boolean isCompressed) {
        long needed = this.approximateSize(eventLogSize, isCompressed);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(needed);
        File tmp = Utils$.MODULE$.createTempDir(this.tmpStoreDir().getPath(), "appstore");
        Utils$.MODULE$.chmod700(tmp);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(needed, this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
        long current = this.currentUsage().get();
        if (current > this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Lease of ").append(Utils$.MODULE$.bytesToString(needed)).append(" may cause usage to exceed max ").append("(").append(Utils$.MODULE$.bytesToString(current)).append(" > ").append(Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage())).append(")").toString());
        }
        return new Lease(this, tmp, needed);
    }

    public boolean lease$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Option<File> openStore(String appId, Option<String> attemptId) {
        void var3_6;
        None$ none$;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            None$ none$2;
            File path2 = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
            if (path2.isDirectory()) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)this.sizeOf(path2)));
                none$2 = new Some((Object)path2);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ storePath = none$;
        storePath.foreach((Function1 & Serializable & scala.Serializable)path -> {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(appId, (Option<String>)attemptId);
            return BoxedUnit.UNIT;
        });
        return var3_6;
    }

    public void release(String appId, Option<String> attemptId, boolean delete) {
        Option option;
        HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
        synchronized (hashMap) {
            option = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().remove((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId));
        }
        Option oldSizeOpt = option;
        oldSizeOpt.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)oldSize -> {
            block2: {
                File path = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-oldSize, true);
                if (!path.isDirectory()) break block2;
                if (delete) {
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(path);
                } else {
                    long newSize = this.sizeOf(path);
                    ApplicationStoreInfo qual$1 = (ApplicationStoreInfo)$this.listing.read(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
                    long x$1 = newSize;
                    String x$2 = qual$1.copy$default$1();
                    long x$3 = qual$1.copy$default$2();
                    String x$4 = qual$1.copy$default$3();
                    Option<String> x$5 = qual$1.copy$default$4();
                    ApplicationStoreInfo newInfo = qual$1.copy(x$2, x$3, x$4, x$5, x$1);
                    $this.listing.write((Object)newInfo);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
                }
            }
        });
    }

    public boolean release$default$3() {
        return false;
    }

    public long approximateSize(long eventLogSize, boolean isCompressed) {
        return isCompressed ? eventLogSize * 2L : eventLogSize / 2L;
    }

    public long free() {
        return package$.MODULE$.max(this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage() - this.currentUsage().get(), 0L);
    }

    public long committed() {
        return this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get();
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(File path) {
        FileUtils.deleteDirectory((File)path);
        this.listing.delete(ApplicationStoreInfo.class, (Object)path.getAbsolutePath());
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(long size) {
        block2: {
            if (this.free() >= size) break block2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Not enough free space, looking at candidates for deletion...");
            ListBuffer evicted = new ListBuffer();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> $this.listing.view(ApplicationStoreInfo.class).index("lastAccess").closeableIterator(), (Function1 & Serializable & scala.Serializable)iter -> {
                HistoryServerDiskManager.$anonfun$makeRoom$3(this, size, evicted, iter);
                return BoxedUnit.UNIT;
            });
            if (evicted.nonEmpty()) {
                long freed = BoxesRunTime.unboxToLong((Object)((TraversableForwarder)evicted.map((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToLong((long)HistoryServerDiskManager.$anonfun$makeRoom$4(this, info)), ListBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Deleted ").append(evicted.size()).append(" store(s) to free ").append(Utils$.MODULE$.bytesToString(freed)).append(" ").append("(target = ").append(Utils$.MODULE$.bytesToString(size)).append(").").toString());
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unable to free any space to make room for ").append(Utils$.MODULE$.bytesToString(size)).append(".").toString());
            }
        }
    }

    public File org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(String appId, Option<String> attemptId) {
        String fileName = new StringBuilder(4).append(appId).append(attemptId.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append("_").append((String)x$1).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(".ldb").toString();
        return new File(this.appStoreDir(), fileName);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(String appId, Option<String> attemptId) {
        File path = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
        ApplicationStoreInfo info = new ApplicationStoreInfo(path.getAbsolutePath(), this.clock.getTimeMillis(), appId, attemptId, this.sizeOf(path));
        this.listing.write((Object)info);
    }

    public void org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(long delta, boolean committed) {
        long updatedCommitted;
        long updated = this.currentUsage().addAndGet(delta);
        if (updated < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updated).append(", delta = ").append(delta).append(")").toString());
        }
        if (committed && (updatedCommitted = this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().addAndGet(delta)) < 0L) {
            throw new IllegalStateException(new StringBuilder(51).append("Disk usage tracker went negative (now = ").append(updatedCommitted).append(", delta = ").append(delta).append(")").toString());
        }
    }

    public boolean org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2() {
        return false;
    }

    public long sizeOf(File path) {
        return FileUtils.sizeOf((File)path);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$1(File x$1) {
        return FileUtils.deleteQuietly((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$initialize$2(ApplicationStoreInfo info) {
        return !new File(info.path()).exists();
    }

    public static final /* synthetic */ void $anonfun$makeRoom$3(HistoryServerDiskManager $this, long size$1, ListBuffer evicted$1, KVStoreIterator iter) {
        long needed = size$1;
        while (needed > 0L && iter.hasNext()) {
            boolean bl;
            ApplicationStoreInfo info = (ApplicationStoreInfo)iter.next();
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                bl = $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)info.appId()), info.attemptId()));
            }
            boolean isActive = bl;
            if (isActive) continue;
            evicted$1.$plus$eq((Object)info);
            needed -= info.size();
        }
    }

    public static final /* synthetic */ long $anonfun$makeRoom$4(HistoryServerDiskManager $this, ApplicationStoreInfo info) {
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting store for ").append(info.appId()).append("/").append(info.attemptId()).append(".").toString());
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(new File(info.path()));
        $this.org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-info.size(), true);
        return info.size();
    }

    public HistoryServerDiskManager(SparkConf conf, File path, KVStore listing, Clock clock) {
        this.listing = listing;
        this.clock = clock;
        Logging.$init$(this);
        this.appStoreDir = new File(path, "apps");
        if (!this.appStoreDir().isDirectory() && !this.appStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(34).append("Failed to create app directory (").append(this.appStoreDir()).append(").").toString());
        }
        this.tmpStoreDir = new File(path, "temp");
        if (!this.tmpStoreDir().isDirectory() && !this.tmpStoreDir().mkdir()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Failed to create temp directory (").append(this.tmpStoreDir()).append(").").toString());
        }
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage = BoxesRunTime.unboxToLong((Object)conf.get(History$.MODULE$.MAX_LOCAL_DISK_USAGE()));
        this.currentUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage = new AtomicLong(0L);
        this.org$apache$spark$deploy$history$HistoryServerDiskManager$$active = new HashMap();
    }

    public class Lease {
        private final File tmpPath;
        private final long leased;
        public final /* synthetic */ HistoryServerDiskManager $outer;

        public File tmpPath() {
            return this.tmpPath;
        }

        private long leased() {
            return this.leased;
        }

        /*
         * WARNING - void declaration
         */
        public File commit(String appId, Option<String> attemptId) {
            void var3_3;
            File dst = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$appStorePath(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap) {
                Predef$.MODULE$.require(!this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cannot commit lease for active application ").append(appId).append(" / ").append(attemptId).toString());
                if (dst.isDirectory()) {
                    long size = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$deleteStore(dst);
                    this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-size, true);
                }
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            long newSize = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().sizeOf(this.tmpPath());
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$makeRoom(newSize);
            this.tmpPath().renameTo(dst);
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(newSize, true);
            if (this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get() > this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage()) {
                String current = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$committedUsage().get());
                String max = Utils$.MODULE$.bytesToString(this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$maxUsage());
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Commit of application ").append(appId).append(" / ").append(attemptId).append(" causes maximum disk usage to be ").append("exceeded (").append(current).append(" > ").append(max).append(")").toString());
            }
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateAccessTime(appId, attemptId);
            HashMap<Tuple2<String, Option<String>>, Object> hashMap2 = this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active();
            synchronized (hashMap2) {
                this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$active().update((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), attemptId), (Object)BoxesRunTime.boxToLong((long)newSize));
            }
            return var3_3;
        }

        public void rollback() {
            this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage(-this.leased(), this.org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer().org$apache$spark$deploy$history$HistoryServerDiskManager$$updateUsage$default$2());
            FileUtils.deleteDirectory((File)this.tmpPath());
        }

        public /* synthetic */ HistoryServerDiskManager org$apache$spark$deploy$history$HistoryServerDiskManager$Lease$$$outer() {
            return this.$outer;
        }

        public Lease(HistoryServerDiskManager $outer, File tmpPath, long leased) {
            this.tmpPath = tmpPath;
            this.leased = leased;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

