/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile;

import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.ObjectFile;

public final class BuildDependency
implements Comparable<Object> {
    public final LayoutDecision depending;
    public final LayoutDecision dependedOn;

    public static BuildDependency createOrGet(LayoutDecision depending, LayoutDecision dependedOn) {
        try {
            return new BuildDependency(depending, dependedOn);
        }
        catch (DuplicateDependencyException ex) {
            return ex.existing;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuildDependency)) {
            return false;
        }
        BuildDependency arg = (BuildDependency)obj;
        assert (arg.depending != this.depending || arg.dependedOn != this.dependedOn || System.identityHashCode(arg.depending) == System.identityHashCode(this.depending) && System.identityHashCode(arg.dependedOn) == System.identityHashCode(this.dependedOn));
        return arg.depending == this.depending && arg.dependedOn == this.dependedOn;
    }

    public int hashCode() {
        return this.depending.hashCode() ^ this.dependedOn.hashCode();
    }

    @Override
    public int compareTo(Object arg0) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        if (!(arg0 instanceof BuildDependency)) {
            return -1;
        }
        BuildDependency arg = (BuildDependency)arg0;
        int our0 = System.identityHashCode(this.depending);
        int our1 = System.identityHashCode(this.dependedOn);
        int their0 = System.identityHashCode(arg.depending);
        int their1 = System.identityHashCode(arg.dependedOn);
        if (our0 < their0 || our0 == their0 && our1 < their1) {
            return -1;
        }
        if (our0 > their0 || our0 == their0 && our1 > their1) {
            return 1;
        }
        assert (our0 == their0 && our1 == their1);
        return 0;
    }

    private BuildDependency(LayoutDecision depending, LayoutDecision dependedOn) throws DuplicateDependencyException {
        assert (depending != null);
        assert (dependedOn != null);
        assert (depending != dependedOn);
        assert (depending.getElement().getOwner() == dependedOn.getElement().getOwner());
        ObjectFile of = depending.getElement().getOwner();
        this.depending = depending;
        this.dependedOn = dependedOn;
        if (depending.dependsOn().contains(dependedOn)) {
            assert (dependedOn.dependedOnBy().contains(depending));
            BuildDependency existing = of.getExistingDependency(this);
            assert (existing != null);
            throw new DuplicateDependencyException(existing);
        }
        depending.dependsOn().add(dependedOn);
        dependedOn.dependedOnBy().add(depending);
        of.putDependency(this);
    }

    private static class DuplicateDependencyException
    extends Exception {
        static final long serialVersionUID = 42L;
        BuildDependency existing;

        DuplicateDependencyException(BuildDependency existing) {
            this.existing = existing;
        }
    }
}

