/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration2.Configuration;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.olap.job.IndexUpdateJob;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceIndexJobs {
    private static final Logger log = LoggerFactory.getLogger(MapReduceIndexJobs.class);

    public static ModifiableConfiguration getIndexJobConf(String indexName, String relationType) {
        ModifiableConfiguration mc = new ModifiableConfiguration(GraphDatabaseConfiguration.JOB_NS, (WriteConfiguration)new CommonsConfiguration((Configuration)ConfigurationUtil.createBaseConfiguration()), BasicConfiguration.Restriction.NONE);
        mc.set(IndexUpdateJob.INDEX_NAME, (Object)indexName, new String[0]);
        mc.set(IndexUpdateJob.INDEX_RELATION_TYPE, (Object)relationType, new String[0]);
        mc.set(GraphDatabaseConfiguration.JOB_START_TIME, (Object)System.currentTimeMillis(), new String[0]);
        return mc;
    }

    public static void copyPropertiesToInputAndOutputConf(org.apache.hadoop.conf.Configuration sink, Properties source) {
        String prefix = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".";
        for (Map.Entry<Object, Object> e : source.entrySet()) {
            String v = e.getValue().toString();
            String k = prefix + e.getKey().toString();
            sink.set(k, v);
            log.info("Set {}={}", (Object)k, (Object)v);
        }
    }
}

