/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsVisitor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractMetric
implements MetricsInfo {
    private final MetricsInfo info;

    protected AbstractMetric(MetricsInfo info) {
        this.info = (MetricsInfo)Preconditions.checkNotNull((Object)info, (Object)"metric info");
    }

    @Override
    public String name() {
        return this.info.name();
    }

    @Override
    public String description() {
        return this.info.description();
    }

    protected MetricsInfo info() {
        return this.info;
    }

    public abstract Number value();

    public abstract MetricType type();

    public abstract void visit(MetricsVisitor var1);

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMetric) {
            AbstractMetric other = (AbstractMetric)obj;
            return Objects.equal((Object)this.info, (Object)other.info()) && Objects.equal((Object)this.value(), (Object)other.value());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.info, this.value()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getClass().getSimpleName());
        sb.append("{info=");
        sb.append(this.info);
        sb.append(", value=");
        sb.append(this.value());
        return sb.append('}').toString();
    }
}

