/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.NodeUnavailableException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.PrepareRequest;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.adminrequest.ThrottledAdminRequestHandler;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultPreparedStatement;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CqlPrepareHandler
implements Throttled {
    private static final Logger LOG = LoggerFactory.getLogger(CqlPrepareHandler.class);
    private final long startTimeNanos = System.nanoTime();
    private final String logPrefix;
    private final PrepareRequest initialRequest;
    private final DefaultSession session;
    private final InternalDriverContext context;
    private final Queue<Node> queryPlan;
    protected final CompletableFuture<PreparedStatement> result;
    private final Timer timer;
    private final Timeout scheduledTimeout;
    private final RequestThrottler throttler;
    private final Boolean prepareOnAllNodes;
    private volatile InitialPrepareCallback initialCallback;
    private volatile List<Map.Entry<Node, Throwable>> errors;

    protected CqlPrepareHandler(PrepareRequest request, DefaultSession session, InternalDriverContext context, String sessionLogPrefix) {
        this.logPrefix = sessionLogPrefix + "|" + this.hashCode();
        LOG.trace("[{}] Creating new handler for prepare request {}", (Object)this.logPrefix, (Object)request);
        this.initialRequest = request;
        this.session = session;
        this.context = context;
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(request, context);
        this.queryPlan = context.getLoadBalancingPolicyWrapper().newQueryPlan(request, executionProfile.getName(), session);
        this.result = new CompletableFuture();
        this.result.exceptionally(t -> {
            try {
                if (t instanceof CancellationException) {
                    this.cancelTimeout();
                }
            }
            catch (Throwable t2) {
                Loggers.warnWithException(LOG, "[{}] Uncaught exception", this.logPrefix, t2);
            }
            return null;
        });
        this.timer = context.getNettyOptions().getTimer();
        Duration timeout = Conversions.resolveRequestTimeout(request, context);
        this.scheduledTimeout = this.scheduleTimeout(timeout);
        this.prepareOnAllNodes = executionProfile.getBoolean(DefaultDriverOption.PREPARE_ON_ALL_NODES);
        this.throttler = context.getRequestThrottler();
        this.throttler.register(this);
    }

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(this.initialRequest, this.context);
        if (wasDelayed) {
            this.session.getMetricUpdater().updateTimer(DefaultSessionMetric.THROTTLING_DELAY, executionProfile.getName(), System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        this.sendRequest(this.initialRequest, null, 0);
    }

    public CompletableFuture<PreparedStatement> handle() {
        return this.result;
    }

    private Timeout scheduleTimeout(Duration timeoutDuration) {
        if (timeoutDuration.toNanos() > 0L) {
            return this.timer.newTimeout(timeout1 -> {
                this.setFinalError(new DriverTimeoutException("Query timed out after " + timeoutDuration));
                if (this.initialCallback != null) {
                    this.initialCallback.cancel();
                }
            }, timeoutDuration.toNanos(), TimeUnit.NANOSECONDS);
        }
        return null;
    }

    private void cancelTimeout() {
        if (this.scheduledTimeout != null) {
            this.scheduledTimeout.cancel();
        }
    }

    private void sendRequest(PrepareRequest request, Node node, int retryCount) {
        if (this.result.isDone()) {
            return;
        }
        DriverChannel channel = null;
        if (node == null || (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            while (!this.result.isDone() && (node = this.queryPlan.poll()) != null && (channel = this.session.getChannel(node, this.logPrefix)) == null) {
                this.recordError(node, new NodeUnavailableException(node));
            }
        }
        if (channel == null) {
            this.setFinalError(AllNodesFailedException.fromErrors(this.errors));
        } else {
            InitialPrepareCallback initialPrepareCallback = new InitialPrepareCallback(request, node, channel, retryCount);
            Prepare message = this.toPrepareMessage(request);
            channel.write((Message)message, false, request.getCustomPayload(), initialPrepareCallback).addListener((GenericFutureListener)initialPrepareCallback);
        }
    }

    @NonNull
    private Prepare toPrepareMessage(PrepareRequest request) {
        ProtocolVersion protocolVersion = this.context.getProtocolVersion();
        ProtocolVersionRegistry registry = this.context.getProtocolVersionRegistry();
        CqlIdentifier keyspace = request.getKeyspace();
        if (keyspace != null && !registry.supports(protocolVersion, DefaultProtocolFeature.PER_REQUEST_KEYSPACE)) {
            throw new IllegalArgumentException("Can't use per-request keyspace with protocol " + protocolVersion);
        }
        return new Prepare(request.getQuery(), keyspace == null ? null : keyspace.asInternal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Node node, Throwable error) {
        List<Map.Entry<Node, Throwable>> errorsSnapshot = this.errors;
        if (errorsSnapshot == null) {
            CqlPrepareHandler cqlPrepareHandler = this;
            synchronized (cqlPrepareHandler) {
                errorsSnapshot = this.errors;
                if (errorsSnapshot == null) {
                    this.errors = errorsSnapshot = new CopyOnWriteArrayList<Map.Entry<Node, Throwable>>();
                }
            }
        }
        errorsSnapshot.add(new AbstractMap.SimpleEntry<Node, Throwable>(node, error));
    }

    private void setFinalResult(PrepareRequest request, Prepared response) {
        this.throttler.signalSuccess(this);
        DefaultPreparedStatement preparedStatement = Conversions.toPreparedStatement(response, request, this.context);
        this.session.getRepreparePayloads().put(preparedStatement.getId(), preparedStatement.getRepreparePayload());
        if (this.prepareOnAllNodes.booleanValue()) {
            this.prepareOnOtherNodes(request).thenRun(() -> {
                LOG.trace("[{}] Done repreparing on other nodes, completing the request", (Object)this.logPrefix);
                this.result.complete(preparedStatement);
            }).exceptionally(error -> {
                this.result.completeExceptionally((Throwable)error);
                return null;
            });
        } else {
            LOG.trace("[{}] Prepare on all nodes is disabled, completing the request", (Object)this.logPrefix);
            this.result.complete(preparedStatement);
        }
    }

    private CompletionStage<Void> prepareOnOtherNodes(PrepareRequest request) {
        ArrayList otherNodesFutures = new ArrayList();
        for (Node node : this.queryPlan) {
            otherNodesFutures.add(this.prepareOnOtherNode(request, node));
        }
        return CompletableFutures.allDone(otherNodesFutures);
    }

    private CompletionStage<Void> prepareOnOtherNode(PrepareRequest request, Node node) {
        LOG.trace("[{}] Repreparing on {}", (Object)this.logPrefix, (Object)node);
        DriverChannel channel = this.session.getChannel(node, this.logPrefix);
        if (channel == null) {
            LOG.trace("[{}] Could not get a channel to reprepare on {}, skipping", (Object)this.logPrefix, (Object)node);
            return CompletableFuture.completedFuture(null);
        }
        ThrottledAdminRequestHandler<ByteBuffer> handler = ThrottledAdminRequestHandler.prepare(channel, false, (Message)this.toPrepareMessage(request), request.getCustomPayload(), Conversions.resolveRequestTimeout(request, this.context), this.throttler, this.session.getMetricUpdater(), this.logPrefix);
        return handler.start().handle((result, error) -> {
            if (error == null) {
                LOG.trace("[{}] Successfully reprepared on {}", (Object)this.logPrefix, (Object)node);
            } else {
                Loggers.warnWithException(LOG, "[{}] Error while repreparing on {}", node, this.logPrefix, error);
            }
            return null;
        });
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(this.initialRequest, this.context);
        this.session.getMetricUpdater().incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, executionProfile.getName());
        this.setFinalError(error);
    }

    private void setFinalError(Throwable error) {
        if (this.result.completeExceptionally(error)) {
            this.cancelTimeout();
            if (error instanceof DriverTimeoutException) {
                this.throttler.signalTimeout(this);
            } else if (!(error instanceof RequestThrottlingException)) {
                this.throttler.signalError(this, error);
            }
        }
    }

    private class InitialPrepareCallback
    implements ResponseCallback,
    GenericFutureListener<Future<Void>> {
        private final PrepareRequest request;
        private final Node node;
        private final DriverChannel channel;
        private final int retryCount;

        private InitialPrepareCallback(PrepareRequest request, Node node, DriverChannel channel, int retryCount) {
            this.request = request;
            this.node = node;
            this.channel = channel;
            this.retryCount = retryCount;
        }

        public void operationComplete(Future<Void> future) {
            if (!future.isSuccess()) {
                LOG.trace("[{}] Failed to send request on {}, trying next node (cause: {})", new Object[]{CqlPrepareHandler.this.logPrefix, this.node, future.cause().toString()});
                CqlPrepareHandler.this.recordError(this.node, future.cause());
                CqlPrepareHandler.this.sendRequest(this.request, null, this.retryCount);
            } else if (CqlPrepareHandler.this.result.isDone()) {
                this.cancel();
            } else {
                LOG.trace("[{}] Request sent to {}", (Object)CqlPrepareHandler.this.logPrefix, (Object)this.node);
                CqlPrepareHandler.this.initialCallback = this;
            }
        }

        @Override
        public void onResponse(Frame responseFrame) {
            if (CqlPrepareHandler.this.result.isDone()) {
                return;
            }
            try {
                Message responseMessage = responseFrame.message;
                if (responseMessage instanceof Prepared) {
                    LOG.trace("[{}] Got result, completing", (Object)CqlPrepareHandler.this.logPrefix);
                    CqlPrepareHandler.this.setFinalResult(this.request, (Prepared)responseMessage);
                } else if (responseMessage instanceof Error) {
                    LOG.trace("[{}] Got error response, processing", (Object)CqlPrepareHandler.this.logPrefix);
                    this.processErrorResponse((Error)responseMessage);
                } else {
                    CqlPrepareHandler.this.setFinalError(new IllegalStateException("Unexpected response " + responseMessage));
                }
            }
            catch (Throwable t) {
                CqlPrepareHandler.this.setFinalError(t);
            }
        }

        private void processErrorResponse(Error errorMessage) {
            if (errorMessage.code == 9472 || errorMessage.code == 9216 || errorMessage.code == 4864 || errorMessage.code == 4608 || errorMessage.code == 5376 || errorMessage.code == 4352 || errorMessage.code == 4096 || errorMessage.code == 4099) {
                CqlPrepareHandler.this.setFinalError(new IllegalStateException("Unexpected server error for a PREPARE query" + errorMessage));
                return;
            }
            CoordinatorException error = Conversions.toThrowable(this.node, errorMessage, CqlPrepareHandler.this.context);
            if (error instanceof BootstrappingException) {
                LOG.trace("[{}] {} is bootstrapping, trying next node", (Object)CqlPrepareHandler.this.logPrefix, (Object)this.node);
                CqlPrepareHandler.this.recordError(this.node, error);
                CqlPrepareHandler.this.sendRequest(this.request, null, this.retryCount);
            } else if (error instanceof QueryValidationException || error instanceof FunctionFailureException || error instanceof ProtocolError) {
                LOG.trace("[{}] Unrecoverable error, rethrowing", (Object)CqlPrepareHandler.this.logPrefix);
                CqlPrepareHandler.this.setFinalError(error);
            } else {
                RetryPolicy retryPolicy = Conversions.resolveRetryPolicy(this.request, CqlPrepareHandler.this.context);
                RetryVerdict verdict = retryPolicy.onErrorResponseVerdict(this.request, error, this.retryCount);
                this.processRetryVerdict(verdict, error);
            }
        }

        private void processRetryVerdict(RetryVerdict verdict, Throwable error) {
            RetryDecision decision = verdict.getRetryDecision();
            LOG.trace("[{}] Processing retry decision {}", (Object)CqlPrepareHandler.this.logPrefix, (Object)decision);
            switch (decision) {
                case RETRY_SAME: {
                    CqlPrepareHandler.this.recordError(this.node, error);
                    CqlPrepareHandler.this.sendRequest(verdict.getRetryRequest(this.request), this.node, this.retryCount + 1);
                    break;
                }
                case RETRY_NEXT: {
                    CqlPrepareHandler.this.recordError(this.node, error);
                    CqlPrepareHandler.this.sendRequest(verdict.getRetryRequest(this.request), null, this.retryCount + 1);
                    break;
                }
                case RETHROW: {
                    CqlPrepareHandler.this.setFinalError(error);
                    break;
                }
                case IGNORE: {
                    CqlPrepareHandler.this.setFinalError(new IllegalArgumentException("IGNORE decisions are not allowed for prepare requests, please fix your retry policy."));
                }
            }
        }

        @Override
        public void onFailure(Throwable error) {
            RetryVerdict verdict;
            if (CqlPrepareHandler.this.result.isDone()) {
                return;
            }
            LOG.trace("[{}] Request failure, processing: {}", (Object)CqlPrepareHandler.this.logPrefix, (Object)error.toString());
            try {
                RetryPolicy retryPolicy = Conversions.resolveRetryPolicy(this.request, CqlPrepareHandler.this.context);
                verdict = retryPolicy.onRequestAbortedVerdict(this.request, error, this.retryCount);
            }
            catch (Throwable cause) {
                CqlPrepareHandler.this.setFinalError(new IllegalStateException("Unexpected error while invoking the retry policy", cause));
                return;
            }
            this.processRetryVerdict(verdict, error);
        }

        public void cancel() {
            try {
                if (!this.channel.closeFuture().isDone()) {
                    this.channel.cancel(this);
                }
            }
            catch (Throwable t) {
                Loggers.warnWithException(LOG, "[{}] Error cancelling", CqlPrepareHandler.this.logPrefix, t);
            }
        }

        public String toString() {
            return CqlPrepareHandler.this.logPrefix;
        }
    }
}

