/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.stream.Collectors;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.cql3.statements.CreateTableStatement;
import org.apache.cassandra.cql3.statements.CreateTypeStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.UpdateStatement;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.io.sstable.SSTableSimpleWriter;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class CQLSSTableWriter
implements Closeable {
    public static final ByteBuffer UNSET_VALUE = ByteBufferUtil.UNSET_BYTE_BUFFER;
    private final AbstractSSTableSimpleWriter writer;
    private final UpdateStatement insert;
    private final List<ColumnSpecification> boundNames;
    private final List<TypeCodec> typeCodecs;

    private CQLSSTableWriter(AbstractSSTableSimpleWriter writer, UpdateStatement insert, List<ColumnSpecification> boundNames) {
        this.writer = writer;
        this.insert = insert;
        this.boundNames = boundNames;
        this.typeCodecs = boundNames.stream().map(bn -> UDHelper.codecFor(UDHelper.driverType(bn.type))).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public CQLSSTableWriter addRow(Object ... values) throws InvalidRequestException, IOException {
        return this.addRow(Arrays.asList(values));
    }

    public CQLSSTableWriter addRow(List<Object> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            Object value = values.get(i);
            rawValues.add(this.serialize(value, this.typeCodecs.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public CQLSSTableWriter addRow(Map<String, Object> values) throws InvalidRequestException, IOException {
        int size = this.boundNames.size();
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            Object value = values.get(spec.name.toString());
            rawValues.add(this.serialize(value, this.typeCodecs.get(i)));
        }
        return this.rawAddRow(rawValues);
    }

    public CQLSSTableWriter rawAddRow(ByteBuffer ... values) throws InvalidRequestException, IOException {
        return this.rawAddRow(Arrays.asList(values));
    }

    public CQLSSTableWriter rawAddRow(List<ByteBuffer> values) throws InvalidRequestException, IOException {
        if (values.size() != this.boundNames.size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments, expecting %d values but got %d", this.boundNames.size(), values.size()));
        }
        QueryOptions options = QueryOptions.forInternalCalls(null, values);
        List<ByteBuffer> keys = this.insert.buildPartitionKeyNames(options);
        NavigableSet<Clustering> clusterings = this.insert.createClustering(options);
        long now = System.currentTimeMillis() * 1000L;
        UpdateParameters params = new UpdateParameters(this.insert.cfm, this.insert.updatedColumns(), options, this.insert.getTimestamp(now, options), this.insert.getTimeToLive(options), Collections.emptyMap());
        try {
            for (ByteBuffer key : keys) {
                for (Clustering clustering : clusterings) {
                    this.insert.addUpdateForKey(this.writer.getUpdateFor(key), clustering, params);
                }
            }
            return this;
        }
        catch (SSTableSimpleUnsortedWriter.SyncException e) {
            throw (IOException)e.getCause();
        }
    }

    public CQLSSTableWriter rawAddRow(Map<String, ByteBuffer> values) throws InvalidRequestException, IOException {
        int size = Math.min(values.size(), this.boundNames.size());
        ArrayList<ByteBuffer> rawValues = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            ColumnSpecification spec = this.boundNames.get(i);
            rawValues.add(values.get(spec.name.toString()));
        }
        return this.rawAddRow(rawValues);
    }

    public UserType getUDType(String dataType) {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.insert.keyspace());
        org.apache.cassandra.db.marshal.UserType userType = ksm.types.getNullable(ByteBufferUtil.bytes(dataType));
        return (UserType)UDHelper.driverType(userType);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private ByteBuffer serialize(Object value, TypeCodec codec) {
        if (value == null || value == UNSET_VALUE) {
            return (ByteBuffer)value;
        }
        return codec.serialize(value, ProtocolVersion.NEWEST_SUPPORTED);
    }

    static {
        DatabaseDescriptor.clientInitialization(false);
        if (DatabaseDescriptor.getPartitioner() == null) {
            DatabaseDescriptor.setPartitionerUnsafe(Murmur3Partitioner.instance);
        }
    }

    public static class Builder {
        private File directory;
        protected SSTableFormat.Type formatType = null;
        private CreateTableStatement.RawStatement schemaStatement;
        private final List<CreateTypeStatement> typeStatements = new ArrayList<CreateTypeStatement>();
        private ModificationStatement.Parsed insertStatement;
        private IPartitioner partitioner;
        private boolean sorted = false;
        private long bufferSizeInMB = 128L;

        protected Builder() {
        }

        public Builder inDirectory(String directory) {
            return this.inDirectory(new File(directory));
        }

        public Builder inDirectory(File directory) {
            if (!directory.exists()) {
                throw new IllegalArgumentException(directory + " doesn't exists");
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(directory + " exists but is not writable");
            }
            this.directory = directory;
            return this;
        }

        public Builder withType(String typeDefinition) throws SyntaxException {
            this.typeStatements.add(QueryProcessor.parseStatement(typeDefinition, CreateTypeStatement.class, "CREATE TYPE"));
            return this;
        }

        public Builder forTable(String schema) {
            this.schemaStatement = QueryProcessor.parseStatement(schema, CreateTableStatement.RawStatement.class, "CREATE TABLE");
            return this;
        }

        public Builder withPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder using(String insert) {
            this.insertStatement = QueryProcessor.parseStatement(insert, ModificationStatement.Parsed.class, "INSERT/UPDATE");
            return this;
        }

        public Builder withBufferSizeInMB(int size) {
            this.bufferSizeInMB = size;
            return this;
        }

        public Builder sorted() {
            this.sorted = true;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CQLSSTableWriter build() {
            if (this.directory == null) {
                throw new IllegalStateException("No ouptut directory specified, you should provide a directory with inDirectory()");
            }
            if (this.schemaStatement == null) {
                throw new IllegalStateException("Missing schema, you should provide the schema for the SSTable to create with forTable()");
            }
            if (this.insertStatement == null) {
                throw new IllegalStateException("No insert statement specified, you should provide an insert statement through using()");
            }
            Class<CQLSSTableWriter> clazz = CQLSSTableWriter.class;
            synchronized (CQLSSTableWriter.class) {
                AbstractSSTableSimpleWriter writer;
                String keyspace;
                if (Schema.instance.getKSMetaData("system_schema") == null) {
                    Schema.instance.load(SchemaKeyspace.metadata());
                }
                if (Schema.instance.getKSMetaData("system") == null) {
                    Schema.instance.load(SystemKeyspace.metadata());
                }
                if (Schema.instance.getKSMetaData(keyspace = this.schemaStatement.keyspace()) == null) {
                    Schema.instance.load(KeyspaceMetadata.create(keyspace, KeyspaceParams.simple(1), Tables.none(), Views.none(), Types.none(), Functions.none()));
                }
                KeyspaceMetadata ksm = Schema.instance.getKSMetaData(keyspace);
                CFMetaData cfMetaData = ksm.tables.getNullable(this.schemaStatement.columnFamily());
                if (cfMetaData == null) {
                    Types types = this.createTypes(keyspace);
                    cfMetaData = this.createTable(types);
                    Schema.instance.load(cfMetaData);
                    Schema.instance.setKeyspaceMetadata(ksm.withSwapped(ksm.tables.with(cfMetaData)).withSwapped(types));
                }
                Pair<UpdateStatement, List<ColumnSpecification>> preparedInsert = this.prepareInsert();
                AbstractSSTableSimpleWriter abstractSSTableSimpleWriter = writer = this.sorted ? new SSTableSimpleWriter(this.directory, cfMetaData, ((UpdateStatement)preparedInsert.left).updatedColumns()) : new SSTableSimpleUnsortedWriter(this.directory, cfMetaData, ((UpdateStatement)preparedInsert.left).updatedColumns(), this.bufferSizeInMB);
                if (this.formatType != null) {
                    writer.setSSTableFormatType(this.formatType);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new CQLSSTableWriter(writer, (UpdateStatement)preparedInsert.left, (List)preparedInsert.right);
            }
        }

        private Types createTypes(String keyspace) {
            Types.RawBuilder builder = Types.rawBuilder(keyspace);
            for (CreateTypeStatement st : this.typeStatements) {
                st.addToRawBuilder(builder);
            }
            return builder.build();
        }

        private CFMetaData createTable(Types types) {
            CreateTableStatement statement = (CreateTableStatement)this.schemaStatement.prepare((Types)types).statement;
            statement.validate(ClientState.forInternalCalls());
            CFMetaData cfMetaData = statement.getCFMetaData();
            if (this.partitioner != null) {
                return cfMetaData.copy(this.partitioner);
            }
            return cfMetaData;
        }

        private Pair<UpdateStatement, List<ColumnSpecification>> prepareInsert() {
            ParsedStatement.Prepared cqlStatement = this.insertStatement.prepare(ClientState.forInternalCalls());
            UpdateStatement insert = (UpdateStatement)cqlStatement.statement;
            insert.validate(ClientState.forInternalCalls());
            if (insert.hasConditions()) {
                throw new IllegalArgumentException("Conditional statements are not supported");
            }
            if (insert.isCounter()) {
                throw new IllegalArgumentException("Counter update statements are not supported");
            }
            if (cqlStatement.boundNames.isEmpty()) {
                throw new IllegalArgumentException("Provided insert statement has no bind variables");
            }
            return Pair.create(insert, cqlStatement.boundNames);
        }
    }
}

