/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class ReadExecutionController
implements AutoCloseable {
    private final OpOrder.Group baseOp;
    private final CFMetaData baseMetadata;
    private final ReadExecutionController indexController;
    private final OpOrder.Group writeOp;

    private ReadExecutionController(OpOrder.Group baseOp, CFMetaData baseMetadata, ReadExecutionController indexController, OpOrder.Group writeOp) {
        assert (baseOp == null == (baseMetadata == null));
        this.baseOp = baseOp;
        this.baseMetadata = baseMetadata;
        this.indexController = indexController;
        this.writeOp = writeOp;
    }

    public ReadExecutionController indexReadController() {
        return this.indexController;
    }

    public OpOrder.Group writeOpOrderGroup() {
        return this.writeOp;
    }

    public boolean validForReadOn(ColumnFamilyStore cfs) {
        return this.baseOp != null && cfs.metadata.cfId.equals(this.baseMetadata.cfId);
    }

    public static ReadExecutionController empty() {
        return new ReadExecutionController(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReadExecutionController forCommand(ReadCommand command) {
        ColumnFamilyStore baseCfs = Keyspace.openAndGetStore(command.metadata());
        ColumnFamilyStore indexCfs = ReadExecutionController.maybeGetIndexCfs(baseCfs, command);
        if (indexCfs == null) {
            return new ReadExecutionController(baseCfs.readOrdering.start(), baseCfs.metadata, null, null);
        }
        OpOrder.Group baseOp = null;
        OpOrder.Group writeOp = null;
        ReadExecutionController indexController = null;
        try {
            baseOp = baseCfs.readOrdering.start();
            indexController = new ReadExecutionController(indexCfs.readOrdering.start(), indexCfs.metadata, null, null);
            writeOp = Keyspace.writeOrder.start();
            return new ReadExecutionController(baseOp, baseCfs.metadata, indexController, writeOp);
        }
        catch (RuntimeException e) {
            assert (writeOp == null);
            try {
                if (baseOp != null) {
                    baseOp.close();
                }
            }
            finally {
                if (indexController != null) {
                    indexController.close();
                }
            }
            throw e;
        }
    }

    private static ColumnFamilyStore maybeGetIndexCfs(ColumnFamilyStore baseCfs, ReadCommand command) {
        Index index = command.getIndex(baseCfs);
        return index == null ? null : (ColumnFamilyStore)index.getBackingTable().orElse(null);
    }

    public CFMetaData metaData() {
        return this.baseMetadata;
    }

    @Override
    public void close() {
        try {
            if (this.baseOp != null) {
                this.baseOp.close();
            }
        }
        finally {
            if (this.indexController != null) {
                try {
                    this.indexController.close();
                }
                finally {
                    this.writeOp.close();
                }
            }
        }
    }
}

