/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io.gryo.kryoshim.unshaded;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.configuration2.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.tinkerpop.gremlin.spark.structure.Spark;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService;

public class UnshadedKryoShimService
implements KryoShimService {
    private static final LinkedBlockingQueue<Kryo> KRYOS = new LinkedBlockingQueue();
    private static volatile boolean INITIALIZED;

    public Object readClassAndObject(InputStream inputStream) {
        Kryo k = null;
        try {
            k = KRYOS.take();
            Object object = k.readClassAndObject(new Input(inputStream));
            return object;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                KRYOS.put(k);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void writeClassAndObject(Object object, OutputStream outputStream) {
        Kryo k = null;
        try {
            k = KRYOS.take();
            Output kryoOutput = new Output(outputStream);
            k.writeClassAndObject(kryoOutput, object);
            kryoOutput.flush();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                KRYOS.put(k);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public int getPriority() {
        return -50;
    }

    public void applyConfiguration(Configuration configuration) {
        this.initialize(configuration);
    }

    public void close() {
        INITIALIZED = false;
        KRYOS.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LinkedBlockingQueue<Kryo> initialize(Configuration configuration) {
        if (INITIALIZED) return KRYOS;
        Class<UnshadedKryoShimService> clazz = UnshadedKryoShimService.class;
        synchronized (UnshadedKryoShimService.class) {
            if (INITIALIZED) return KRYOS;
            SparkConf sparkConf = null == Spark.getContext() ? new SparkConf() : Spark.getContext().getConf().clone();
            configuration.getKeys().forEachRemaining(key -> sparkConf.set(key, configuration.getProperty(key).toString()));
            KryoSerializer serializer = new KryoSerializer(sparkConf);
            KRYOS.clear();
            int poolSize = configuration.getInt("gremlin.io.gryo.poolSize", 256);
            for (int i = 0; i < poolSize; ++i) {
                KRYOS.add(serializer.newKryo());
            }
            INITIALIZED = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return KRYOS;
        }
    }
}

