/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.RetriableCommand;
import org.apache.hadoop.tools.util.ThrottledInputStream;
import org.apache.hadoop.util.Progressable;

public class RetriableFileCopyCommand
extends RetriableCommand {
    private static Log LOG = LogFactory.getLog(RetriableFileCopyCommand.class);
    private static int BUFFER_SIZE = 8192;
    private boolean skipCrc = false;
    private CopyMapper.FileAction action;

    public RetriableFileCopyCommand(String description, CopyMapper.FileAction action) {
        super(description);
        this.action = action;
    }

    public RetriableFileCopyCommand(boolean skipCrc, String description, CopyMapper.FileAction action) {
        this(description, action);
        this.skipCrc = skipCrc;
    }

    @Override
    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 4) : "Unexpected argument list.";
        FileStatus source = (FileStatus)arguments[0];
        assert (!source.isDirectory()) : "Unexpected file-status. Expected file.";
        Path target = (Path)arguments[1];
        Mapper.Context context = (Mapper.Context)arguments[2];
        EnumSet fileAttributes = (EnumSet)arguments[3];
        return this.doCopy(source, target, context, fileAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCopy(FileStatus sourceFileStatus, Path target, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        boolean toAppend = this.action == CopyMapper.FileAction.APPEND;
        Path targetPath = toAppend ? target : this.getTmpFile(target, context);
        Configuration configuration = context.getConfiguration();
        FileSystem targetFS = target.getFileSystem(configuration);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Copying " + sourceFileStatus.getPath() + " to " + target));
                LOG.debug((Object)("Target file path: " + targetPath));
            }
            Path sourcePath = sourceFileStatus.getPath();
            FileSystem sourceFS = sourcePath.getFileSystem(configuration);
            FileChecksum sourceChecksum = fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE) ? sourceFS.getFileChecksum(sourcePath) : null;
            long offset = this.action == CopyMapper.FileAction.APPEND ? targetFS.getFileStatus(target).getLen() : 0L;
            long bytesRead = this.copyToFile(targetPath, targetFS, sourceFileStatus, offset, context, fileAttributes, sourceChecksum);
            this.compareFileLengths(sourceFileStatus, targetPath, configuration, bytesRead + offset);
            if (bytesRead != 0L && !this.skipCrc) {
                this.compareCheckSums(sourceFS, sourceFileStatus.getPath(), sourceChecksum, targetFS, targetPath);
            }
            if (!toAppend) {
                this.promoteTmpToTarget(targetPath, target, targetFS);
            }
            long l = bytesRead;
            return l;
        }
        finally {
            if (!toAppend && targetFS.exists(targetPath)) {
                targetFS.delete(targetPath, false);
            }
        }
    }

    private Options.ChecksumOpt getChecksumOpt(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) {
        if (fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE) && sourceChecksum != null) {
            return sourceChecksum.getChecksumOpt();
        }
        return null;
    }

    private long copyToFile(Path targetPath, FileSystem targetFS, FileStatus sourceFileStatus, long sourceOffset, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) throws IOException {
        BufferedOutputStream outStream;
        FsPermission permission = FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)targetFS.getConf()));
        if (this.action == CopyMapper.FileAction.OVERWRITE) {
            short repl = RetriableFileCopyCommand.getReplicationFactor(fileAttributes, sourceFileStatus, targetFS, targetPath);
            long blockSize = RetriableFileCopyCommand.getBlockSize(fileAttributes, sourceFileStatus, targetFS, targetPath);
            FSDataOutputStream out = targetFS.create(targetPath, permission, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), BUFFER_SIZE, repl, blockSize, (Progressable)context, this.getChecksumOpt(fileAttributes, sourceChecksum));
            outStream = new BufferedOutputStream((OutputStream)out);
        } else {
            outStream = new BufferedOutputStream((OutputStream)targetFS.append(targetPath, BUFFER_SIZE));
        }
        return this.copyBytes(sourceFileStatus, sourceOffset, outStream, BUFFER_SIZE, context);
    }

    private void compareFileLengths(FileStatus sourceFileStatus, Path target, Configuration configuration, long targetLen) throws IOException {
        Path sourcePath = sourceFileStatus.getPath();
        FileSystem fs = sourcePath.getFileSystem(configuration);
        long srcLen = fs.getFileStatus(sourcePath).getLen();
        if (srcLen != targetLen) {
            throw new IOException("Mismatch in length of source:" + sourcePath + " (" + srcLen + ") and target:" + target + " (" + targetLen + ")");
        }
    }

    private void compareCheckSums(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target) throws IOException {
        if (!DistCpUtils.checksumsAreEqual(sourceFS, source, sourceChecksum, targetFS, target)) {
            StringBuilder errorMessage = new StringBuilder("Check-sum mismatch between ").append(source).append(" and ").append(target).append(".");
            if (sourceFS.getFileStatus(source).getBlockSize() != targetFS.getFileStatus(target).getBlockSize()) {
                errorMessage.append(" Source and target differ in block-size.").append(" Use -pb to preserve block-sizes during copy.").append(" Alternatively, skip checksum-checks altogether, using -skipCrc.").append(" (NOTE: By skipping checksums, one runs the risk of masking data-corruption during file-transfer.)");
            }
            throw new IOException(errorMessage.toString());
        }
    }

    private void promoteTmpToTarget(Path tmpTarget, Path target, FileSystem fs) throws IOException {
        if (fs.exists(target) && !fs.delete(target, false) || !fs.exists(target.getParent()) && !fs.mkdirs(target.getParent()) || !fs.rename(tmpTarget, target)) {
            throw new IOException("Failed to promote tmp-file:" + tmpTarget + " to: " + target);
        }
    }

    private Path getTmpFile(Path target, Mapper.Context context) {
        Path targetWorkPath = new Path(context.getConfiguration().get("distcp.target.work.path"));
        Path root = target.equals((Object)targetWorkPath) ? targetWorkPath.getParent() : targetWorkPath;
        LOG.info((Object)("Creating temp file: " + new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString())));
        return new Path(root, ".distcp.tmp." + context.getTaskAttemptID().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long copyBytes(FileStatus sourceFileStatus, long sourceOffset, OutputStream outStream, int bufferSize, Mapper.Context context) throws IOException {
        Path source = sourceFileStatus.getPath();
        byte[] buf = new byte[bufferSize];
        ThrottledInputStream inStream = null;
        long totalBytesRead = 0L;
        try {
            inStream = RetriableFileCopyCommand.getInputStream(source, context.getConfiguration());
            int bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf, sourceOffset);
            while (bytesRead >= 0) {
                totalBytesRead += (long)bytesRead;
                if (this.action == CopyMapper.FileAction.APPEND) {
                    sourceOffset += (long)bytesRead;
                }
                outStream.write(buf, 0, bytesRead);
                this.updateContextStatus(totalBytesRead, context, sourceFileStatus);
                bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf, sourceOffset);
            }
            outStream.close();
            outStream = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{outStream, inStream});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{outStream, inStream});
        return totalBytesRead;
    }

    private void updateContextStatus(long totalBytesRead, Mapper.Context context, FileStatus sourceFileStatus) {
        StringBuilder message = new StringBuilder(DistCpUtils.getFormatter().format((float)totalBytesRead * 100.0f / (float)sourceFileStatus.getLen()));
        message.append("% ").append(this.description).append(" [").append(DistCpUtils.getStringDescriptionFor(totalBytesRead)).append('/').append(DistCpUtils.getStringDescriptionFor(sourceFileStatus.getLen())).append(']');
        context.setStatus(message.toString());
    }

    private static int readBytes(ThrottledInputStream inStream, byte[] buf, long position) throws IOException {
        try {
            if (position == 0L) {
                return inStream.read(buf);
            }
            return inStream.read(position, buf, 0, buf.length);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static ThrottledInputStream getInputStream(Path path, Configuration conf) throws IOException {
        try {
            FileSystem fs = path.getFileSystem(conf);
            long bandwidthMB = conf.getInt("distcp.map.bandwidth.mb", 100);
            FSDataInputStream in = fs.open(path);
            return new ThrottledInputStream((InputStream)in, bandwidthMB * 1024L * 1024L);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static short getReplicationFactor(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS, Path tmpTargetPath) {
        return fileAttributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) ? sourceFile.getReplication() : targetFS.getDefaultReplication(tmpTargetPath);
    }

    private static long getBlockSize(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS, Path tmpTargetPath) {
        boolean preserve = fileAttributes.contains((Object)DistCpOptions.FileAttribute.BLOCKSIZE) || fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE);
        return preserve ? sourceFile.getBlockSize() : targetFS.getDefaultBlockSize(tmpTargetPath);
    }

    public static class CopyReadException
    extends IOException {
        public CopyReadException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

