/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.util.ConstantFoldUtil;
import org.graalvm.compiler.options.OptionValues;

public final class ConstantFoldLoadFieldPlugin
implements NodePlugin {
    public boolean handleLoadField(GraphBuilderContext b, ValueNode receiver, ResolvedJavaField field) {
        if (receiver.isConstant()) {
            JavaConstant asJavaConstant = receiver.asJavaConstant();
            return ConstantFoldLoadFieldPlugin.tryConstantFold(b, field, asJavaConstant);
        }
        return false;
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField staticField) {
        return ConstantFoldLoadFieldPlugin.tryConstantFold(b, staticField, null);
    }

    private static boolean tryConstantFold(GraphBuilderContext b, ResolvedJavaField field, JavaConstant receiver) {
        ConstantNode result = ConstantFoldUtil.tryConstantFold((ConstantFieldProvider)b.getConstantFieldProvider(), (ConstantReflectionProvider)b.getConstantReflection(), (MetaAccessProvider)b.getMetaAccess(), (ResolvedJavaField)field, (JavaConstant)receiver, (OptionValues)b.getOptions());
        if (result != null) {
            assert (result.asJavaConstant() != null);
            result = (ConstantNode)b.getGraph().unique((Node)result);
            b.push(field.getJavaKind(), (ValueNode)result);
            return true;
        }
        return false;
    }
}

