/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.hub.DynamicHub;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;

class ModuleAccess {
    ModuleAccess() {
    }

    public static void extractAndSetModule(DynamicHub hub, Class<?> clazz) {
        Module module = clazz.getModule();
        hub.setModule(module);
    }

    public static Map<String, List<String>> lookupServiceProviders(Feature.BeforeAnalysisAccess access) {
        return ModuleAccess.loadAllModules(access).flatMap(module -> module.provides().stream()).collect(Collectors.toMap(ModuleDescriptor.Provides::service, ModuleDescriptor.Provides::providers, (left, right) -> {
            ArrayList list = new ArrayList(left);
            list.addAll(right);
            return list;
        }));
    }

    private static Stream<ModuleDescriptor> loadAllModules(Feature.BeforeAnalysisAccess access) {
        List applicationModulePath = access.getApplicationModulePath();
        ModuleFinder finder = ModuleFinder.of(applicationModulePath.toArray(new Path[0]));
        Stream<ModuleDescriptor> applicationModules = finder.findAll().stream().map(ModuleReference::descriptor);
        Stream<ModuleDescriptor> bootLayerModules = ModuleLayer.boot().modules().stream().map(Module::getDescriptor);
        return Stream.concat(bootLayerModules, applicationModules).filter(Objects::nonNull);
    }
}

