/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import com.oracle.svm.core.windows.headers.SysinfoAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={VirtualMemoryProvider.class})
public class WindowsVirtualMemoryProvider
implements VirtualMemoryProvider {
    private static final CGlobalData<WordPointer> CACHED_PAGE_SIZE = CGlobalDataFactory.createWord();
    private static final CGlobalData<WordPointer> CACHED_ALLOC_GRAN = CGlobalDataFactory.createWord();
    private static final UnsignedWord UNALIGNED = (UnsignedWord)WordFactory.zero();
    private static final int MEM_RESERVE_PLACEHOLDER = 262144;
    private static final int MEM_REPLACE_PLACEHOLDER = 16384;
    private static final CGlobalData<CCharPointer> REPLACE_PLACEHOLDER_ERROR_MESSAGE = CGlobalDataFactory.createCString("Failed to replace a placeholder.");
    private static final CGlobalData<CCharPointer> KERNELBASE_DLL = CGlobalDataFactory.createCString("kernelbase.dll");
    private static final CGlobalData<CCharPointer> VIRTUAL_ALLOC_2 = CGlobalDataFactory.createCString("VirtualAlloc2");
    private static final CGlobalData<WindowsUtils.CFunctionPointerPointer<VirtualAlloc2>> VIRTUAL_ALLOC_2_POINTER = CGlobalDataFactory.createWord((WordBase)WindowsUtils.UNINITIALIZED_POINTER);
    private static final int MemExtendedParameterAddressRequirements = 1;
    private static final int MEM_PRESERVE_PLACEHOLDER = 2;
    private static final CGlobalData<CCharPointer> MAP_VIEW_OF_FILE_3 = CGlobalDataFactory.createCString("MapViewOfFile3");
    private static final CGlobalData<WindowsUtils.CFunctionPointerPointer<MapViewOfFile3>> MAP_VIEW_OF_FILE_3_POINTER = CGlobalDataFactory.createWord((WordBase)WindowsUtils.UNINITIALIZED_POINTER);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void initCaches() {
        SysinfoAPI.SYSTEM_INFO sysInfo = (SysinfoAPI.SYSTEM_INFO)StackValue.get(SysinfoAPI.SYSTEM_INFO.class);
        SysinfoAPI.GetSystemInfo(sysInfo);
        CACHED_PAGE_SIZE.get().write((WordBase)WordFactory.unsigned((int)sysInfo.dwPageSize()));
        CACHED_ALLOC_GRAN.get().write((WordBase)WordFactory.unsigned((int)sysInfo.dwAllocationGranularity()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getPageSize() {
        UnsignedWord value = (UnsignedWord)CACHED_PAGE_SIZE.get().read();
        if (value.equal((UnsignedWord)WordFactory.zero())) {
            WindowsVirtualMemoryProvider.initCaches();
            value = (UnsignedWord)CACHED_PAGE_SIZE.get().read();
        }
        return value;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getAllocationGranularity() {
        UnsignedWord value = (UnsignedWord)CACHED_ALLOC_GRAN.get().read();
        if (value.equal((UnsignedWord)WordFactory.zero())) {
            WindowsVirtualMemoryProvider.initCaches();
            value = (UnsignedWord)CACHED_ALLOC_GRAN.get().read();
        }
        return value;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getGranularity() {
        return WindowsVirtualMemoryProvider.getPageSize();
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getAlignment() {
        return WindowsVirtualMemoryProvider.getAllocationGranularity();
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static int accessAsProt(int access) {
        if ((access & 4) != 0) {
            if ((access & 2) != 0) {
                return MemoryAPI.PAGE_EXECUTE_READWRITE();
            }
            if ((access & 1) != 0) {
                return MemoryAPI.PAGE_EXECUTE_READ();
            }
            return MemoryAPI.PAGE_EXECUTE();
        }
        if ((access & 2) != 0) {
            return MemoryAPI.PAGE_READWRITE();
        }
        if ((access & 1) != 0) {
            return MemoryAPI.PAGE_READONLY();
        }
        return MemoryAPI.PAGE_NOACCESS();
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer reserve(UnsignedWord nbytes, UnsignedWord alignment, boolean executable) {
        Pointer reservedPlaceholder;
        if (nbytes.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        UnsignedWord requiredAlignment = alignment;
        if (UnsignedUtils.isAMultiple(WindowsVirtualMemoryProvider.getAllocationGranularity(), requiredAlignment)) {
            requiredAlignment = UNALIGNED;
        }
        if ((reservedPlaceholder = WindowsVirtualMemoryProvider.reservePlaceholder(nbytes, requiredAlignment)).isNonNull()) {
            WindowsVirtualMemoryProvider.replacePlaceholder((PointerBase)reservedPlaceholder, nbytes);
            return reservedPlaceholder;
        }
        assert (reservedPlaceholder.isNull());
        Pointer reserved = MemoryAPI.VirtualAlloc(WordFactory.nullPointer(), nbytes.add(requiredAlignment), MemoryAPI.MEM_RESERVE(), MemoryAPI.PAGE_NOACCESS());
        if (reserved.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        return requiredAlignment.equal(UNALIGNED) ? reserved : PointerUtils.roundUp((PointerBase)reserved, requiredAlignment);
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static Pointer reservePlaceholder(UnsignedWord size, UnsignedWord alignment) {
        int allocationType = MemoryAPI.MEM_RESERVE() | 0x40000;
        return WindowsVirtualMemoryProvider.invokeVirtualAlloc2(WordFactory.nullPointer(), size, allocationType, MemoryAPI.PAGE_NOACCESS(), alignment);
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static void replacePlaceholder(PointerBase placeholder, UnsignedWord size) {
        int allocationType = MemoryAPI.MEM_RESERVE() | 0x4000;
        if (WindowsVirtualMemoryProvider.invokeVirtualAlloc2(placeholder, size, allocationType, MemoryAPI.PAGE_NOACCESS(), (UnsignedWord)WordFactory.zero()).isNull()) {
            CEntryPointActions.failFatally(WinBase.GetLastError(), REPLACE_PLACEHOLDER_ERROR_MESSAGE.get());
        }
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static Pointer invokeVirtualAlloc2(PointerBase baseAddress, UnsignedWord size, int allocationType, int pageProtection, UnsignedWord alignment) {
        VirtualAlloc2 virtualAlloc2 = WindowsUtils.getAndCacheFunctionPointer(VIRTUAL_ALLOC_2_POINTER.get(), KERNELBASE_DLL.get(), VIRTUAL_ALLOC_2.get());
        if (virtualAlloc2.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        MEM_EXTENDED_PARAMETER extendedParameter = (MEM_EXTENDED_PARAMETER)StackValue.get(MEM_EXTENDED_PARAMETER.class);
        WindowsVirtualMemoryProvider.specifyAlignment(extendedParameter, (MEM_ADDRESS_REQUIREMENTS)StackValue.get(MEM_ADDRESS_REQUIREMENTS.class), alignment);
        return virtualAlloc2.invoke((WinBase.HANDLE)WordFactory.nullPointer(), baseAddress, size, allocationType, pageProtection, extendedParameter, 1);
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static void specifyAlignment(MEM_EXTENDED_PARAMETER extendedParameter, MEM_ADDRESS_REQUIREMENTS addressRequirements, UnsignedWord alignment) {
        extendedParameter.f1Type(1L);
        extendedParameter.f2Pointer(addressRequirements.rawValue());
        addressRequirements.f1LowestStartingAddress(WordFactory.nullPointer());
        addressRequirements.f2HighestEndingAddress(WordFactory.nullPointer());
        addressRequirements.f3Alignment(alignment);
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer mapFile(PointerBase start, UnsignedWord nbytes, WordBase fileHandle, UnsignedWord offset, int access) {
        if (start.isNonNull() && !this.isAligned(start) || nbytes.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        if (start.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        if (!WindowsVirtualMemoryProvider.splitPlaceholder(start, nbytes)) {
            return (Pointer)WordFactory.nullPointer();
        }
        int pageProtection = (access & 2) != 0 ? MemoryAPI.PAGE_WRITECOPY() : MemoryAPI.PAGE_READONLY();
        Pointer fileView = WindowsVirtualMemoryProvider.invokeMapViewOfFile3((WinBase.HANDLE)fileHandle, start, offset.rawValue(), nbytes, pageProtection);
        if (fileView.isNull()) {
            WindowsVirtualMemoryProvider.replacePlaceholder(start, nbytes);
        }
        return fileView;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static boolean splitPlaceholder(PointerBase start, UnsignedWord size) {
        return MemoryAPI.VirtualFree(start, size, MemoryAPI.MEM_RELEASE() | 2) != 0;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static Pointer invokeMapViewOfFile3(WinBase.HANDLE fileMapping, PointerBase baseAddress, long offset, UnsignedWord viewSize, int pageProtection) {
        MapViewOfFile3 mapViewOfFile3 = WindowsUtils.getAndCacheFunctionPointer(MAP_VIEW_OF_FILE_3_POINTER.get(), KERNELBASE_DLL.get(), MAP_VIEW_OF_FILE_3.get());
        if (mapViewOfFile3.isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        return mapViewOfFile3.invoke(fileMapping, (WinBase.HANDLE)WordFactory.nullPointer(), baseAddress, offset, viewSize, 16384, pageProtection, WordFactory.nullPointer(), 0);
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase start, UnsignedWord nbytes, int access) {
        if (start.isNonNull() && !this.isAligned(start) || nbytes.equal(0)) {
            return (Pointer)WordFactory.nullPointer();
        }
        return MemoryAPI.VirtualAlloc(start, nbytes, MemoryAPI.MEM_COMMIT(), WindowsVirtualMemoryProvider.accessAsProt(access));
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int protect(PointerBase start, UnsignedWord nbytes, int access) {
        if (start.isNull() || !this.isAligned(start) || nbytes.equal(0)) {
            return -1;
        }
        CIntPointer oldProt = (CIntPointer)StackValue.get(CIntPointer.class);
        int result = MemoryAPI.VirtualProtect(start, nbytes, WindowsVirtualMemoryProvider.accessAsProt(access), oldProt);
        return result != 0 ? 0 : -1;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int uncommit(PointerBase start, UnsignedWord nbytes) {
        if (start.isNull() || !this.isAligned(start) || nbytes.equal(0)) {
            return -1;
        }
        int result = MemoryAPI.VirtualFree(start, nbytes, MemoryAPI.MEM_DECOMMIT());
        return result != 0 ? 0 : -1;
    }

    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public int free(PointerBase start, UnsignedWord nbytes) {
        if (start.isNull() || !this.isAligned(start) || nbytes.equal(0)) {
            return -1;
        }
        MemoryAPI.MEMORY_BASIC_INFORMATION memoryInfo = (MemoryAPI.MEMORY_BASIC_INFORMATION)StackValue.get(MemoryAPI.MEMORY_BASIC_INFORMATION.class);
        Pointer end = ((Pointer)start).add(nbytes).subtract(1);
        while (end.aboveThan((UnsignedWord)((Pointer)start))) {
            if (MemoryAPI.VirtualQuery((PointerBase)end, memoryInfo, SizeOf.unsigned(MemoryAPI.MEMORY_BASIC_INFORMATION.class)).equal(0)) {
                return -1;
            }
            if (!WindowsVirtualMemoryProvider.free(memoryInfo.AllocationBase(), memoryInfo.Type() == MemoryAPI.MEM_MAPPED())) {
                return -1;
            }
            end = ((Pointer)memoryInfo.AllocationBase()).subtract(1);
        }
        return 0;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private static boolean free(PointerBase allocationBase, boolean isMemoryMapped) {
        if (isMemoryMapped) {
            return MemoryAPI.UnmapViewOfFile(allocationBase) != 0;
        }
        return MemoryAPI.VirtualFree(allocationBase, (UnsignedWord)WordFactory.zero(), MemoryAPI.MEM_RELEASE()) != 0;
    }

    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    private boolean isAligned(PointerBase ptr) {
        return ptr.isNonNull() && UnsignedUtils.isAMultiple((UnsignedWord)ptr, this.getGranularity());
    }

    private static interface MapViewOfFile3
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public Pointer invoke(WinBase.HANDLE var1, WinBase.HANDLE var2, PointerBase var3, long var4, UnsignedWord var6, int var7, int var8, PointerBase var9, int var10);
    }

    @RawStructure
    private static interface MEM_ADDRESS_REQUIREMENTS
    extends PointerBase {
        @RawField
        public void f1LowestStartingAddress(PointerBase var1);

        @RawField
        public void f2HighestEndingAddress(PointerBase var1);

        @RawField
        public void f3Alignment(UnsignedWord var1);
    }

    @RawStructure
    private static interface MEM_EXTENDED_PARAMETER
    extends PointerBase {
        @RawField
        public void f1Type(long var1);

        @RawField
        public void f2Pointer(long var1);
    }

    private static interface VirtualAlloc2
    extends CFunctionPointer {
        @InvokeCFunctionPointer(transition=CFunction.Transition.NO_TRANSITION)
        public Pointer invoke(WinBase.HANDLE var1, PointerBase var2, UnsignedWord var3, int var4, int var5, PointerBase var6, int var7);
    }
}

