/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.RuntimeAnalysisWorkarounds;
import com.oracle.svm.core.sampler.ProfilingSampler;
import com.oracle.svm.core.sampler.SamplingStackVisitor;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import java.util.concurrent.TimeUnit;
import org.graalvm.collections.LockFreePrefixTree;
import org.graalvm.nativeimage.Threading;
import org.graalvm.word.Pointer;

public class SafepointProfilingSampler
implements ProfilingSampler {
    private final boolean collectingActive;
    private LockFreePrefixTree prefixTree = new LockFreePrefixTree();

    public SafepointProfilingSampler(boolean collectingActive) {
        this.collectingActive = collectingActive;
    }

    @Override
    public boolean isCollectingActive() {
        return this.collectingActive;
    }

    @Override
    public void registerSampler() {
        if (this.collectingActive) {
            RuntimeAnalysisWorkarounds.avoidFoldingSamplingCodeStart();
            Threading.registerRecurringCallback((long)10L, (TimeUnit)TimeUnit.MILLISECONDS, access -> this.sampleThreadStack());
        }
    }

    @Override
    public LockFreePrefixTree prefixTree() {
        return this.prefixTree;
    }

    private void sampleThreadStack() {
        SamplingStackVisitor visitor = new SamplingStackVisitor();
        SamplingStackVisitor.StackTrace data = new SamplingStackVisitor.StackTrace();
        SafepointProfilingSampler.walkCurrentThread(data, visitor);
        long[] result = data.data;
        LockFreePrefixTree.Node node = this.prefixTree.root();
        for (int i = data.num - 1; i >= 0; --i) {
            node = node.at(result[i]);
        }
        SafepointProfilingSampler.incStackTraceCounter(node);
    }

    private static void incStackTraceCounter(LockFreePrefixTree.Node node) {
        node.incValue();
    }

    @NeverInline(value="Starts a stack walk in the caller frame")
    private static void walkCurrentThread(SamplingStackVisitor.StackTrace data, SamplingStackVisitor visitor) {
        Pointer sp = KnownIntrinsics.readStackPointer();
        JavaStackWalker.walkCurrentThread(sp, visitor, data);
    }
}

