/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.headers.LibC;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class LibManagementExtSupport {
    private static final CGlobalData<CCharPointer> ERRMSG_FORMAT = CGlobalDataFactory.createCString("errno: %d error: %s\n");

    @Uninterruptible(reason="No Java context.")
    @CEntryPoint(name="throw_internal_error", include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.SymbolOnly)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class)
    private static void throwInternalError(IsolateThread env, CCharPointer msg) {
        CCharPointer errmsg = (CCharPointer)StackValue.get((int)128);
        LibManagementExtSupport.snprintf(errmsg, WordFactory.unsigned((int)128), ERRMSG_FORMAT.get(), LibC.errno(), msg);
        LibManagementExtSupport.jnuThrowInternalError(env, errmsg);
    }

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    private static native int snprintf(CCharPointer var0, UnsignedWord var1, CCharPointer var2, int var3, CCharPointer var4);

    @CLibrary(value="java", requireStatic=true)
    @CFunction(value="JNU_ThrowInternalError", transition=CFunction.Transition.NO_TRANSITION)
    private static native void jnuThrowInternalError(IsolateThread var0, CCharPointer var1);
}

