/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.servlets;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sparkproject.jetty.http.MimeTypes;
import org.sparkproject.jetty.http.pathmap.PathSpecSet;
import org.sparkproject.jetty.util.IncludeExclude;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.URIUtil;
import org.sparkproject.jetty.util.log.Log;
import org.sparkproject.jetty.util.log.Logger;

public abstract class IncludeExcludeBasedFilter
implements Filter {
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private final IncludeExclude<String> _httpMethods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private static final Logger LOG = Log.getLogger(IncludeExcludeBasedFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        String included_paths = filterConfig.getInitParameter("includedPaths");
        String excluded_paths = filterConfig.getInitParameter("excludedPaths");
        String included_mime_types = filterConfig.getInitParameter("includedMimeTypes");
        String excluded_mime_types = filterConfig.getInitParameter("excludedMimeTypes");
        String included_http_methods = filterConfig.getInitParameter("includedHttpMethods");
        String excluded_http_methods = filterConfig.getInitParameter("excludedHttpMethods");
        if (included_paths != null) {
            this._paths.include((T[])StringUtil.csvSplit(included_paths));
        }
        if (excluded_paths != null) {
            this._paths.exclude((T[])StringUtil.csvSplit(excluded_paths));
        }
        if (included_mime_types != null) {
            this._mimeTypes.include((T[])StringUtil.csvSplit(included_mime_types));
        }
        if (excluded_mime_types != null) {
            this._mimeTypes.exclude((T[])StringUtil.csvSplit(excluded_mime_types));
        }
        if (included_http_methods != null) {
            this._httpMethods.include((T[])StringUtil.csvSplit(included_http_methods));
        }
        if (excluded_http_methods != null) {
            this._httpMethods.exclude((T[])StringUtil.csvSplit(excluded_http_methods));
        }
    }

    protected String guessMimeType(HttpServletRequest http_request, HttpServletResponse http_response) {
        String content_type = http_response.getContentType();
        LOG.debug("Content Type is: {}", content_type);
        String mime_type = "";
        if (content_type != null) {
            mime_type = MimeTypes.getContentTypeWithoutCharset(content_type);
            LOG.debug("Mime Type is: {}", mime_type);
        } else {
            String request_url = http_request.getPathInfo();
            mime_type = MimeTypes.getDefaultMimeByExtension(request_url);
            if (mime_type == null) {
                mime_type = "";
            }
            LOG.debug("Guessed mime type is {}", mime_type);
        }
        return mime_type;
    }

    protected boolean shouldFilter(HttpServletRequest http_request, HttpServletResponse http_response) {
        String http_method = http_request.getMethod();
        LOG.debug("HTTP method is: {}", http_method);
        if (!this._httpMethods.test(http_method)) {
            LOG.debug("should not apply filter because HTTP method does not match", new Object[0]);
            return false;
        }
        String mime_type = this.guessMimeType(http_request, http_response);
        if (!this._mimeTypes.test(mime_type)) {
            LOG.debug("should not apply filter because mime type does not match", new Object[0]);
            return false;
        }
        ServletContext context = http_request.getServletContext();
        String path = context == null ? http_request.getRequestURI() : URIUtil.addPaths(http_request.getServletPath(), http_request.getPathInfo());
        LOG.debug("Path is: {}", path);
        if (!this._paths.test(path)) {
            LOG.debug("should not apply filter because path does not match", new Object[0]);
            return false;
        }
        return true;
    }

    public void destroy() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("filter configuration:\n");
        sb.append("paths:\n").append(this._paths).append("\n");
        sb.append("mime types:\n").append(this._mimeTypes).append("\n");
        sb.append("http methods:\n").append(this._httpMethods);
        return sb.toString();
    }
}

