/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.sparkproject.jetty.io.ByteBufferPool;
import org.sparkproject.jetty.io.ChannelEndPoint;
import org.sparkproject.jetty.io.ManagedSelector;
import org.sparkproject.jetty.io.NetworkTrafficListener;
import org.sparkproject.jetty.io.NetworkTrafficSelectChannelEndPoint;
import org.sparkproject.jetty.server.ConnectionFactory;
import org.sparkproject.jetty.server.HttpConnectionFactory;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.ServerConnector;
import org.sparkproject.jetty.util.ssl.SslContextFactory;
import org.sparkproject.jetty.util.thread.Scheduler;

public class NetworkTrafficServerConnector
extends ServerConnector {
    private final List<NetworkTrafficListener> listeners = new CopyOnWriteArrayList<NetworkTrafficListener>();

    public NetworkTrafficServerConnector(Server server) {
        this(server, null, null, null, 0, 0, new HttpConnectionFactory());
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory) {
        super(server, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, selectors, factories);
    }

    public NetworkTrafficServerConnector(Server server, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory);
    }

    public void addNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.add(listener);
    }

    public void removeNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected ChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) throws IOException {
        NetworkTrafficSelectChannelEndPoint endPoint = new NetworkTrafficSelectChannelEndPoint(channel, selectSet, key, this.getScheduler(), this.getIdleTimeout(), this.listeners);
        return endPoint;
    }
}

