/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.io.ReadAheadInputStream;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.Closeables;

public final class UnsafeSorterSpillReader
extends UnsafeSorterIterator
implements Closeable {
    public static final int MAX_BUFFER_SIZE_BYTES = 0x1000000;
    private InputStream in;
    private DataInputStream din;
    private int recordLength;
    private long keyPrefix;
    private int numRecords;
    private int numRecordsRemaining;
    private byte[] arr = new byte[0x100000];
    private Object baseObject = this.arr;
    private final TaskContext taskContext = TaskContext.get();

    public UnsafeSorterSpillReader(SerializerManager serializerManager, File file, BlockId blockId) throws IOException {
        assert (file.length() > 0L);
        ConfigEntry<Object> bufferSizeConfigEntry = package$.MODULE$.UNSAFE_SORTER_SPILL_READER_BUFFER_SIZE();
        int DEFAULT_BUFFER_SIZE_BYTES = ((Long)bufferSizeConfigEntry.defaultValue().get()).intValue();
        int bufferSizeBytes = SparkEnv.get() == null ? DEFAULT_BUFFER_SIZE_BYTES : ((Long)SparkEnv.get().conf().get(bufferSizeConfigEntry)).intValue();
        boolean readAheadEnabled = SparkEnv.get() != null && (Boolean)SparkEnv.get().conf().get(package$.MODULE$.UNSAFE_SORTER_SPILL_READ_AHEAD_ENABLED()) != false;
        NioBufferedFileInputStream bs = new NioBufferedFileInputStream(file, bufferSizeBytes);
        try {
            this.in = readAheadEnabled ? new ReadAheadInputStream(serializerManager.wrapStream(blockId, bs), bufferSizeBytes) : serializerManager.wrapStream(blockId, bs);
            this.din = new DataInputStream(this.in);
            this.numRecords = this.numRecordsRemaining = this.din.readInt();
        }
        catch (IOException e) {
            Closeables.close((Closeable)bs, (boolean)true);
            throw e;
        }
    }

    @Override
    public int getNumRecords() {
        return this.numRecords;
    }

    @Override
    public boolean hasNext() {
        return this.numRecordsRemaining > 0;
    }

    @Override
    public void loadNext() throws IOException {
        if (this.taskContext != null) {
            this.taskContext.killTaskIfInterrupted();
        }
        this.recordLength = this.din.readInt();
        this.keyPrefix = this.din.readLong();
        if (this.recordLength > this.arr.length) {
            this.arr = new byte[this.recordLength];
            this.baseObject = this.arr;
        }
        ByteStreams.readFully((InputStream)this.in, (byte[])this.arr, (int)0, (int)this.recordLength);
        --this.numRecordsRemaining;
        if (this.numRecordsRemaining == 0) {
            this.close();
        }
    }

    @Override
    public Object getBaseObject() {
        return this.baseObject;
    }

    @Override
    public long getBaseOffset() {
        return Platform.BYTE_ARRAY_OFFSET;
    }

    @Override
    public int getRecordLength() {
        return this.recordLength;
    }

    @Override
    public long getKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.din = null;
            }
        }
    }
}

