/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.FIFOSchedulingAlgorithm;
import org.apache.spark.scheduler.FairSchedulingAlgorithm;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulingAlgorithm;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.scheduler.TaskSetManager;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005-f!B\u0014)\u0001)\u0002\u0004\u0002C!\u0001\u0005\u000b\u0007I\u0011A\"\t\u0011=\u0003!\u0011!Q\u0001\n\u0011C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\tC\u0002\u0011\t\u0011)A\u0005%\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003d\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001dq\u0007A1A\u0005\u0002=DaA\u001f\u0001!\u0002\u0013\u0001\bbB>\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003~\u0011%\t\u0019\u0001\u0001b\u0001\n\u0003\t)\u0001C\u0004\u0002\b\u0001\u0001\u000b\u0011B2\t\u0013\u0005%\u0001A1A\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0001\u0006Ia\u0019\u0005\n\u0003\u001b\u0001\u0001\u0019!C\u0001\u0003\u000bA\u0011\"a\u0004\u0001\u0001\u0004%\t!!\u0005\t\u000f\u0005u\u0001\u0001)Q\u0005G\"I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0011Q\u0001\u0005\b\u0003C\u0001\u0001\u0015!\u0003d\u0011%\t\u0019\u0003\u0001a\u0001\n\u0003\t)\u0001C\u0005\u0002&\u0001\u0001\r\u0011\"\u0001\u0002(!9\u00111\u0006\u0001!B\u0013\u0019\u0007\u0002CA\u0017\u0001\t\u0007I\u0011A\"\t\u000f\u0005=\u0002\u0001)A\u0005\t\"I\u0011\u0011\u0007\u0001A\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003k\u0001\u0001\u0019!C\u0001\u0003oAq!a\u000f\u0001A\u0003&\u0011\u000eC\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@!A\u0011q\t\u0001!\u0002\u0013\t\t\u0005C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\u000b\u0001\u0005B\u0005e\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003k\u0002A\u0011IA<\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!(\u0001\t\u0003\ty\nC\u0004\u0002&\u0002!\t!a*\u0003\tA{w\u000e\u001c\u0006\u0003S)\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001cB\u0001A\u00198wA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001d\u000e\u0003!J!A\u000f\u0015\u0003\u0017M\u001b\u0007.\u001a3vY\u0006\u0014G.\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003})\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0001v\u0012q\u0001T8hO&tw-\u0001\u0005q_>dg*Y7f\u0007\u0001)\u0012\u0001\u0012\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d\u001bT\"\u0001%\u000b\u0005%\u0013\u0015A\u0002\u001fs_>$h(\u0003\u0002Lg\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY5'A\u0005q_>dg*Y7fA\u0005q1o\u00195fIVd\u0017N\\4N_\u0012,W#\u0001*\u0011\u0005MsfB\u0001+]\u001d\t)6L\u0004\u0002W5:\u0011q+\u0017\b\u0003\u000fbK\u0011aL\u0005\u0003[9J!a\u000b\u0017\n\u0005%R\u0013BA/)\u00039\u00196\r[3ek2LgnZ'pI\u0016L!a\u00181\u0003\u001dM\u001b\u0007.\u001a3vY&tw-T8eK*\u0011Q\fK\u0001\u0010g\u000eDW\rZ;mS:<Wj\u001c3fA\u0005a\u0011N\\5u\u001b&t7\u000b[1sKB\u0011!\u0007Z\u0005\u0003KN\u00121!\u00138u\u0003)Ig.\u001b;XK&<\u0007\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%T7\u000e\\7\u0011\u0005a\u0002\u0001\"B!\b\u0001\u0004!\u0005\"\u0002)\b\u0001\u0004\u0011\u0006\"\u00022\b\u0001\u0004\u0019\u0007\"\u00024\b\u0001\u0004\u0019\u0017\u0001E:dQ\u0016$W\u000f\\1cY\u0016\fV/Z;f+\u0005\u0001\bcA9yo5\t!O\u0003\u0002ti\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U4\u0018\u0001B;uS2T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002ze\n)2i\u001c8dkJ\u0014XM\u001c;MS:\\W\rZ)vKV,\u0017!E:dQ\u0016$W\u000f\\1cY\u0016\fV/Z;fA\u0005a2o\u00195fIVd\u0017M\u00197f\u001d\u0006lW\rV8TG\",G-\u001e7bE2,W#A?\u0011\tEtHiN\u0005\u0003\u007fJ\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u0003u\u00198\r[3ek2\f'\r\\3OC6,Gk\\*dQ\u0016$W\u000f\\1cY\u0016\u0004\u0013AB<fS\u001eDG/F\u0001d\u0003\u001d9X-[4ii\u0002\n\u0001\"\\5o'\"\f'/Z\u0001\n[&t7\u000b[1sK\u0002\nAB];o]&tw\rV1tWN\f\u0001C];o]&tw\rV1tWN|F%Z9\u0015\t\u0005M\u0011\u0011\u0004\t\u0004e\u0005U\u0011bAA\fg\t!QK\\5u\u0011!\tY\"EA\u0001\u0002\u0004\u0019\u0017a\u0001=%c\u0005i!/\u001e8oS:<G+Y:lg\u0002\n\u0001\u0002\u001d:j_JLG/_\u0001\naJLwN]5us\u0002\nqa\u001d;bO\u0016LE-A\u0006ti\u0006<W-\u00133`I\u0015\fH\u0003BA\n\u0003SA\u0001\"a\u0007\u0017\u0003\u0003\u0005\raY\u0001\tgR\fw-Z%eA\u0005!a.Y7f\u0003\u0015q\u0017-\\3!\u0003\u0019\u0001\u0018M]3oiV\t\u0011.\u0001\u0006qCJ,g\u000e^0%KF$B!a\u0005\u0002:!A\u00111D\u000e\u0002\u0002\u0003\u0007\u0011.A\u0004qCJ,g\u000e\u001e\u0011\u00025Q\f7o[*fiN\u001b\u0007.\u001a3vY&tw-\u00117h_JLG\u000f[7\u0016\u0005\u0005\u0005\u0003c\u0001\u001d\u0002D%\u0019\u0011Q\t\u0015\u0003'M\u001b\u0007.\u001a3vY&tw-\u00117h_JLG\u000f[7\u00027Q\f7o[*fiN\u001b\u0007.\u001a3vY&tw-\u00117h_JLG\u000f[7!\u00039\tG\rZ*dQ\u0016$W\u000f\\1cY\u0016$B!a\u0005\u0002N!1\u0011qJ\u0010A\u0002]\n1b]2iK\u0012,H.\u00192mK\u0006\t\"/Z7pm\u0016\u001c6\r[3ek2\f'\r\\3\u0015\t\u0005M\u0011Q\u000b\u0005\u0007\u0003\u001f\u0002\u0003\u0019A\u001c\u0002)\u001d,GoU2iK\u0012,H.\u00192mK\nKh*Y7f)\r9\u00141\f\u0005\u0007\u0003;\n\u0003\u0019\u0001#\u0002\u001fM\u001c\u0007.\u001a3vY\u0006\u0014G.\u001a(b[\u0016\fA\"\u001a=fGV$xN\u001d'pgR$\u0002\"a\u0005\u0002d\u0005\u001d\u00141\u000e\u0005\u0007\u0003K\u0012\u0003\u0019\u0001#\u0002\u0015\u0015DXmY;u_JLE\r\u0003\u0004\u0002j\t\u0002\r\u0001R\u0001\u0005Q>\u001cH\u000fC\u0004\u0002n\t\u0002\r!a\u001c\u0002\rI,\u0017m]8o!\rA\u0014\u0011O\u0005\u0004\u0003gB#AE#yK\u000e,Ho\u001c:M_N\u001c(+Z1t_:\fac\u00195fG.\u001c\u0006/Z2vY\u0006$\u0018M\u00197f)\u0006\u001c8n\u001d\u000b\u0005\u0003s\ny\bE\u00023\u0003wJ1!! 4\u0005\u001d\u0011un\u001c7fC:Da!!!$\u0001\u0004\u0019\u0017\u0001F7j]RKW.\u001a+p'B,7-\u001e7bi&|g.A\u000bhKR\u001cvN\u001d;fIR\u000b7o[*fiF+X-^3\u0016\u0005\u0005\u001d\u0005CBAE\u0003'\u000b9*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u001diW\u000f^1cY\u0016T1!!%4\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003+\u000bYIA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bc\u0001\u001d\u0002\u001a&\u0019\u00111\u0014\u0015\u0003\u001dQ\u000b7o[*fi6\u000bg.Y4fe\u0006!\u0012N\\2sK\u0006\u001cXMU;o]&tw\rV1tWN$B!a\u0005\u0002\"\"1\u00111U\u0013A\u0002\r\fq\u0001^1tW:+X.\u0001\u000beK\u000e\u0014X-Y:f%Vtg.\u001b8h)\u0006\u001c8n\u001d\u000b\u0005\u0003'\tI\u000b\u0003\u0004\u0002$\u001a\u0002\ra\u0019")
public class Pool
implements Schedulable,
Logging {
    private final String poolName;
    private final Enumeration.Value schedulingMode;
    private final ConcurrentLinkedQueue<Schedulable> schedulableQueue;
    private final ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable;
    private final int weight;
    private final int minShare;
    private int runningTasks;
    private final int priority;
    private int stageId;
    private final String name;
    private Pool parent;
    private final SchedulingAlgorithm taskSetSchedulingAlgorithm;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String poolName() {
        return this.poolName;
    }

    @Override
    public Enumeration.Value schedulingMode() {
        return this.schedulingMode;
    }

    @Override
    public ConcurrentLinkedQueue<Schedulable> schedulableQueue() {
        return this.schedulableQueue;
    }

    public ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable() {
        return this.schedulableNameToSchedulable;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public int minShare() {
        return this.minShare;
    }

    @Override
    public int runningTasks() {
        return this.runningTasks;
    }

    public void runningTasks_$eq(int x$1) {
        this.runningTasks = x$1;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public int stageId() {
        return this.stageId;
    }

    public void stageId_$eq(int x$1) {
        this.stageId = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Pool parent() {
        return this.parent;
    }

    @Override
    public void parent_$eq(Pool x$1) {
        this.parent = x$1;
    }

    private SchedulingAlgorithm taskSetSchedulingAlgorithm() {
        return this.taskSetSchedulingAlgorithm;
    }

    @Override
    public void addSchedulable(Schedulable schedulable) {
        Predef$.MODULE$.require(schedulable != null);
        this.schedulableQueue().add(schedulable);
        this.schedulableNameToSchedulable().put(schedulable.name(), schedulable);
        schedulable.parent_$eq(this);
    }

    @Override
    public void removeSchedulable(Schedulable schedulable) {
        this.schedulableQueue().remove(schedulable);
        this.schedulableNameToSchedulable().remove(schedulable.name());
    }

    @Override
    public Schedulable getSchedulableByName(String schedulableName) {
        Schedulable schedulable2;
        Object object = new Object();
        try {
            if (this.schedulableNameToSchedulable().containsKey(schedulableName)) {
                return this.schedulableNameToSchedulable().get(schedulableName);
            }
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)schedulable -> {
                Pool.$anonfun$getSchedulableByName$1(schedulableName, object, schedulable);
                return BoxedUnit.UNIT;
            });
            schedulable2 = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                schedulable2 = (Schedulable)ex.value();
            }
            throw ex;
        }
        return schedulable2;
    }

    @Override
    public void executorLost(String executorId, String host, ExecutorLossReason reason) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.executorLost(executorId, host, reason);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean checkSpeculatableTasks(int minTimeToSpeculation) {
        BooleanRef shouldRevive = BooleanRef.create((boolean)false);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)schedulable -> {
            Pool.$anonfun$checkSpeculatableTasks$1(shouldRevive, minTimeToSpeculation, schedulable);
            return BoxedUnit.UNIT;
        });
        return shouldRevive.elem;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayBuffer<TaskSetManager> getSortedTaskSetQueue() {
        void var1_1;
        ArrayBuffer sortedTaskSetQueue = new ArrayBuffer();
        Seq sortedSchedulableQueue = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).toSeq().sortWith((Function2 & Serializable & scala.Serializable)(s1, s2) -> BoxesRunTime.boxToBoolean((boolean)Pool.$anonfun$getSortedTaskSetQueue$1(this, s1, s2)));
        sortedSchedulableQueue.foreach((Function1 & Serializable & scala.Serializable)schedulable -> sortedTaskSetQueue.$plus$plus$eq(schedulable.getSortedTaskSetQueue()));
        return var1_1;
    }

    public void increaseRunningTasks(int taskNum) {
        block0: {
            this.runningTasks_$eq(this.runningTasks() + taskNum);
            if (this.parent() == null) break block0;
            this.parent().increaseRunningTasks(taskNum);
        }
    }

    public void decreaseRunningTasks(int taskNum) {
        block0: {
            this.runningTasks_$eq(this.runningTasks() - taskNum);
            if (this.parent() == null) break block0;
            this.parent().decreaseRunningTasks(taskNum);
        }
    }

    public static final /* synthetic */ void $anonfun$getSchedulableByName$1(String schedulableName$1, Object nonLocalReturnKey1$1, Schedulable schedulable) {
        Schedulable sched = schedulable.getSchedulableByName(schedulableName$1);
        if (sched != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)sched);
        }
    }

    public static final /* synthetic */ void $anonfun$checkSpeculatableTasks$1(BooleanRef shouldRevive$1, int minTimeToSpeculation$1, Schedulable schedulable) {
        shouldRevive$1.elem |= schedulable.checkSpeculatableTasks(minTimeToSpeculation$1);
    }

    public static final /* synthetic */ boolean $anonfun$getSortedTaskSetQueue$1(Pool $this, Schedulable s1, Schedulable s2) {
        return $this.taskSetSchedulingAlgorithm().comparator(s1, s2);
    }

    public Pool(String poolName, Enumeration.Value schedulingMode, int initMinShare, int initWeight) {
        SchedulingAlgorithm schedulingAlgorithm;
        this.poolName = poolName;
        this.schedulingMode = schedulingMode;
        Logging.$init$(this);
        this.schedulableQueue = new ConcurrentLinkedQueue();
        this.schedulableNameToSchedulable = new ConcurrentHashMap();
        this.weight = initWeight;
        this.minShare = initMinShare;
        this.runningTasks = 0;
        this.priority = 0;
        this.stageId = -1;
        this.name = poolName;
        this.parent = null;
        Enumeration.Value value = schedulingMode;
        Enumeration.Value value2 = SchedulingMode$.MODULE$.FAIR();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            schedulingAlgorithm = new FairSchedulingAlgorithm();
        } else {
            Enumeration.Value value4 = SchedulingMode$.MODULE$.FIFO();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                schedulingAlgorithm = new FIFOSchedulingAlgorithm();
            } else {
                String msg = new StringBuilder(56).append("Unsupported scheduling mode: ").append(schedulingMode).append(". Use FAIR or FIFO instead.").toString();
                throw new IllegalArgumentException(msg);
            }
        }
        this.taskSetSchedulingAlgorithm = schedulingAlgorithm;
    }
}

