/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rpc.netty;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.rpc.IsolatedRpcEndpoint;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnvStoppedException;
import org.apache.spark.rpc.netty.DedicatedMessageLoop;
import org.apache.spark.rpc.netty.InboxMessage;
import org.apache.spark.rpc.netty.LocalNettyRpcCallContext;
import org.apache.spark.rpc.netty.MessageLoop;
import org.apache.spark.rpc.netty.NettyRpcEndpointRef;
import org.apache.spark.rpc.netty.NettyRpcEnv;
import org.apache.spark.rpc.netty.OneWayMessage;
import org.apache.spark.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.spark.rpc.netty.RequestMessage;
import org.apache.spark.rpc.netty.RpcMessage;
import org.apache.spark.rpc.netty.SharedMessageLoop;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.concurrent.Promise;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!B\u000e\u001d\u0001q1\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011e\u0002!\u0011!Q\u0001\niBQ!\u0010\u0001\u0005\u0002yBqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004]\u0001\u0001\u0006I\u0001\u0012\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u00199\u0007\u0001)A\u0005?\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007BB7\u0001A\u0003%!\u000e\u0003\u0005o\u0001!\u0015\r\u0011\"\u0003p\u0011\u001d\u0019\b\u00011A\u0005\nQDq\u0001\u001f\u0001A\u0002\u0013%\u0011\u0010\u0003\u0004\u0000\u0001\u0001\u0006K!\u001e\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!&\u0001\t\u0013\t9\nC\u0004\u0002@\u0001!\t!a/\t\u000f\u0005u\u0006\u0001\"\u0001\u0002<\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005'A\u0003#jgB\fGo\u00195fe*\u0011QDH\u0001\u0006]\u0016$H/\u001f\u0006\u0003?\u0001\n1A\u001d9d\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7c\u0001\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0011\u0002\u0011%tG/\u001a:oC2L!AM\u0018\u0003\u000f1{wmZ5oO\u0006Aa.\u001a;us\u0016sgo\u0001\u0001\u0011\u0005Y:T\"\u0001\u000f\n\u0005ab\"a\u0003(fiRL(\u000b]2F]Z\faB\\;n+N\f'\r\\3D_J,7\u000f\u0005\u0002)w%\u0011A(\u000b\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002@\u0001\u0006\u0003\"A\u000e\u0001\t\u000bM\u001a\u0001\u0019A\u001b\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002\u0013\u0015tG\r]8j]R\u001cX#\u0001#\u0011\t\u0015ce*W\u0007\u0002\r*\u0011q\tS\u0001\u000bG>t7-\u001e:sK:$(BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011QJ\u0012\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\u0005=3fB\u0001)U!\t\t\u0016&D\u0001S\u0015\t\u0019F'\u0001\u0004=e>|GOP\u0005\u0003+&\na\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011Q+\u000b\t\u0003miK!a\u0017\u000f\u0003\u00175+7o]1hK2{w\u000e]\u0001\u000bK:$\u0007o\\5oiN\u0004\u0013\u0001D3oIB|\u0017N\u001c;SK\u001a\u001cX#A0\u0011\t\u0015c\u0005\r\u001a\t\u0003C\nl\u0011AH\u0005\u0003Gz\u00111B\u00159d\u000b:$\u0007o\\5oiB\u0011\u0011-Z\u0005\u0003Mz\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g-A\u0007f]\u0012\u0004x.\u001b8u%\u001647\u000fI\u0001\u000eg\",H\u000fZ8x]2\u000bGo\u00195\u0016\u0003)\u0004\"!R6\n\u000514%AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u000fg\",H\u000fZ8x]2\u000bGo\u00195!\u0003)\u0019\b.\u0019:fI2{w\u000e]\u000b\u0002aB\u0011a']\u0005\u0003er\u0011\u0011c\u00155be\u0016$W*Z:tC\u001e,Gj\\8q\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012!\u001e\t\u0003QYL!a^\u0015\u0003\u000f\t{w\u000e\\3b]\u0006Y1\u000f^8qa\u0016$w\fJ3r)\tQX\u0010\u0005\u0002)w&\u0011A0\u000b\u0002\u0005+:LG\u000fC\u0004\u007f\u0019\u0005\u0005\t\u0019A;\u0002\u0007a$\u0013'\u0001\u0005ti>\u0004\b/\u001a3!Q\u001di\u00111AA\u000b\u0003/\u0001B!!\u0002\u0002\u00125\u0011\u0011q\u0001\u0006\u0004\u000f\u0006%!\u0002BA\u0006\u0003\u001b\t!\"\u00198o_R\fG/[8o\u0015\t\ty!A\u0003kCZ\f\u00070\u0003\u0003\u0002\u0014\u0005\u001d!!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\tI\"\u0001\u0003uQ&\u001c\u0018a\u0005:fO&\u001cH/\u001a:Sa\u000e,e\u000e\u001a9pS:$HCBA\u0010\u0003K\tI\u0003E\u00027\u0003CI1!a\t\u001d\u0005MqU\r\u001e;z%B\u001cWI\u001c3q_&tGOU3g\u0011\u0019\t9C\u0004a\u0001\u001d\u0006!a.Y7f\u0011\u0019\tYC\u0004a\u0001A\u0006AQM\u001c3q_&tG/A\thKR\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001a$2\u0001ZA\u0019\u0011\u0019\tYc\u0004a\u0001A\u0006!\"/Z7pm\u0016\u0014\u0006oY#oIB|\u0017N\u001c;SK\u001a$2A_A\u001c\u0011\u0019\tY\u0003\u0005a\u0001A\u0006)RO\u001c:fO&\u001cH/\u001a:Sa\u000e,e\u000e\u001a9pS:$Hc\u0001>\u0002>!1\u0011qE\tA\u00029\u000bAa\u001d;paR\u0019!0a\u0011\t\r\u0005\u0015#\u00031\u0001e\u00039\u0011\boY#oIB|\u0017N\u001c;SK\u001a\f\u0011\u0002]8tiR{\u0017\t\u001c7\u0015\u0007i\fY\u0005C\u0004\u0002NM\u0001\r!a\u0014\u0002\u000f5,7o]1hKB\u0019a'!\u0015\n\u0007\u0005MCD\u0001\u0007J]\n|\u00070T3tg\u0006<W-A\tq_N$(+Z7pi\u0016lUm]:bO\u0016$RA_A-\u0003CBq!!\u0014\u0015\u0001\u0004\tY\u0006E\u00027\u0003;J1!a\u0018\u001d\u00059\u0011V-];fgRlUm]:bO\u0016Dq!a\u0019\u0015\u0001\u0004\t)'\u0001\u0005dC2d'-Y2l!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\naa\u00197jK:$(bAA8A\u00059a.\u001a;x_J\\\u0017\u0002BA:\u0003S\u00121C\u00159d%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\f\u0001\u0003]8ti2{7-\u00197NKN\u001c\u0018mZ3\u0015\u000bi\fI(a\u001f\t\u000f\u00055S\u00031\u0001\u0002\\!9\u0011QP\u000bA\u0002\u0005}\u0014!\u00019\u0011\r\u0005\u0005\u0015QQAE\u001b\t\t\u0019I\u0003\u0002HS%!\u0011qQAB\u0005\u001d\u0001&o\\7jg\u0016\u00042\u0001KAF\u0013\r\ti)\u000b\u0002\u0004\u0003:L\u0018!\u00059pgR|e.Z,bs6+7o]1hKR\u0019!0a%\t\u000f\u00055c\u00031\u0001\u0002\\\u0005Y\u0001o\\:u\u001b\u0016\u001c8/Y4f)\u001dQ\u0018\u0011TAO\u0003?Ca!a'\u0018\u0001\u0004q\u0015\u0001D3oIB|\u0017N\u001c;OC6,\u0007bBA'/\u0001\u0007\u0011q\n\u0005\b\u0003C;\u0002\u0019AAR\u0003E\u0019\u0017\r\u001c7cC\u000e\\\u0017JZ*u_B\u0004X\r\u001a\t\u0007Q\u0005\u0015\u0016\u0011\u0016>\n\u0007\u0005\u001d\u0016FA\u0005Gk:\u001cG/[8ocA!\u00111VA[\u001d\u0011\ti+!-\u000f\u0007E\u000by+C\u0001+\u0013\r\t\u0019,K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9,!/\u0003\u0013\u0015C8-\u001a9uS>t'bAAZSQ\t!0\u0001\tbo\u0006LG\u000fV3s[&t\u0017\r^5p]\u00061a/\u001a:jMf$2!^Ab\u0011\u0019\t9C\u0007a\u0001\u001d\u0002")
public class Dispatcher
implements Logging {
    private SharedMessageLoop sharedLoop;
    private final NettyRpcEnv nettyEnv;
    private final int numUsableCores;
    private final ConcurrentMap<String, MessageLoop> endpoints;
    private final ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final CountDownLatch shutdownLatch;
    @GuardedBy(value="this")
    private boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<String, MessageLoop> endpoints() {
        return this.endpoints;
    }

    private ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private SharedMessageLoop sharedLoop$lzycompute() {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!this.bitmap$0) {
                this.sharedLoop = new SharedMessageLoop(this.nettyEnv.conf(), this, this.numUsableCores);
                this.bitmap$0 = true;
            }
        }
        return this.sharedLoop;
    }

    private SharedMessageLoop sharedLoop() {
        return !this.bitmap$0 ? this.sharedLoop$lzycompute() : this.sharedLoop;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.conf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                throw new IllegalStateException("RpcEnv has been stopped");
            }
            if (this.endpoints().containsKey(name)) {
                throw new IllegalArgumentException(new StringBuilder(39).append("There is already an RpcEndpoint called ").append(name).toString());
            }
            this.endpointRefs().put(endpoint, endpointRef);
            ObjectRef messageLoop = ObjectRef.create(null);
            this.liftedTree1$1(messageLoop, endpoint, name);
        }
        return endpointRef;
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return (RpcEndpointRef)this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    private void unregisterRpcEndpoint(String name) {
        block0: {
            MessageLoop loop = (MessageLoop)this.endpoints().remove(name);
            if (loop == null) break block0;
            loop.unregister(name);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
                Dispatcher.$anonfun$postToAll$1(this, message, e);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            callback.onFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            p.tryFailure((Throwable)e);
            return BoxedUnit.UNIT;
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)(Function1 & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    private void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Some some;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Some some2;
            MessageLoop loop = (MessageLoop)this.endpoints().get(endpointName);
            if (this.stopped()) {
                some2 = new Some((Object)new RpcEnvStoppedException());
            } else if (loop == null) {
                some2 = new Some((Object)new SparkException(new StringBuilder(16).append("Could not find ").append(endpointName).append(".").toString()));
            } else {
                loop.post(endpointName, message);
                some2 = None$.MODULE$;
            }
            some = some2;
        }
        Some error = some;
        error.foreach(callbackIfStopped);
    }

    public void stop() {
        block5: {
            Dispatcher dispatcher = this;
            synchronized (dispatcher) {
                block4: {
                    if (this.stopped()) break block4;
                    this.stopped_$eq(true);
                    break block5;
                }
                return;
            }
        }
        BooleanRef stopSharedLoop = BooleanRef.create((boolean)false);
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.endpoints()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Dispatcher.$anonfun$stop$1(this, stopSharedLoop, x0$1);
            return BoxedUnit.UNIT;
        });
        if (stopSharedLoop.elem) {
            this.sharedLoop().stop();
        }
        this.shutdownLatch().countDown();
    }

    public void awaitTermination() {
        this.shutdownLatch().await();
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    private final MessageLoop liftedTree1$1(ObjectRef messageLoop$1, RpcEndpoint endpoint$1, String name$1) {
        MessageLoop messageLoop;
        try {
            MessageLoop messageLoop2;
            RpcEndpoint rpcEndpoint = endpoint$1;
            if (rpcEndpoint instanceof IsolatedRpcEndpoint) {
                IsolatedRpcEndpoint isolatedRpcEndpoint = (IsolatedRpcEndpoint)rpcEndpoint;
                messageLoop2 = new DedicatedMessageLoop(name$1, isolatedRpcEndpoint, this);
            } else {
                this.sharedLoop().register(name$1, endpoint$1);
                messageLoop2 = this.sharedLoop();
            }
            messageLoop$1.elem = messageLoop2;
            messageLoop = this.endpoints().put(name$1, (MessageLoop)messageLoop$1.elem);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.endpointRefs().remove(endpoint$1);
                throw e;
            }
            throw throwable;
        }
        return messageLoop;
    }

    public static final /* synthetic */ void $anonfun$postToAll$1(Dispatcher $this, InboxMessage message$1, Exception e) {
        Exception exception = e;
        if (exception instanceof RpcEnvStoppedException) {
            RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)exception;
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(rpcEnvStoppedException.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (exception != null) {
            Exception exception2 = exception;
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(exception2.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)exception);
        }
    }

    public static final /* synthetic */ void $anonfun$stop$1(Dispatcher $this, BooleanRef stopSharedLoop$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            MessageLoop loop = (MessageLoop)tuple2._2();
            $this.unregisterRpcEndpoint(name);
            if (!(loop instanceof SharedMessageLoop)) {
                loop.stop();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                stopSharedLoop$1.elem = true;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public Dispatcher(NettyRpcEnv nettyEnv, int numUsableCores) {
        this.nettyEnv = nettyEnv;
        this.numUsableCores = numUsableCores;
        Logging.$init$(this);
        this.endpoints = new ConcurrentHashMap<String, MessageLoop>();
        this.endpointRefs = new ConcurrentHashMap<RpcEndpoint, RpcEndpointRef>();
        this.shutdownLatch = new CountDownLatch(1);
        this.stopped = false;
    }
}

