/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol$;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.mapred.SparkHadoopMapRedUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001\u0002\u0011\"\u00011B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005y!A\u0001\n\u0001B\u0001B\u0003%\u0011\nC\u0003M\u0001\u0011\u0005Q\nC\u0005S\u0001\u0001\u0007\t\u0019!C\u0005'\"IA\f\u0001a\u0001\u0002\u0004%I!\u0018\u0005\nG\u0002\u0001\r\u0011!Q!\nQCq\u0001\u001b\u0001C\u0002\u0013%\u0011\u000e\u0003\u0004k\u0001\u0001\u0006I!\u0013\u0005\bW\u0002\u0001\r\u0011\"\u0003m\u0011\u001d)\b\u00011A\u0005\nYDa\u0001\u001f\u0001!B\u0013i\u0007b\u0002>\u0001\u0001\u0004%Ia\u001f\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!9\u0011Q\u0001\u0001!B\u0013a\bbBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u00033\u0001A\u0011CA\u000e\u0011\u001d\t9\u0003\u0001C!\u0003SAq!!\u0010\u0001\t\u0003\ny\u0004C\u0004\u0002J\u0001!\t\"a\u0013\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\t)\n\u0001C!\u0003/Cq!a'\u0001\t\u0003\nijB\u0005\u0002\"\u0006\n\t\u0011#\u0001\u0002$\u001aA\u0001%IA\u0001\u0012\u0003\t)\u000b\u0003\u0004M9\u0011\u0005\u0011Q\u0016\u0005\n\u0003_c\u0012\u0013!C\u0001\u0003cC\u0011\"a2\u001d\u0003\u0003%I!!3\u0003;!\u000bGm\\8q\u001b\u0006\u0004(+\u001a3vG\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2T!AI\u0012\u0002\u0005%|'B\u0001\u0013&\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M!\u0001!L\u00198!\tqs&D\u0001\"\u0013\t\u0001\u0014E\u0001\nGS2,7i\\7nSR\u0004&o\u001c;pG>d\u0007C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001D*fe&\fG.\u001b>bE2,\u0007C\u0001\u001d:\u001b\u0005\u0019\u0013B\u0001\u001e$\u0005\u001daunZ4j]\u001e\fQA[8c\u0013\u0012\u0004\"!\u0010#\u000f\u0005y\u0012\u0005CA 4\u001b\u0005\u0001%BA!,\u0003\u0019a$o\\8u}%\u00111iM\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002Dg\u0005!\u0001/\u0019;i\u0003e!\u0017P\\1nS\u000e\u0004\u0016M\u001d;ji&|gn\u0014<fe^\u0014\u0018\u000e^3\u0011\u0005IR\u0015BA&4\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0002(P!F\u0003\"A\f\u0001\t\u000bm\"\u0001\u0019\u0001\u001f\t\u000b\u001d#\u0001\u0019\u0001\u001f\t\u000f!#\u0001\u0013!a\u0001\u0013\u0006I1m\\7nSR$XM]\u000b\u0002)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!!W\u0014\u0002\r!\fGm\\8q\u0013\tYfKA\bPkR\u0004X\u000f^\"p[6LG\u000f^3s\u00035\u0019w.\\7jiR,'o\u0018\u0013fcR\u0011a,\u0019\t\u0003e}K!\u0001Y\u001a\u0003\tUs\u0017\u000e\u001e\u0005\bE\u001a\t\t\u00111\u0001U\u0003\rAH%M\u0001\u000bG>lW.\u001b;uKJ\u0004\u0003FA\u0004f!\t\u0011d-\u0003\u0002hg\tIAO]1og&,g\u000e^\u0001\rQ\u0006\u001ch+\u00197jIB\u000bG\u000f[\u000b\u0002\u0013\u0006i\u0001.Y:WC2LG\rU1uQ\u0002\n\u0011#\u00193eK\u0012\f%m\u001d)bi\"4\u0015\u000e\\3t+\u0005i\u0007\u0003\u00028tyqj\u0011a\u001c\u0006\u0003aF\fq!\\;uC\ndWM\u0003\u0002sg\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Q|'aA'ba\u0006)\u0012\r\u001a3fI\u0006\u00137\u000fU1uQ\u001aKG.Z:`I\u0015\fHC\u00010x\u0011\u001d\u00117\"!AA\u00025\f!#\u00193eK\u0012\f%m\u001d)bi\"4\u0015\u000e\\3tA!\u0012A\"Z\u0001\u000fa\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5t+\u0005a\bc\u00018~y%\u0011ap\u001c\u0002\u0004'\u0016$\u0018A\u00059beRLG/[8o!\u0006$\bn]0%KF$2AXA\u0002\u0011\u001d\u0011g\"!AA\u0002q\fq\u0002]1si&$\u0018n\u001c8QCRD7\u000f\t\u0015\u0003\u001f\u0015\f!b\u001d;bO&tw\rR5s+\t\ti\u0001\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002W\u0001\u0003MNLA!a\u0006\u0002\u0012\t!\u0001+\u0019;i\u00039\u0019X\r^;q\u0007>lW.\u001b;uKJ$2\u0001VA\u000f\u0011\u001d\ty\"\u0005a\u0001\u0003C\tqaY8oi\u0016DH\u000fE\u0002V\u0003GI1!!\nW\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\u001f9,w\u000fV1tWR+W\u000e\u001d$jY\u0016$r\u0001PA\u0016\u0003_\tI\u0004C\u0004\u0002.I\u0001\r!!\t\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003c\u0011\u0002\u0019AA\u001a\u0003\r!\u0017N\u001d\t\u0005e\u0005UB(C\u0002\u00028M\u0012aa\u00149uS>t\u0007BBA\u001e%\u0001\u0007A(A\u0002fqR\faC\\3x)\u0006\u001c8\u000eV3na\u001aKG.Z!cgB\u000bG\u000f\u001b\u000b\by\u0005\u0005\u00131IA$\u0011\u001d\tic\u0005a\u0001\u0003CAa!!\u0012\u0014\u0001\u0004a\u0014aC1cg>dW\u000f^3ESJDa!a\u000f\u0014\u0001\u0004a\u0014aC4fi\u001aKG.\u001a8b[\u0016$R\u0001PA'\u0003\u001fBq!!\f\u0015\u0001\u0004\t\t\u0003\u0003\u0004\u0002<Q\u0001\r\u0001P\u0001\tg\u0016$X\u000f\u001d&pER\u0019a,!\u0016\t\u000f\u0005]S\u00031\u0001\u0002Z\u0005Q!n\u001c2D_:$X\r\u001f;\u0011\u0007U\u000bY&C\u0002\u0002^Y\u0013!BS8c\u0007>tG/\u001a=u\u0003%\u0019w.\\7ji*{'\rF\u0003_\u0003G\n)\u0007C\u0004\u0002XY\u0001\r!!\u0017\t\u000f\u0005\u001dd\u00031\u0001\u0002j\u0005YA/Y:l\u0007>lW.\u001b;t!\u0019\tY'!\u001e\u0002|9!\u0011QNA9\u001d\ry\u0014qN\u0005\u0002i%\u0019\u00111O\u001a\u0002\u000fA\f7m[1hK&!\u0011qOA=\u0005\r\u0019V-\u001d\u0006\u0004\u0003g\u001a\u0004\u0003BA?\u0003\u0007s1ALA@\u0013\r\t\t)I\u0001\u0013\r&dWmQ8n[&$\bK]8u_\u000e|G.\u0003\u0003\u0002\u0006\u0006\u001d%!\u0005+bg.\u001cu.\\7ji6+7o]1hK*\u0019\u0011\u0011Q\u0011\u0002\u0011\u0005\u0014wN\u001d;K_\n$2AXAG\u0011\u001d\t9f\u0006a\u0001\u00033\n\u0011b]3ukB$\u0016m]6\u0015\u0007y\u000b\u0019\nC\u0004\u0002.a\u0001\r!!\t\u0002\u0015\r|W.\\5u)\u0006\u001c8\u000e\u0006\u0003\u0002|\u0005e\u0005bBA\u00173\u0001\u0007\u0011\u0011E\u0001\nC\n|'\u000f\u001e+bg.$2AXAP\u0011\u001d\tiC\u0007a\u0001\u0003C\tQ\u0004S1e_>\u0004X*\u00199SK\u0012,8-Z\"p[6LG\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003]q\u0019B\u0001HATcA\u0019!'!+\n\u0007\u0005-6G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003G\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAAZU\rI\u0015QW\u0016\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011Y\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0006m&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\r\u0005\u0003\u0002N\u0006]WBAAh\u0015\u0011\t\t.a5\u0002\t1\fgn\u001a\u0006\u0003\u0003+\fAA[1wC&!\u0011\u0011\\Ah\u0005\u0019y%M[3di\u0002")
public class HadoopMapReduceCommitProtocol
extends FileCommitProtocol
implements scala.Serializable {
    private final String jobId;
    private final String path;
    private final boolean dynamicPartitionOverwrite;
    private transient OutputCommitter committer;
    private final boolean hasValidPath;
    private transient Map<String, String> addedAbsPathFiles;
    private transient Set<String> partitionPaths;

    public static boolean $lessinit$greater$default$3() {
        return HadoopMapReduceCommitProtocol$.MODULE$.$lessinit$greater$default$3();
    }

    private OutputCommitter committer() {
        return this.committer;
    }

    private void committer_$eq(OutputCommitter x$1) {
        this.committer = x$1;
    }

    private boolean hasValidPath() {
        return this.hasValidPath;
    }

    private Map<String, String> addedAbsPathFiles() {
        return this.addedAbsPathFiles;
    }

    private void addedAbsPathFiles_$eq(Map<String, String> x$1) {
        this.addedAbsPathFiles = x$1;
    }

    private Set<String> partitionPaths() {
        return this.partitionPaths;
    }

    private void partitionPaths_$eq(Set<String> x$1) {
        this.partitionPaths = x$1;
    }

    private Path stagingDir() {
        return new Path(this.path, new StringBuilder(15).append(".spark-staging-").append(this.jobId).toString());
    }

    public OutputCommitter setupCommitter(TaskAttemptContext context) {
        OutputFormat format = (OutputFormat)context.getOutputFormatClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        OutputFormat outputFormat = format;
        if (outputFormat instanceof Configurable) {
            OutputFormat outputFormat2 = outputFormat;
            ((Configurable)outputFormat2).setConf(context.getConfiguration());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return format.getOutputCommitter(context);
    }

    @Override
    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        Path path;
        String filename = this.getFilename(taskContext, ext);
        OutputCommitter outputCommitter = this.committer();
        if (this.dynamicPartitionOverwrite) {
            Predef$.MODULE$.assert(dir.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "The dataset to be written must be partitioned when dynamicPartitionOverwrite is true.");
            this.partitionPaths().$plus$eq(dir.get());
            path = this.stagingDir();
        } else if (outputCommitter instanceof FileOutputCommitter) {
            FileOutputCommitter fileOutputCommitter = (FileOutputCommitter)outputCommitter;
            path = new Path((String)Option$.MODULE$.apply((Object)fileOutputCommitter.getWorkPath()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.path));
        } else {
            path = new Path(this.path);
        }
        Path stagingDir = path;
        return (String)dir.map((Function1 & Serializable & scala.Serializable)d -> new Path(new Path(stagingDir, d), filename).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path(stagingDir, filename).toString());
    }

    @Override
    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        String filename = this.getFilename(taskContext, ext);
        String absOutputPath = new Path(absoluteDir, filename).toString();
        String tmpOutputPath = new Path(this.stagingDir(), new StringBuilder(1).append(UUID.randomUUID().toString()).append("-").append(filename).toString()).toString();
        this.addedAbsPathFiles().update((Object)tmpOutputPath, (Object)absOutputPath);
        return tmpOutputPath;
    }

    public String getFilename(TaskAttemptContext taskContext, String ext) {
        int split;
        int arg$macro$1 = split = taskContext.getTaskAttemptID().getTaskID().getId();
        String arg$macro$2 = this.jobId;
        String arg$macro$3 = ext;
        return new StringOps("part-%05d-%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), arg$macro$2, arg$macro$3}));
    }

    @Override
    public void setupJob(JobContext jobContext) {
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(), 0);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
        jobContext.getConfiguration().set("mapreduce.job.id", jobId.toString());
        jobContext.getConfiguration().set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        jobContext.getConfiguration().set("mapreduce.task.attempt.id", taskAttemptId.toString());
        jobContext.getConfiguration().setBoolean("mapreduce.task.ismap", true);
        jobContext.getConfiguration().setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(jobContext.getConfiguration(), taskAttemptId);
        this.committer_$eq(this.setupCommitter((TaskAttemptContext)taskAttemptContext));
        this.committer().setupJob(jobContext);
    }

    @Override
    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        block3: {
            this.committer().commitJob(jobContext);
            if (!this.hasValidPath()) break block3;
            Tuple2 tuple2 = ((GenericTraversableTemplate)taskCommits.map((Function1 & Serializable & scala.Serializable)x$2 -> (Tuple2)x$2.obj(), Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq allAbsPathFiles = (Seq)tuple2._1();
            Seq allPartitionPaths = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)allAbsPathFiles, (Object)allPartitionPaths);
            Tuple2 tuple23 = tuple22;
            Seq allAbsPathFiles2 = (Seq)tuple23._1();
            Seq allPartitionPaths2 = (Seq)tuple23._2();
            FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
            scala.collection.immutable.Map filesToMove = (scala.collection.immutable.Map)allAbsPathFiles2.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.$plus$plus((GenTraversableOnce)x$5));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Committing files staged for absolute locations ").append(filesToMove).toString());
            if (this.dynamicPartitionOverwrite) {
                scala.collection.immutable.Set absPartitionPaths = ((TraversableOnce)filesToMove.values().map((Function1 & Serializable & scala.Serializable)x$6 -> new Path(x$6).getParent(), Iterable$.MODULE$.canBuildFrom())).toSet();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Clean up absolute partition directories for overwriting: ").append(absPartitionPaths).toString());
                absPartitionPaths.foreach((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)fs.delete(x$7, true)));
            }
            filesToMove.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$commitJob$7(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$commitJob$8(fs, x$8)));
            if (this.dynamicPartitionOverwrite) {
                scala.collection.immutable.Set partitionPaths = (scala.collection.immutable.Set)allPartitionPaths2.foldLeft((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> (scala.collection.immutable.Set)x$9.$plus$plus((GenTraversableOnce)x$10));
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Clean up default partition directories for overwriting: ").append(partitionPaths).toString());
                partitionPaths.foreach((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$commitJob$11(this, fs, part)));
            }
            fs.delete(this.stagingDir(), true);
        }
    }

    @Override
    public void abortJob(JobContext jobContext) {
        try {
            this.committer().abortJob(jobContext, JobStatus.State.FAILED);
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(jobContext.getJobID()).toString(), e);
        }
        try {
            if (this.hasValidPath()) {
                FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
                fs.delete(this.stagingDir(), true);
            }
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(jobContext.getJobID()).toString(), e);
        }
    }

    @Override
    public void setupTask(TaskAttemptContext taskContext) {
        this.committer_$eq(this.setupCommitter(taskContext));
        this.committer().setupTask(taskContext);
        this.addedAbsPathFiles_$eq((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.partitionPaths_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    @Override
    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        TaskAttemptID attemptId = taskContext.getTaskAttemptID();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Commit task ").append(attemptId).toString());
        SparkHadoopMapRedUtil$.MODULE$.commitTask(this.committer(), taskContext, attemptId.getJobID().getId(), attemptId.getTaskID().getId());
        return new FileCommitProtocol.TaskCommitMessage(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.addedAbsPathFiles().toMap(Predef$.MODULE$.$conforms())), (Object)this.partitionPaths().toSet()));
    }

    @Override
    public void abortTask(TaskAttemptContext taskContext) {
        try {
            this.committer().abortTask(taskContext);
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(taskContext.getTaskAttemptID()).toString(), e);
        }
        try {
            this.addedAbsPathFiles().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$3(taskContext, x$11)));
        }
        catch (IOException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Exception while aborting ").append(taskContext.getTaskAttemptID()).toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$commitJob$7(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$commitJob$8(FileSystem fs$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String src = (String)tuple2._1();
        String dst = (String)tuple2._2();
        boolean bl = fs$1.rename(new Path(src), new Path(dst));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$commitJob$11(HadoopMapReduceCommitProtocol $this, FileSystem fs$1, String part) {
        Path finalPartPath = new Path($this.path, part);
        Object object = !fs$1.delete(finalPartPath, true) && !fs$1.exists(finalPartPath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs$1.mkdirs(finalPartPath.getParent())) : BoxedUnit.UNIT;
        return fs$1.rename(new Path($this.stagingDir(), part), finalPartPath);
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$3(TaskAttemptContext taskContext$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String src = (String)tuple2._1();
        Path tmp = new Path(src);
        boolean bl = tmp.getFileSystem(taskContext$1.getConfiguration()).delete(tmp, false);
        return bl;
    }

    public HadoopMapReduceCommitProtocol(String jobId, String path, boolean dynamicPartitionOverwrite) {
        this.jobId = jobId;
        this.path = path;
        this.dynamicPartitionOverwrite = dynamicPartitionOverwrite;
        this.hasValidPath = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Path($this.path)).isSuccess();
        this.addedAbsPathFiles = null;
        this.partitionPaths = null;
    }
}

