/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.configuration.plugins.DefaultMockitoPlugins;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.plugins.MockMaker;
import org.mockito.plugins.MockResolver;

public class MockUtil {
    private static final MockMaker defaultMockMaker = Plugins.getMockMaker();
    private static final Map<Class<? extends MockMaker>, MockMaker> mockMakers = new ConcurrentHashMap(Collections.singletonMap(defaultMockMaker.getClass(), defaultMockMaker));

    private MockUtil() {
    }

    private static MockMaker getMockMaker(String mockMaker) {
        Class<MockMaker> type;
        if (mockMaker == null) {
            return defaultMockMaker;
        }
        String typeName = DefaultMockitoPlugins.MOCK_MAKER_ALIASES.contains(mockMaker) ? DefaultMockitoPlugins.getDefaultPluginClass(mockMaker) : mockMaker;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            type = loader.loadClass(typeName).asSubclass(MockMaker.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load MockMaker: " + mockMaker, e);
        }
        return mockMakers.computeIfAbsent(type, t -> {
            try {
                return (MockMaker)t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to construct MockMaker: " + t.getName(), e);
            }
        });
    }

    public static MockMaker.TypeMockability typeMockabilityOf(Class<?> type, String mockMaker) {
        return MockUtil.getMockMaker(mockMaker).isTypeMockable(type);
    }

    public static <T> T createMock(MockCreationSettings<T> settings) {
        MockMaker mockMaker = MockUtil.getMockMaker(settings.getMockMaker());
        MockHandler mockHandler = MockHandlerFactory.createMockHandler(settings);
        Object spiedInstance = settings.getSpiedInstance();
        Object mock = spiedInstance != null ? mockMaker.createSpy(settings, mockHandler, spiedInstance).orElseGet(() -> {
            Object instance = mockMaker.createMock(settings, mockHandler);
            new LenientCopyTool().copyToMock(spiedInstance, instance);
            return instance;
        }) : mockMaker.createMock(settings, mockHandler);
        return mock;
    }

    public static void resetMock(Object mock) {
        MockHandler<?> oldHandler = MockUtil.getMockHandler(mock);
        MockCreationSettings<?> settings = oldHandler.getMockSettings();
        MockHandler<?> newHandler = MockHandlerFactory.createMockHandler(settings);
        mock = MockUtil.resolve(mock);
        MockUtil.getMockMaker(settings.getMockMaker()).resetMock(mock, newHandler, settings);
    }

    public static MockHandler<?> getMockHandler(Object mock) {
        MockHandler<?> handler = MockUtil.getMockHandlerOrNull(mock);
        if (handler != null) {
            return handler;
        }
        throw new NotAMockException("Argument should be a mock, but is: " + mock.getClass());
    }

    public static InvocationContainerImpl getInvocationContainer(Object mock) {
        return (InvocationContainerImpl)MockUtil.getMockHandler(mock).getInvocationContainer();
    }

    public static boolean isSpy(Object mock) {
        return MockUtil.isMock(mock) && MockUtil.getMockSettings(mock).getDefaultAnswer() == Mockito.CALLS_REAL_METHODS;
    }

    public static boolean isMock(Object mock) {
        if (mock == null) {
            return false;
        }
        return MockUtil.getMockHandlerOrNull(mock) != null;
    }

    private static MockHandler<?> getMockHandlerOrNull(Object mock) {
        if (mock == null) {
            throw new NotAMockException("Argument should be a mock, but is null!");
        }
        mock = MockUtil.resolve(mock);
        for (MockMaker mockMaker : mockMakers.values()) {
            MockHandler handler = mockMaker.getHandler(mock);
            if (handler == null) continue;
            assert (MockUtil.getMockMaker(handler.getMockSettings().getMockMaker()) == mockMaker);
            return handler;
        }
        return null;
    }

    private static Object resolve(Object mock) {
        if (mock instanceof Class) {
            return mock;
        }
        for (MockResolver mockResolver : Plugins.getMockResolvers()) {
            mock = mockResolver.resolve(mock);
        }
        return mock;
    }

    public static boolean areSameMocks(Object mockA, Object mockB) {
        return mockA == mockB || MockUtil.resolve(mockA) == MockUtil.resolve(mockB);
    }

    public static MockName getMockName(Object mock) {
        return MockUtil.getMockHandler(mock).getMockSettings().getMockName();
    }

    public static void maybeRedefineMockName(Object mock, String newName) {
        MockName mockName = MockUtil.getMockName(mock);
        MockCreationSettings<?> mockSettings = MockUtil.getMockHandler(mock).getMockSettings();
        if (mockName.isDefault() && mockSettings instanceof CreationSettings) {
            ((CreationSettings)mockSettings).setMockName(new MockNameImpl(newName));
        }
    }

    public static MockCreationSettings getMockSettings(Object mock) {
        return MockUtil.getMockHandler(mock).getMockSettings();
    }

    public static <T> MockMaker.StaticMockControl<T> createStaticMock(Class<T> type, MockCreationSettings<T> settings) {
        MockMaker mockMaker = MockUtil.getMockMaker(settings.getMockMaker());
        MockHandler<T> handler = MockHandlerFactory.createMockHandler(settings);
        return mockMaker.createStaticMock(type, settings, handler);
    }

    public static <T> MockMaker.ConstructionMockControl<T> createConstructionMock(Class<T> type, Function<MockedConstruction.Context, MockCreationSettings<T>> settingsFactory, MockedConstruction.MockInitializer<T> mockInitializer) {
        Function handlerFactory = context -> MockHandlerFactory.createMockHandler((MockCreationSettings)settingsFactory.apply((MockedConstruction.Context)context));
        return defaultMockMaker.createConstructionMock(type, settingsFactory, handlerFactory, mockInitializer);
    }

    public static void clearAllCaches() {
        for (MockMaker mockMaker : mockMakers.values()) {
            mockMaker.clearAllCaches();
        }
    }
}

