/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.hamcrest.HamcrestArgumentMatcher;
import org.mockito.internal.invocation.ArgumentMatcherAction;
import org.mockito.internal.matchers.VarargMatcher;
import org.mockito.invocation.Invocation;

public class MatcherApplicationStrategy {
    private final Invocation invocation;
    private final List<? extends ArgumentMatcher<?>> matchers;

    private MatcherApplicationStrategy(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        this.invocation = invocation;
        this.matchers = matchers;
    }

    public static MatcherApplicationStrategy getMatcherApplicationStrategyFor(Invocation invocation, List<? extends ArgumentMatcher<?>> matchers) {
        return new MatcherApplicationStrategy(invocation, matchers);
    }

    public boolean forEachMatcherAndArgument(ArgumentMatcherAction action) {
        boolean isVararg;
        if (this.invocation.getArguments().length == this.matchers.size()) {
            return this.argsMatch(this.invocation.getArguments(), this.matchers, action);
        }
        boolean bl = isVararg = this.invocation.getMethod().isVarArgs() && this.invocation.getRawArguments().length == this.matchers.size() && MatcherApplicationStrategy.isLastMatcherVarargMatcher(this.matchers);
        if (isVararg) {
            int times = MatcherApplicationStrategy.varargLength(this.invocation);
            List<? extends ArgumentMatcher<?>> matchers = this.appendLastMatcherNTimes(times);
            return this.argsMatch(this.invocation.getArguments(), matchers, action);
        }
        return false;
    }

    private boolean argsMatch(Object[] arguments, List<? extends ArgumentMatcher<?>> matchers, ArgumentMatcherAction action) {
        for (int i = 0; i < arguments.length; ++i) {
            Object argument;
            ArgumentMatcher<?> matcher = matchers.get(i);
            if (action.apply(matcher, argument = arguments[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isLastMatcherVarargMatcher(List<? extends ArgumentMatcher<?>> matchers) {
        ArgumentMatcher<?> argumentMatcher = MatcherApplicationStrategy.lastMatcher(matchers);
        if (argumentMatcher instanceof HamcrestArgumentMatcher) {
            return ((HamcrestArgumentMatcher)argumentMatcher).isVarargMatcher();
        }
        return argumentMatcher instanceof VarargMatcher;
    }

    private List<? extends ArgumentMatcher<?>> appendLastMatcherNTimes(int timesToAppendLastMatcher) {
        ArgumentMatcher<?> lastMatcher = MatcherApplicationStrategy.lastMatcher(this.matchers);
        ArrayList expandedMatchers = new ArrayList(this.matchers);
        for (int i = 0; i < timesToAppendLastMatcher; ++i) {
            expandedMatchers.add(lastMatcher);
        }
        return expandedMatchers;
    }

    private static int varargLength(Invocation invocation) {
        int rawArgumentCount = invocation.getRawArguments().length;
        int expandedArgumentCount = invocation.getArguments().length;
        return expandedArgumentCount - rawArgumentCount;
    }

    private static ArgumentMatcher<?> lastMatcher(List<? extends ArgumentMatcher<?>> matchers) {
        return matchers.get(matchers.size() - 1);
    }
}

