/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.log.LogBufferSegment;
import com.sleepycat.je.log.LogSource;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class LogBuffer
implements LogSource {
    private static final String DEBUG_NAME = LogBuffer.class.getName();
    private final ByteBuffer buffer;
    private long firstLsn;
    private long lastLsn;
    private Latch readLatch;
    private boolean rewriteAllowed;
    private AtomicInteger writePinCount = new AtomicInteger();
    private byte[] data;
    private EnvironmentImpl env;

    LogBuffer(int capacity, EnvironmentImpl env) throws DatabaseException {
        this.data = new byte[capacity];
        this.buffer = ByteBuffer.wrap(this.data);
        this.readLatch = LatchFactory.createExclusiveLatch(env, DEBUG_NAME, false);
        this.env = env;
        this.reinit();
    }

    LogBuffer(ByteBuffer buffer, long firstLsn) {
        this.buffer = buffer;
        this.firstLsn = firstLsn;
        this.lastLsn = firstLsn;
        this.rewriteAllowed = false;
    }

    void reinit() throws DatabaseException {
        this.readLatch.acquireExclusive();
        this.buffer.clear();
        this.firstLsn = -1L;
        this.lastLsn = -1L;
        this.rewriteAllowed = false;
        this.writePinCount.set(0);
        this.readLatch.release();
    }

    public long getFirstLsn() {
        return this.firstLsn;
    }

    void registerLsn(long lsn) {
        assert (this.readLatch.isExclusiveOwner());
        if (this.lastLsn != -1L) assert (DbLsn.compareTo(lsn, this.lastLsn) > 0) : "lsn=" + lsn + " lastlsn=" + this.lastLsn;
        this.lastLsn = lsn;
        if (this.firstLsn == -1L) {
            this.firstLsn = lsn;
        }
    }

    boolean hasRoom(int numBytes) {
        return numBytes <= this.buffer.capacity() - this.buffer.position();
    }

    public ByteBuffer getDataBuffer() {
        return this.buffer;
    }

    int getCapacity() {
        return this.buffer.capacity();
    }

    boolean containsLsn(long lsn) {
        assert (lsn != -1L);
        this.waitForZeroAndLatch();
        boolean found = false;
        if (this.firstLsn != -1L && DbLsn.getFileNumber(this.firstLsn) == DbLsn.getFileNumber(lsn)) {
            long fileOffset = DbLsn.getFileOffset(lsn);
            int contentSize = this.buffer.position() == 0 ? this.buffer.limit() : this.buffer.position();
            long firstLsnOffset = DbLsn.getFileOffset(this.firstLsn);
            long lastContentOffset = firstLsnOffset + (long)contentSize;
            if (firstLsnOffset <= fileOffset && lastContentOffset > fileOffset) {
                found = true;
            }
        }
        if (found) {
            return true;
        }
        this.readLatch.release();
        return false;
    }

    public void latchForWrite() throws DatabaseException {
        this.readLatch.acquireExclusive();
    }

    @Override
    public void release() {
        this.readLatch.releaseIfOwner();
    }

    boolean getRewriteAllowed() {
        return this.rewriteAllowed;
    }

    void setRewriteAllowed() {
        this.rewriteAllowed = true;
    }

    public LogBufferSegment allocate(int size) {
        assert (this.readLatch.isExclusiveOwner());
        if (this.hasRoom(size)) {
            ByteBuffer buf = ByteBuffer.wrap(this.data, this.buffer.position(), size);
            this.buffer.position(this.buffer.position() + size);
            this.writePinCount.incrementAndGet();
            return new LogBufferSegment(this, buf);
        }
        return null;
    }

    public void free() {
        this.writePinCount.decrementAndGet();
    }

    public void waitForZeroAndLatch() {
        boolean done = false;
        while (!done) {
            if (this.writePinCount.get() > 0) {
                LockSupport.parkNanos(this, 100L);
                if (!Thread.interrupted()) continue;
                throw new ThreadInterruptedException(this.env, "Interrupt during read operation");
            }
            this.readLatch.acquireExclusive();
            if (this.writePinCount.get() == 0) {
                done = true;
                continue;
            }
            this.readLatch.release();
        }
    }

    @Override
    public ByteBuffer getBytes(long fileOffset) {
        ByteBuffer copy = this.buffer.duplicate();
        copy.position((int)(fileOffset - DbLsn.getFileOffset(this.firstLsn)));
        return copy;
    }

    @Override
    public ByteBuffer getBytes(long fileOffset, int numBytes) {
        return this.getBytes(fileOffset);
    }

    @Override
    public int getLogVersion() {
        return 17;
    }

    public String toString() {
        return "[LogBuffer firstLsn=" + DbLsn.getNoFormatString(this.firstLsn) + "]";
    }
}

