/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.regionserver.MetricsHeapMemoryManagerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsHeapMemoryManager {
    private final MetricsHeapMemoryManagerSource source;

    public MetricsHeapMemoryManager() {
        this(CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).getHeapMemoryManager());
    }

    public MetricsHeapMemoryManager(MetricsHeapMemoryManagerSource source) {
        this.source = source;
    }

    public MetricsHeapMemoryManagerSource getMetricsSource() {
        return this.source;
    }

    public void updateBlockedFlushCount(long blockedFlushCount) {
        this.source.updateBlockedFlushCount(blockedFlushCount);
    }

    public void updateUnblockedFlushCount(long unblockedFlushCount) {
        this.source.updateUnblockedFlushCount(unblockedFlushCount);
    }

    public void setCurBlockCacheSizeGauge(long blockCacheSize) {
        this.source.setCurBlockCacheSizeGauge(blockCacheSize);
    }

    public void setCurMemStoreSizeGauge(long memStoreSize) {
        this.source.setCurMemStoreSizeGauge(memStoreSize);
    }

    public void updateMemStoreDeltaSizeHistogram(int memStoreDeltaSize) {
        this.source.updateMemStoreDeltaSizeHistogram(memStoreDeltaSize);
    }

    public void updateBlockCacheDeltaSizeHistogram(int blockCacheDeltaSize) {
        this.source.updateBlockCacheDeltaSizeHistogram(blockCacheDeltaSize);
    }

    public void increaseTunerDoNothingCounter() {
        this.source.increaseTunerDoNothingCounter();
    }

    public void increaseAboveHeapOccupancyLowWatermarkCounter() {
        this.source.increaseAboveHeapOccupancyLowWatermarkCounter();
    }
}

