/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RpcServerFactory {
    public static final Logger LOG = LoggerFactory.getLogger(RpcServerFactory.class);
    public static final String CUSTOM_RPC_SERVER_IMPL_CONF_KEY = "hbase.rpc.server.impl";

    private RpcServerFactory() {
    }

    public static RpcServer createRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler) throws IOException {
        return RpcServerFactory.createRpcServer(server, name, services, bindAddress, conf, scheduler, true);
    }

    public static RpcServer createRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler, boolean reservoirEnabled) throws IOException {
        String rpcServerClass = conf.get(CUSTOM_RPC_SERVER_IMPL_CONF_KEY, NettyRpcServer.class.getName());
        StringBuilder servicesList = new StringBuilder();
        for (RpcServer.BlockingServiceAndInterface s : services) {
            Descriptors.ServiceDescriptor sd = s.getBlockingService().getDescriptorForType();
            if (sd == null) continue;
            if (servicesList.length() > 0) {
                servicesList.append(", ");
            }
            servicesList.append(sd.getFullName());
        }
        LOG.info("Creating " + rpcServerClass + " hosting " + servicesList);
        return (RpcServer)ReflectionUtils.instantiateWithCustomCtor(rpcServerClass, new Class[]{Server.class, String.class, List.class, InetSocketAddress.class, Configuration.class, RpcScheduler.class, Boolean.TYPE}, new Object[]{server, name, services, bindAddress, conf, scheduler, reservoirEnabled});
    }
}

