/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.SubsetConfiguration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class GraphiteSink
implements MetricsSink,
Closeable {
    private static final Log LOG = LogFactory.getLog(GraphiteSink.class);
    private static final String SERVER_HOST_KEY = "server_host";
    private static final String SERVER_PORT_KEY = "server_port";
    private static final String METRICS_PREFIX = "metrics_prefix";
    private String metricsPrefix = null;
    private Graphite graphite = null;

    @Override
    public void init(SubsetConfiguration conf) {
        String serverHost = conf.getString(SERVER_HOST_KEY);
        int serverPort = Integer.parseInt(conf.getString(SERVER_PORT_KEY));
        this.metricsPrefix = conf.getString(METRICS_PREFIX);
        if (this.metricsPrefix == null) {
            this.metricsPrefix = "";
        }
        this.graphite = new Graphite(serverHost, serverPort);
        this.graphite.connect();
    }

    @Override
    public void putMetrics(MetricsRecord record) {
        StringBuilder lines = new StringBuilder();
        StringBuilder metricsPathPrefix = new StringBuilder();
        metricsPathPrefix.append(this.metricsPrefix).append(".").append(record.context()).append(".").append(record.name());
        for (MetricsTag tag : record.tags()) {
            if (tag.value() == null) continue;
            metricsPathPrefix.append(".");
            metricsPathPrefix.append(tag.name());
            metricsPathPrefix.append("=");
            metricsPathPrefix.append(tag.value());
        }
        long timestamp = record.timestamp() / 1000L;
        for (AbstractMetric metric : record.metrics()) {
            lines.append(metricsPathPrefix.toString() + "." + metric.name().replace(' ', '.')).append(" ").append(metric.value()).append(" ").append(timestamp).append("\n");
        }
        try {
            this.graphite.write(lines.toString());
        }
        catch (Exception e) {
            LOG.warn((Object)"Error sending metrics to Graphite", (Throwable)e);
            try {
                this.graphite.close();
            }
            catch (Exception e1) {
                throw new MetricsException("Error closing connection to Graphite", e1);
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.graphite.flush();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error flushing metrics to Graphite", (Throwable)e);
            try {
                this.graphite.close();
            }
            catch (Exception e1) {
                throw new MetricsException("Error closing connection to Graphite", e1);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.graphite.close();
    }

    public static class Graphite {
        private static final int MAX_CONNECTION_FAILURES = 5;
        private String serverHost;
        private int serverPort;
        private Writer writer = null;
        private Socket socket = null;
        private int connectionFailures = 0;

        public Graphite(String serverHost, int serverPort) {
            this.serverHost = serverHost;
            this.serverPort = serverPort;
        }

        public void connect() {
            if (this.isConnected()) {
                throw new MetricsException("Already connected to Graphite");
            }
            if (this.tooManyConnectionFailures()) {
                return;
            }
            try {
                this.socket = new Socket(this.serverHost, this.serverPort);
                this.writer = new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                ++this.connectionFailures;
                if (this.tooManyConnectionFailures()) {
                    LOG.error((Object)"Too many connection failures, would not try to connect again.");
                }
                throw new MetricsException("Error creating connection, " + this.serverHost + ":" + this.serverPort, e);
            }
        }

        public void write(String msg) throws IOException {
            if (!this.isConnected()) {
                this.connect();
            }
            if (this.isConnected()) {
                this.writer.write(msg);
            }
        }

        public void flush() throws IOException {
            if (this.isConnected()) {
                this.writer.flush();
            }
        }

        public boolean isConnected() {
            return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
            }
            catch (IOException ex) {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            finally {
                this.socket = null;
                this.writer = null;
            }
        }

        private boolean tooManyConnectionFailures() {
            return this.connectionFailures > 5;
        }
    }
}

