/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SingleColumnValueFilter
extends FilterBase {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    protected CompareOperator op;
    protected ByteArrayComparable comparator;
    protected boolean foundColumn = false;
    protected boolean matchedColumn = false;
    protected boolean filterIfMissing = false;
    protected boolean latestVersionOnly = true;

    @Deprecated
    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value) {
        this(family, qualifier, CompareOperator.valueOf(compareOp.name()), (ByteArrayComparable)new BinaryComparator(value));
    }

    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareOperator op, byte[] value) {
        this(family, qualifier, op, (ByteArrayComparable)new BinaryComparator(value));
    }

    @Deprecated
    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator) {
        this(family, qualifier, CompareOperator.valueOf(compareOp.name()), comparator);
    }

    public SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator) {
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.op = op;
        this.comparator = comparator;
    }

    @Deprecated
    protected SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, boolean filterIfMissing, boolean latestVersionOnly) {
        this(family, qualifier, CompareOperator.valueOf(compareOp.name()), comparator, filterIfMissing, latestVersionOnly);
    }

    protected SingleColumnValueFilter(byte[] family, byte[] qualifier, CompareOperator op, ByteArrayComparable comparator, boolean filterIfMissing, boolean latestVersionOnly) {
        this(family, qualifier, op, comparator);
        this.filterIfMissing = filterIfMissing;
        this.latestVersionOnly = latestVersionOnly;
    }

    @Deprecated
    public CompareFilter.CompareOp getOperator() {
        return CompareFilter.CompareOp.valueOf(this.op.name());
    }

    public CompareOperator getCompareOperator() {
        return this.op;
    }

    public ByteArrayComparable getComparator() {
        return this.comparator;
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.matchedColumn) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.latestVersionOnly && this.foundColumn) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        if (!CellUtil.matchingColumn(c, this.columnFamily, this.columnQualifier)) {
            return Filter.ReturnCode.INCLUDE;
        }
        this.foundColumn = true;
        if (this.filterColumnValue(c)) {
            return this.latestVersionOnly ? Filter.ReturnCode.NEXT_ROW : Filter.ReturnCode.INCLUDE;
        }
        this.matchedColumn = true;
        return Filter.ReturnCode.INCLUDE;
    }

    private boolean filterColumnValue(Cell cell) {
        int compareResult = PrivateCellUtil.compareValue(cell, this.comparator);
        return CompareFilter.compare(this.op, compareResult);
    }

    @Override
    public boolean filterRow() {
        return this.foundColumn ? !this.matchedColumn : this.filterIfMissing;
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public void reset() {
        this.foundColumn = false;
        this.matchedColumn = false;
    }

    public boolean getFilterIfMissing() {
        return this.filterIfMissing;
    }

    public void setFilterIfMissing(boolean filterIfMissing) {
        this.filterIfMissing = filterIfMissing;
    }

    public boolean getLatestVersionOnly() {
        return this.latestVersionOnly;
    }

    public void setLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 4 || filterArguments.size() == 6, "Expected 4 or 6 but got: %s", filterArguments.size());
        byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
        CompareOperator op = ParseFilter.createCompareOperator(filterArguments.get(2));
        ByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(3)));
        if ((comparator instanceof RegexStringComparator || comparator instanceof SubstringComparator) && op != CompareOperator.EQUAL && op != CompareOperator.NOT_EQUAL) {
            throw new IllegalArgumentException("A regexstring comparator and substring comparator can only be used with EQUAL and NOT_EQUAL");
        }
        SingleColumnValueFilter filter = new SingleColumnValueFilter(family, qualifier, op, comparator);
        if (filterArguments.size() == 6) {
            boolean filterIfMissing = ParseFilter.convertByteArrayToBoolean(filterArguments.get(4));
            boolean latestVersionOnly = ParseFilter.convertByteArrayToBoolean(filterArguments.get(5));
            filter.setFilterIfMissing(filterIfMissing);
            filter.setLatestVersionOnly(latestVersionOnly);
        }
        return filter;
    }

    FilterProtos.SingleColumnValueFilter convert() {
        FilterProtos.SingleColumnValueFilter.Builder builder = FilterProtos.SingleColumnValueFilter.newBuilder();
        if (this.columnFamily != null) {
            builder.setColumnFamily(UnsafeByteOperations.unsafeWrap(this.columnFamily));
        }
        if (this.columnQualifier != null) {
            builder.setColumnQualifier(UnsafeByteOperations.unsafeWrap(this.columnQualifier));
        }
        HBaseProtos.CompareType compareOp = HBaseProtos.CompareType.valueOf(this.op.name());
        builder.setCompareOp(compareOp);
        builder.setComparator(ProtobufUtil.toComparator(this.comparator));
        builder.setFilterIfMissing(this.filterIfMissing);
        builder.setLatestVersionOnly(this.latestVersionOnly);
        return builder.build();
    }

    @Override
    public byte[] toByteArray() {
        return this.convert().toByteArray();
    }

    public static SingleColumnValueFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        ByteArrayComparable comparator;
        FilterProtos.SingleColumnValueFilter proto;
        try {
            proto = FilterProtos.SingleColumnValueFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        CompareOperator compareOp = CompareOperator.valueOf(proto.getCompareOp().name());
        try {
            comparator = ProtobufUtil.toComparator(proto.getComparator());
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new SingleColumnValueFilter(proto.hasColumnFamily() ? proto.getColumnFamily().toByteArray() : null, proto.hasColumnQualifier() ? proto.getColumnQualifier().toByteArray() : null, compareOp, comparator, proto.getFilterIfMissing(), proto.getLatestVersionOnly());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleColumnValueFilter)) {
            return false;
        }
        SingleColumnValueFilter other = (SingleColumnValueFilter)o;
        return Bytes.equals(this.getFamily(), other.getFamily()) && Bytes.equals(this.getQualifier(), other.getQualifier()) && this.op.equals((Object)other.op) && this.getComparator().areSerializedFieldsEqual(other.getComparator()) && this.getFilterIfMissing() == other.getFilterIfMissing() && this.getLatestVersionOnly() == other.getLatestVersionOnly();
    }

    @Override
    public boolean isFamilyEssential(byte[] name) {
        return !this.filterIfMissing || Bytes.equals(name, this.columnFamily);
    }

    @Override
    public String toString() {
        return String.format("%s (%s, %s, %s, %s)", this.getClass().getSimpleName(), Bytes.toStringBinary(this.columnFamily), Bytes.toStringBinary(this.columnQualifier), this.op.name(), Bytes.toStringBinary(this.comparator.getValue()));
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Bytes.hashCode(this.getFamily()), Bytes.hashCode(this.getQualifier()), this.op, this.getComparator(), this.getFilterIfMissing(), this.getLatestVersionOnly()});
    }
}

