/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinStringConstantsVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.TraversalEnumParser;
import org.apache.tinkerpop.gremlin.language.grammar.TraversalStrategyVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.TraversalTerminalMethodVisitor;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class GenericLiteralVisitor
extends DefaultGremlinBaseVisitor<Object> {
    public static final int TOTAL_INTEGER_RANGE_RESULT_COUNT_LIMIT = 1000000;
    protected final GremlinAntlrToJava antlr;
    protected DefaultGremlinBaseVisitor<TraversalStrategy> traversalStrategyVisitor;
    private static GenericLiteralVisitor instance;

    private GenericLiteralVisitor() {
        this.antlr = null;
    }

    public GenericLiteralVisitor(GremlinAntlrToJava antlr) {
        this.antlr = antlr;
    }

    public static GenericLiteralVisitor getInstance() {
        if (instance == null) {
            instance = new GenericLiteralVisitor();
        }
        return instance;
    }

    public static String getStringLiteral(GremlinParser.StringLiteralContext stringLiteral) {
        return (String)GenericLiteralVisitor.getInstance().visitStringLiteral(stringLiteral);
    }

    public static boolean getBooleanLiteral(GremlinParser.BooleanLiteralContext booleanLiteral) {
        return (Boolean)GenericLiteralVisitor.getInstance().visitBooleanLiteral(booleanLiteral);
    }

    public static String[] getStringLiteralList(GremlinParser.StringLiteralListContext stringLiteralList) {
        if (stringLiteralList == null || stringLiteralList.stringLiteralExpr() == null) {
            return new String[0];
        }
        return (String[])stringLiteralList.stringLiteralExpr().stringLiteral().stream().filter(Objects::nonNull).map(stringLiteral -> GenericLiteralVisitor.getInstance().visitStringLiteral((GremlinParser.StringLiteralContext)stringLiteral)).toArray(String[]::new);
    }

    public static Object[] getGenericLiteralList(GremlinParser.GenericLiteralListContext objectLiteralList) {
        if (objectLiteralList == null || objectLiteralList.genericLiteralExpr() == null) {
            return new Object[0];
        }
        return objectLiteralList.genericLiteralExpr().genericLiteral().stream().filter(Objects::nonNull).map(genericLiteral -> GenericLiteralVisitor.getInstance().visitGenericLiteral((GremlinParser.GenericLiteralContext)genericLiteral)).toArray(Object[]::new);
    }

    public static TraversalStrategy[] getTraversalStrategyList(GremlinParser.TraversalStrategyListContext traversalStrategyListContext, DefaultGremlinBaseVisitor<TraversalStrategy> traversalStrategyVisitor) {
        if (traversalStrategyListContext == null || traversalStrategyListContext.traversalStrategyExpr() == null) {
            return new TraversalStrategy[0];
        }
        return (TraversalStrategy[])traversalStrategyListContext.traversalStrategyExpr().traversalStrategy().stream().filter(Objects::nonNull).map(tstrat -> (TraversalStrategy)traversalStrategyVisitor.visitTraversalStrategy((GremlinParser.TraversalStrategyContext)tstrat)).toArray(TraversalStrategy[]::new);
    }

    private static String stripQuotes(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }

    private static Object createIntegerRange(int start, int end, String range) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int total_result_count = Math.abs(start - end);
        if (total_result_count > 1000000) {
            throw new IllegalArgumentException("Range " + range + " is too wide. Current limit is " + 1000000 + " items");
        }
        if (start <= end) {
            for (int cur = start; cur <= end; ++cur) {
                results.add(cur);
            }
        } else {
            for (int cur = start; cur >= end; --cur) {
                results.add(cur);
            }
        }
        return results;
    }

    private static Object createStringRange(String start, String end, String range) {
        char endLastCharacter;
        ArrayList<String> results = new ArrayList<String>();
        if (start.length() != end.length()) {
            throw new IllegalArgumentException("The start and end of Range " + range + " does not have same number of characters");
        }
        if (start.isEmpty()) {
            return results;
        }
        String commonPrefix = start.substring(0, start.length() - 1);
        if (!end.startsWith(commonPrefix)) {
            throw new IllegalArgumentException("The start and end of Range " + range + " does not share same prefix until the last character");
        }
        char startLastCharacter = start.charAt(start.length() - 1);
        if (startLastCharacter <= (endLastCharacter = end.charAt(end.length() - 1))) {
            for (char cur = startLastCharacter; cur <= endLastCharacter; cur = (char)(cur + '\u0001')) {
                results.add(commonPrefix + cur);
            }
        } else {
            for (char cur = startLastCharacter; cur >= endLastCharacter; cur = (char)(cur - '\u0001')) {
                results.add(commonPrefix + cur);
            }
        }
        return results;
    }

    @Override
    public Object visitGenericLiteralList(GremlinParser.GenericLiteralListContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Object visitGenericLiteralExpr(GremlinParser.GenericLiteralExprContext ctx) {
        int childCount = ctx.getChildCount();
        switch (childCount) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                return this.visitGenericLiteral((GremlinParser.GenericLiteralContext)ctx.getChild(0));
            }
        }
        ArrayList<Object> genericLiterals = new ArrayList<Object>();
        for (int childIndex = 0; childIndex < ctx.getChildCount(); childIndex += 2) {
            genericLiterals.add(this.visitGenericLiteral((GremlinParser.GenericLiteralContext)ctx.getChild(childIndex)));
        }
        return genericLiterals.toArray();
    }

    @Override
    public Object visitGenericLiteral(GremlinParser.GenericLiteralContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Object visitGenericLiteralMap(GremlinParser.GenericLiteralMapContext ctx) {
        HashMap<Object, Object> literalMap = new HashMap<Object, Object>();
        for (int childIndex = 1; childIndex < ctx.getChildCount() && ctx.getChildCount() > 3; childIndex += 2) {
            Object key = this.visitGenericLiteral((GremlinParser.GenericLiteralContext)ctx.getChild(childIndex));
            Object value = this.visitGenericLiteral((GremlinParser.GenericLiteralContext)ctx.getChild(childIndex += 2));
            literalMap.put(key, value);
        }
        return literalMap;
    }

    @Override
    public Object visitNestedTraversal(GremlinParser.NestedTraversalContext ctx) {
        return this.antlr.tvisitor.visitNestedTraversal(ctx);
    }

    @Override
    public Object visitTerminatedTraversal(GremlinParser.TerminatedTraversalContext ctx) {
        Traversal traversal = this.antlr.tvisitor.visitRootTraversal((GremlinParser.RootTraversalContext)ctx.getChild(0));
        return new TraversalTerminalMethodVisitor(traversal).visitTraversalTerminalMethod((GremlinParser.TraversalTerminalMethodContext)ctx.getChild(2));
    }

    @Override
    public Object visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        int lastCharIndex;
        String integerLiteral = ctx.getText().toLowerCase().replace("_", "");
        if (integerLiteral.charAt(lastCharIndex = integerLiteral.length() - 1) == 'l') {
            integerLiteral = integerLiteral.substring(0, lastCharIndex);
            return Long.decode(integerLiteral);
        }
        try {
            return Integer.decode(integerLiteral);
        }
        catch (NumberFormatException ignoredExpection1) {
            try {
                return Long.decode(integerLiteral);
            }
            catch (NumberFormatException ignoredExpection2) {
                boolean negative;
                int startIndex = 0;
                char firstChar = integerLiteral.charAt(0);
                boolean bl = negative = firstChar == '-';
                if (firstChar == '-' || firstChar == '+') {
                    ++startIndex;
                }
                int radix = 10;
                if (integerLiteral.charAt(startIndex + 1) == 'x') {
                    radix = 16;
                    integerLiteral = integerLiteral.substring(startIndex += 2);
                    if (negative) {
                        integerLiteral = '-' + integerLiteral;
                    }
                } else if (integerLiteral.charAt(startIndex) == '0') {
                    radix = 8;
                }
                return new BigInteger(integerLiteral, radix);
            }
        }
    }

    @Override
    public Object visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        String floatLiteral = ctx.getText().toLowerCase();
        char lastCharacter = floatLiteral.charAt(floatLiteral.length() - 1);
        if (Character.isDigit(lastCharacter)) {
            return new BigDecimal(floatLiteral);
        }
        if (lastCharacter == 'f') {
            return new Float(ctx.getText());
        }
        return new Double(floatLiteral);
    }

    @Override
    public Object visitBooleanLiteral(GremlinParser.BooleanLiteralContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        return DatetimeHelper.parse(GenericLiteralVisitor.getStringLiteral(ctx.stringLiteral()));
    }

    @Override
    public Object visitStringLiteral(GremlinParser.StringLiteralContext ctx) {
        if (ctx.gremlinStringConstants() != null) {
            return GremlinStringConstantsVisitor.getInstance().visitChildren((RuleNode)ctx);
        }
        if (ctx.NullLiteral() != null) {
            return GremlinStringConstantsVisitor.getInstance().visitChildren((RuleNode)ctx);
        }
        return StringEscapeUtils.unescapeJava((String)GenericLiteralVisitor.stripQuotes(ctx.getText()));
    }

    @Override
    public Object visitTraversalToken(GremlinParser.TraversalTokenContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(T.class, ctx);
    }

    @Override
    public Object visitTraversalCardinality(GremlinParser.TraversalCardinalityContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(VertexProperty.Cardinality.class, ctx);
    }

    @Override
    public Object visitTraversalDirection(GremlinParser.TraversalDirectionContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(Direction.class, ctx);
    }

    @Override
    public Object visitTraversalOptionParent(GremlinParser.TraversalOptionParentContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(TraversalOptionParent.Pick.class, ctx);
    }

    @Override
    public Object visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (null == this.traversalStrategyVisitor) {
            this.traversalStrategyVisitor = new TraversalStrategyVisitor(this.antlr.tvisitor);
        }
        return this.traversalStrategyVisitor.visitTraversalStrategy(ctx);
    }

    @Override
    public Object visitGenericLiteralRange(GremlinParser.GenericLiteralRangeContext ctx) {
        boolean childIndexOfParameterStart = false;
        int childIndexOfParameterEnd = 3;
        ParseTree startContext = ctx.getChild(0);
        ParseTree endContext = ctx.getChild(3);
        if (startContext instanceof GremlinParser.IntegerLiteralContext) {
            int start = Integer.valueOf(startContext.getText());
            int end = Integer.valueOf(endContext.getText());
            return GenericLiteralVisitor.createIntegerRange(start, end, ctx.getText());
        }
        String start = GenericLiteralVisitor.stripQuotes(startContext.getText());
        String end = GenericLiteralVisitor.stripQuotes(endContext.getText());
        return GenericLiteralVisitor.createStringRange(start, end, ctx.getText());
    }

    @Override
    public Object visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        return null;
    }

    @Override
    public Object visitGenericLiteralCollection(GremlinParser.GenericLiteralCollectionContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>(ctx.getChildCount() / 2);
        int childCount = ctx.getChildCount();
        if (childCount > 2) {
            for (int childIndex = 1; childIndex < childCount; childIndex += 2) {
                result.add(this.visitGenericLiteral((GremlinParser.GenericLiteralContext)ctx.getChild(childIndex)));
            }
        }
        return result;
    }
}

